package CSanScenGenerator;

import java.util.*;
import java.io.*;
import java.sql.*;
import java.text.DecimalFormat;

/**
 *
 * @author Peter
 */
public class InfluenceKindRate {
 
    private static Map<Integer, InfluenceKindRate> influences;
    private int id;
    private int weaponRate;
    private int bookRate;
    private int horseRate;
    private int[] titleRate = new int[TypedOfficer.NUMBER_OF_TYPES];
    private boolean isBattle;
    private double leaderProb;
    private double baseValue;
    private boolean baseValueInverse;
    private double buildingRate;
    private boolean buildingRateInverse;
    private double paramMin;
    private double paramMax;
    private boolean integralParam;
    
    private String description;

    private static Map<Integer, InfluenceKindRate> getInfluenceKindRates() throws IOException, SQLException {
        if (influences == null) {
            influences = new HashMap<Integer, InfluenceKindRate>();
            BufferedReader f = new BufferedReader(new InputStreamReader(new FileInputStream("DATA/influenceKind.txt"), "UTF-8"));
            while (true) {
                //read rates
                InfluenceKindRate r = new InfluenceKindRate();
                String line = f.readLine();
                if (line == null) {
                    break;
                }
                String[] s = line.split("\\s");
                r.id = Integer.parseInt(s[0]);
                r.weaponRate = Integer.parseInt(s[1]);
                r.bookRate = Integer.parseInt(s[2]);
                r.horseRate = Integer.parseInt(s[3]);
                r.baseValue = Double.parseDouble(s[4]);
                r.baseValueInverse = s[5].equals("1") ? true : false;
                r.buildingRate = Double.parseDouble(s[6]);
                r.buildingRateInverse = s[7].equals("1") ? true: false;
                try {
                    r.paramMin = Integer.parseInt(s[8]);
                    r.paramMax = Integer.parseInt(s[9]);
                    r.integralParam = true;
                } catch (NumberFormatException ex){
                    r.paramMin = Double.parseDouble(s[8]);
                    r.paramMax = Double.parseDouble(s[9]);
                    r.integralParam = false;
                }   
                
                for (int i = 0; i < TypedOfficer.NUMBER_OF_TYPES; ++i) {
                    r.titleRate[i] = Integer.parseInt(s[i + 10]);
                }
                r.isBattle = s[TypedOfficer.NUMBER_OF_TYPES + 10].equals("1") ? true : false;
                r.leaderProb = Double.parseDouble(s[TypedOfficer.NUMBER_OF_TYPES + 11]);
                r.description = s[TypedOfficer.NUMBER_OF_TYPES + 12];
                influences.put(r.id, r);
            }
            f.close();
        }
        return influences;
    }

    public static Map<Integer, InfluenceRate> generateInfluences(Connection commonData, int cnt) throws IOException, SQLException{
        //delete generated things
        commonData.createStatement().execute("delete from Influence where ID >= 10000");
        
        Map<Integer, InfluenceKindRate> kinds = getInfluenceKindRates();
        Map<Integer, InfluenceRate> result = new HashMap<Integer, InfluenceRate>();
        for (int i = 0; i < cnt; ++i){
            InfluenceRate r = new InfluenceRate();
            r.id = 10000 + i;
            
            //randomly pick a kind
            InfluenceKindRate k = Utility.randomPick(kinds.values());
            
            //copy over prob data
            r.bookRate = k.bookRate;
            r.horseRate = k.horseRate;
            r.weaponRate = k.weaponRate;
            r.leaderProb = k.leaderProb;
            r.isBattle = k.isBattle;
            r.titleRate = Arrays.copyOf(k.titleRate, k.titleRate.length);

            //generate parameter
            String desc = k.description;
            double param;
            if (k.integralParam){
                int lo = (int) Math.round(k.paramMin);
                int hi = (int) Math.round(k.paramMax);
                //params are int
                int paramI = Utility.randBetween(lo, hi);
                desc = desc.replace("$i", Integer.toString(paramI))
                    .replace("$d", Integer.toString(paramI)).replace("$f", Integer.toString(paramI * 100))
                    .replace("$e", Integer.toString((1 - paramI) * 100)).replace("$m", Double.toString(paramI * 10000));
                param = paramI;
            } else {
                //params are double
                double lo = k.paramMin;
                double hi = k.paramMax;
                param = Utility.randBetween(lo, hi);
                param = Utility.roundToSignificantFigures(param, 2);
                //put params into string
                DecimalFormat df2 = new DecimalFormat("0.00");
                DecimalFormat df = new DecimalFormat("0");
                desc = desc.replace("$i", df2.format(param))
                    .replace("$d", df.format(param * 100)).replace("$f", df.format((param - 1) * 100))
                    .replace("$e", df.format((1 - param) * 100)).replace("$m", df.format(param * 10000));
            }
            
            //compute cost
            if (k.baseValueInverse){
                r.actualValue = (int) Math.round(k.baseValue / param);
            } else {
                r.actualValue = (int) Math.round(k.baseValue * param);
            }
            if (k.buildingRateInverse){
                r.buildingRate = (int) Math.round(k.buildingRate / param);
            } else {
                r.buildingRate = (int) Math.round(k.buildingRate / param);
            }
            
            PreparedStatement stmt = commonData.prepareStatement(
                        "insert into Influence (ID, Kind, Name, Description, Parameter, Parameter2) values (?, ?, ?, ?, ?, ?)");
            stmt.setInt(1, r.id);
            stmt.setInt(2, k.id);
            
            //handle special things and write to db
            if (desc.contains("$t")){
                //terrain
                int terrain = Utility.randBetween(1, 9);
                if (terrain >= 7) terrain++; //skip mountains
                String terrainString = "";
                double costMod = 1;
                switch (terrain){
                    case 1: terrainString = "平原"; costMod = 2; break;
                    case 2: terrainString = "草原"; costMod = 2; break;
                    case 3: terrainString = "森林"; break;
                    case 4: terrainString = "湿地"; costMod = 0.5; break;
                    case 5: terrainString = "山地"; break;
                    case 6: terrainString = "水域"; costMod = 1.5; break;
                    case 8: terrainString = "荒地"; break;
                    case 9: terrainString = "沙漠"; costMod = 0.5; break;
                    case 10: terrainString = "雪地"; costMod = 0.5; break;
                }
                r.actualValue *= costMod;
                desc = desc.replace("$t", terrainString);
                
                //prepare parameters
                stmt.setString(3, desc);
                stmt.setString(4, desc);
                stmt.setInt(5, terrain);
                stmt.setDouble(6, param);
            } else if (desc.contains("$s")){
                //military kind
                int military = Utility.randBetween(0, 4);
                String militaryString = "";
                switch (military){
                    case 0: militaryString = "步兵"; break;
                    case 1: militaryString = "弩兵"; break;
                    case 2: militaryString = "騎兵"; break;
                    case 3: militaryString = "水軍"; break;
                    case 4: militaryString = "器械"; break;
                }
                desc = desc.replace("$s", militaryString);
                
                //prepare parameters
                stmt.setString(3, desc);
                stmt.setString(4, desc);
                stmt.setInt(5, military);
                stmt.setDouble(6, param);
            } else if (desc.contains("$z")){
                //disaster
                int disaster = Utility.randBetween(0, 5);
                String disasterString = "";
                switch (disaster){
                    case 0: disasterString = "水災"; break;
                    case 1: disasterString = "旱災"; break;
                    case 2: disasterString = "地震"; break;
                    case 3: disasterString = "蝗災"; break;
                    case 4: disasterString = "瘟疫"; break;
                    case 5: disasterString = "風災"; break;
                }
                desc = desc.replace("$z", disasterString);
                
                //prepare parameters
                stmt.setString(3, desc);
                stmt.setString(4, desc);
                stmt.setInt(5, disaster);
                stmt.setDouble(6, param);
            } else {
                //standard
                stmt.setString(3, desc);
                stmt.setString(4, desc);
                stmt.setDouble(5, param);
                //for Kind 352 capped water capability and 6140 decrease loyalty capped by loyalty
                if (k.id == 352 || k.id == 6140){
                    stmt.setInt(6, 1);
                } else {
                    stmt.setString(6, "");
                }
            }
            
            r.description = desc;
            
            //finally, put to db
            stmt.executeUpdate();
            
            result.put(r.id, r);
        }
        
        return result;
    }
    
}
