/*
 * Frontend.java
 *
 * Created on 2011年7月1日, 下午07:28:29
 *
 */
package CSanScenGenerator.frontend;

import java.io.*;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.*;
import javax.swing.UnsupportedLookAndFeelException;
import CSanScenGenerator.*;
import java.sql.*;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

/**
 *
 * @author Peter
 */
public class Frontend extends javax.swing.JFrame {

    public static final int MAX_OFFICER = 5000;
    public static final String APP_NAME = "中華三國志劇本生成器(v3.1) by 耒戈氏";
    public static final String SETTING_FILE_EXTENSION = "ORSET";
    final JFileChooser settingFileChooser, gamePathChooser;
    private String gamePath;
    private static boolean tc;

    public static boolean isTc() {
        return tc;
    }

    /** Creates new form Frontend */
    public Frontend() {

        initComponents();

        gamePathChooser = new JFileChooser();
        gamePathChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);

        try {
            BufferedReader br = new BufferedReader(new FileReader("CSSG.ini"));
            gamePath = br.readLine();
            gamePathChooser.setCurrentDirectory(new File(gamePath));
            br.close();
        } catch (Exception ex) {
            try {
                new File("CSSG.ini").createNewFile();
                gamePathChooser.setDialogTitle("設置遊戲路徑");
                gamePathChooser.showOpenDialog(null);
                if (gamePathChooser.getSelectedFile() != null) {
                    gamePath = gamePathChooser.getSelectedFile().getAbsolutePath();
                }
            } catch (Exception ex2) {
                ex2.printStackTrace();
            }
        }
        try {
            loadSetting(new File("last.ORSET"));
        } catch (Exception ex) {
        }

        settingFileChooser = new JFileChooser();
        settingFileChooser.addChoosableFileFilter(new javax.swing.filechooser.FileFilter() {

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().toUpperCase().endsWith(SETTING_FILE_EXTENSION) || pathname.isDirectory();
            }

            @Override
            public String getDescription() {
                return "中華三國志劇本生成器設定檔(*." + SETTING_FILE_EXTENSION + ")";
            }
        });
        settingFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));

    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        faceRadioGroup = new javax.swing.ButtonGroup();
        selectedRandomizeOfficerButtonGroup = new javax.swing.ButtonGroup();
        officerGenerationTypeGroup = new javax.swing.ButtonGroup();
        randomizeSpecialGroup = new javax.swing.ButtonGroup();
        teamGroup = new javax.swing.ButtonGroup();
        randomizeCountGroup = new javax.swing.ButtonGroup();
        bloodGroup = new javax.swing.ButtonGroup();
        brotherGroup = new javax.swing.ButtonGroup();
        bloodImitateGroup = new javax.swing.ButtonGroup();
        imitateGroup = new javax.swing.ButtonGroup();
        hateGroup = new javax.swing.ButtonGroup();
        factionTechniqueButtonGroup = new javax.swing.ButtonGroup();
        buttonGroup1 = new javax.swing.ButtonGroup();
        factionKingGroup = new javax.swing.ButtonGroup();
        openFileButton = new javax.swing.JButton();
        filePathLabel = new javax.swing.JLabel();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        femaleOfficerProbSlider = new javax.swing.JSlider();
        femaleOfficerProbLabel = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        doubleNameProbSlider = new javax.swing.JSlider();
        doubleNameProbLabel = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        randomFaceRadio = new javax.swing.JRadioButton();
        genderFaceRadio = new javax.swing.JRadioButton();
        typedFaceRadio = new javax.swing.JRadioButton();
        jPanel3 = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        debutYearLoText = new javax.swing.JTextField();
        debutYearHiText = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        bornYearLoText = new javax.swing.JTextField();
        jLabel6 = new javax.swing.JLabel();
        bornYearHiText = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        deadYearLoText = new javax.swing.JTextField();
        jLabel8 = new javax.swing.JLabel();
        deadYearHiText = new javax.swing.JTextField();
        jLabel9 = new javax.swing.JLabel();
        jLabel10 = new javax.swing.JLabel();
        scenYearLo = new javax.swing.JTextField();
        jLabel32 = new javax.swing.JLabel();
        scenYearHi = new javax.swing.JTextField();
        jLabel33 = new javax.swing.JLabel();
        jPanel5 = new javax.swing.JPanel();
        randomTypeOfficerRadio = new javax.swing.JRadioButton();
        typedOfficerRadio = new javax.swing.JRadioButton();
        officerTypePanel = new javax.swing.JPanel();
        jLabel14 = new javax.swing.JLabel();
        generalTypeWeightText = new javax.swing.JTextField();
        jLabel15 = new javax.swing.JLabel();
        mightyTypeWeightText = new javax.swing.JTextField();
        jLabel16 = new javax.swing.JLabel();
        advisorTypeWeightText = new javax.swing.JTextField();
        jLabel17 = new javax.swing.JLabel();
        politicianTypeWeightText = new javax.swing.JTextField();
        jLabel18 = new javax.swing.JLabel();
        intelGeneralTypeWeightText = new javax.swing.JTextField();
        jLabel19 = new javax.swing.JLabel();
        emperorTypeWeightText = new javax.swing.JTextField();
        jLabel20 = new javax.swing.JLabel();
        allRounderTypeWeightText = new javax.swing.JTextField();
        jLabel21 = new javax.swing.JLabel();
        normalTypeWeightText = new javax.swing.JTextField();
        jLabel22 = new javax.swing.JLabel();
        cheapTypeWeightText = new javax.swing.JTextField();
        jLabel31 = new javax.swing.JLabel();
        officerCntLoText = new javax.swing.JTextField();
        jLabel47 = new javax.swing.JLabel();
        officerCntHiText = new javax.swing.JTextField();
        jPanel8 = new javax.swing.JPanel();
        jLabel52 = new javax.swing.JLabel();
        reputationLoText = new javax.swing.JTextField();
        jLabel51 = new javax.swing.JLabel();
        reputationHiText = new javax.swing.JTextField();
        factionOfficerHiText = new javax.swing.JTextField();
        factionCntHiText = new javax.swing.JTextField();
        jLabel55 = new javax.swing.JLabel();
        jLabel50 = new javax.swing.JLabel();
        factionCntLoText = new javax.swing.JTextField();
        jLabel49 = new javax.swing.JLabel();
        jLabel53 = new javax.swing.JLabel();
        factionOfficerLoText = new javax.swing.JTextField();
        jLabel54 = new javax.swing.JLabel();
        jLabel38 = new javax.swing.JLabel();
        randomKingRadio = new javax.swing.JRadioButton();
        bestKingRadio = new javax.swing.JRadioButton();
        useScenOfficerCheckbox = new javax.swing.JCheckBox();
        jPanel4 = new javax.swing.JPanel();
        jPanel7 = new javax.swing.JPanel();
        jLabel23 = new javax.swing.JLabel();
        abilityMulText = new javax.swing.JTextField();
        jLabel24 = new javax.swing.JLabel();
        abilityAbsText = new javax.swing.JTextField();
        jLabel25 = new javax.swing.JLabel();
        abilityHiText = new javax.swing.JTextField();
        jLabel26 = new javax.swing.JLabel();
        abilityLoText = new javax.swing.JTextField();
        jPanel9 = new javax.swing.JPanel();
        jLabel28 = new javax.swing.JLabel();
        specialProbText = new javax.swing.JTextField();
        jLabel29 = new javax.swing.JLabel();
        specialAbyThresholdText = new javax.swing.JTextField();
        jLabel30 = new javax.swing.JLabel();
        specialAbyProbText = new javax.swing.JTextField();
        jPanel10 = new javax.swing.JPanel();
        jLabel35 = new javax.swing.JLabel();
        stuntProbText = new javax.swing.JTextField();
        jLabel36 = new javax.swing.JLabel();
        stuntAbyThresholdText = new javax.swing.JTextField();
        jLabel37 = new javax.swing.JLabel();
        stuntAbyProbText = new javax.swing.JTextField();
        jPanel12 = new javax.swing.JPanel();
        jLabel39 = new javax.swing.JLabel();
        noSpecialProb1Slider1 = new javax.swing.JSlider();
        noSpecialProb1Label = new javax.swing.JLabel();
        jLabel40 = new javax.swing.JLabel();
        noSpecialProb1Slider2 = new javax.swing.JSlider();
        noSpecialProb1Label1 = new javax.swing.JLabel();
        jLabel41 = new javax.swing.JLabel();
        noSpecialProb1Slider3 = new javax.swing.JSlider();
        noSpecialProb1Label2 = new javax.swing.JLabel();
        jLabel42 = new javax.swing.JLabel();
        noSpecialProb1Slider4 = new javax.swing.JSlider();
        noSpecialProb1Label3 = new javax.swing.JLabel();
        jLabel43 = new javax.swing.JLabel();
        noSpecialProb1Slider5 = new javax.swing.JSlider();
        noSpecialProb1Label4 = new javax.swing.JLabel();
        jLabel44 = new javax.swing.JLabel();
        noSpecialProb1Slider6 = new javax.swing.JSlider();
        noSpecialProb1Label5 = new javax.swing.JLabel();
        jLabel45 = new javax.swing.JLabel();
        noSpecialProb1Slider7 = new javax.swing.JSlider();
        noSpecialProb1Label6 = new javax.swing.JLabel();
        jLabel46 = new javax.swing.JLabel();
        noSpecialProb1Slider8 = new javax.swing.JSlider();
        noSpecialProb1Label7 = new javax.swing.JLabel();
        jLabel48 = new javax.swing.JLabel();
        noSpecialProb1Slider9 = new javax.swing.JSlider();
        noSpecialProb1Label8 = new javax.swing.JLabel();
        jLabel34 = new javax.swing.JLabel();
        jLabel11 = new javax.swing.JLabel();
        attachmentLoText = new javax.swing.JTextField();
        jLabel12 = new javax.swing.JLabel();
        attachmentHiText = new javax.swing.JTextField();
        popularityHiText = new javax.swing.JTextField();
        popularityLoText = new javax.swing.JTextField();
        jLabel27 = new javax.swing.JLabel();
        jLabel13 = new javax.swing.JLabel();
        jLabel56 = new javax.swing.JLabel();
        loyaltyLoText = new javax.swing.JTextField();
        jLabel57 = new javax.swing.JLabel();
        leaderPossibilityFactorText = new javax.swing.JTextField();
        jLabel161 = new javax.swing.JLabel();
        loyaltyHiText = new javax.swing.JTextField();
        jPanel26 = new javax.swing.JPanel();
        generatedTitleLevelHiText = new javax.swing.JTextField();
        jLabel163 = new javax.swing.JLabel();
        generatedTitleLevelLoText = new javax.swing.JTextField();
        jLabel164 = new javax.swing.JLabel();
        generatedTitleProbSlider = new javax.swing.JSlider();
        generatedTitleProbLabel = new javax.swing.JLabel();
        jLabel165 = new javax.swing.JLabel();
        jPanel6 = new javax.swing.JPanel();
        jPanel13 = new javax.swing.JPanel();
        agricultureLoText = new javax.swing.JTextField();
        jLabel58 = new javax.swing.JLabel();
        agricultureHiText = new javax.swing.JTextField();
        jLabel59 = new javax.swing.JLabel();
        jLabel60 = new javax.swing.JLabel();
        cropLoText = new javax.swing.JTextField();
        jLabel61 = new javax.swing.JLabel();
        cropHiText = new javax.swing.JTextField();
        jLabel62 = new javax.swing.JLabel();
        populationLoText = new javax.swing.JTextField();
        jLabel63 = new javax.swing.JLabel();
        populationHiText = new javax.swing.JTextField();
        jLabel66 = new javax.swing.JLabel();
        troopLoText = new javax.swing.JTextField();
        jLabel67 = new javax.swing.JLabel();
        troopHiText = new javax.swing.JTextField();
        jLabel68 = new javax.swing.JLabel();
        jLabel69 = new javax.swing.JLabel();
        jLabel70 = new javax.swing.JLabel();
        jLabel71 = new javax.swing.JLabel();
        jLabel93 = new javax.swing.JLabel();
        emperorLeastCitySizeText = new javax.swing.JTextField();
        jLabel94 = new javax.swing.JLabel();
        commerceLoText = new javax.swing.JTextField();
        jLabel95 = new javax.swing.JLabel();
        commerceHiText = new javax.swing.JTextField();
        jLabel96 = new javax.swing.JLabel();
        technologyLoText = new javax.swing.JTextField();
        jLabel97 = new javax.swing.JLabel();
        technologyHiText = new javax.swing.JTextField();
        jLabel98 = new javax.swing.JLabel();
        dominationLoText = new javax.swing.JTextField();
        jLabel99 = new javax.swing.JLabel();
        dominationHiText = new javax.swing.JTextField();
        jLabel100 = new javax.swing.JLabel();
        moraleLoText = new javax.swing.JTextField();
        jLabel101 = new javax.swing.JLabel();
        moraleHiText = new javax.swing.JTextField();
        jLabel102 = new javax.swing.JLabel();
        enduranceLoText = new javax.swing.JTextField();
        jLabel103 = new javax.swing.JLabel();
        enduranceHiText = new javax.swing.JTextField();
        jLabel104 = new javax.swing.JLabel();
        cashLoText = new javax.swing.JTextField();
        jLabel105 = new javax.swing.JLabel();
        cashHiText = new javax.swing.JTextField();
        jLabel157 = new javax.swing.JLabel();
        citySpecialtyProbSlider = new javax.swing.JSlider();
        citySpecialtyProbLabel = new javax.swing.JLabel();
        citySpecialtyThresholdText = new javax.swing.JTextField();
        jLabel158 = new javax.swing.JLabel();
        jPanel22 = new javax.swing.JPanel();
        jLabel64 = new javax.swing.JLabel();
        troopCntLoText = new javax.swing.JTextField();
        jLabel65 = new javax.swing.JLabel();
        troopCntHiText = new javax.swing.JTextField();
        jLabel142 = new javax.swing.JLabel();
        troopExpLoText = new javax.swing.JTextField();
        jLabel143 = new javax.swing.JLabel();
        troopExpHiText = new javax.swing.JTextField();
        jLabel144 = new javax.swing.JLabel();
        troopMoraleLoText = new javax.swing.JTextField();
        jLabel145 = new javax.swing.JLabel();
        troopMoraleHiText = new javax.swing.JTextField();
        jPanel18 = new javax.swing.JPanel();
        jLabel110 = new javax.swing.JLabel();
        strongFactionLoText = new javax.swing.JTextField();
        jLabel111 = new javax.swing.JLabel();
        strongFactionHiText = new javax.swing.JTextField();
        jPanel19 = new javax.swing.JPanel();
        jLabel112 = new javax.swing.JLabel();
        strongFactionCropLoText = new javax.swing.JTextField();
        jLabel113 = new javax.swing.JLabel();
        strongFactionCropHiText = new javax.swing.JTextField();
        jLabel114 = new javax.swing.JLabel();
        strongFactionPopulationLoText = new javax.swing.JTextField();
        jLabel115 = new javax.swing.JLabel();
        strongFactionPopulationHiText = new javax.swing.JTextField();
        jLabel116 = new javax.swing.JLabel();
        strongFactionTroopCntLoText = new javax.swing.JTextField();
        jLabel117 = new javax.swing.JLabel();
        strongFactionTroopCntHiText = new javax.swing.JTextField();
        jLabel118 = new javax.swing.JLabel();
        strongFactionTroopLoText = new javax.swing.JTextField();
        jLabel119 = new javax.swing.JLabel();
        strongFactionTroopHiText = new javax.swing.JTextField();
        jLabel120 = new javax.swing.JLabel();
        jLabel121 = new javax.swing.JLabel();
        jLabel122 = new javax.swing.JLabel();
        jLabel123 = new javax.swing.JLabel();
        jLabel124 = new javax.swing.JLabel();
        strongFactionCashLoText = new javax.swing.JTextField();
        jLabel125 = new javax.swing.JLabel();
        strongFactionCashHiText = new javax.swing.JTextField();
        jLabel126 = new javax.swing.JLabel();
        strongFactionMoreCityProbSlider = new javax.swing.JSlider();
        strongFactionMoreCityProbLabel = new javax.swing.JLabel();
        jLabel127 = new javax.swing.JLabel();
        strongFactionTechniqueProbSlider = new javax.swing.JSlider();
        strongFactionTechniqueProbLabel = new javax.swing.JLabel();
        jPanel20 = new javax.swing.JPanel();
        jLabel128 = new javax.swing.JLabel();
        strongOfficerProbSlider = new javax.swing.JSlider();
        strongOfficerProbLabel = new javax.swing.JLabel();
        jLabel129 = new javax.swing.JLabel();
        strongOfficerAbilityMulText = new javax.swing.JTextField();
        jLabel130 = new javax.swing.JLabel();
        strongOfficerAbilityAbsText = new javax.swing.JTextField();
        jLabel131 = new javax.swing.JLabel();
        strongOfficerSpecialProbText = new javax.swing.JTextField();
        jLabel134 = new javax.swing.JLabel();
        strongOfficerStuntProbText = new javax.swing.JTextField();
        jLabel137 = new javax.swing.JLabel();
        strongFactionOfficerLoText = new javax.swing.JTextField();
        jLabel138 = new javax.swing.JLabel();
        strongFactionOfficerHiText = new javax.swing.JTextField();
        jLabel139 = new javax.swing.JLabel();
        strongOfficerPopularityHiText = new javax.swing.JTextField();
        jLabel140 = new javax.swing.JLabel();
        strongOfficerPopularityLoText = new javax.swing.JTextField();
        jLabel141 = new javax.swing.JLabel();
        strongOfficerIdealTendencyCheckbox = new javax.swing.JCheckBox();
        strongKingAmbitionCheckbox = new javax.swing.JCheckBox();
        strongOfficerLoyaltyCheckbox = new javax.swing.JCheckBox();
        jLabel132 = new javax.swing.JLabel();
        strongFactionMinOfficerText = new javax.swing.JTextField();
        jLabel133 = new javax.swing.JLabel();
        strongFactionReputationLoText = new javax.swing.JTextField();
        jLabel135 = new javax.swing.JLabel();
        strongFactionReputationHiText = new javax.swing.JTextField();
        jLabel136 = new javax.swing.JLabel();
        strongFactionSpecialTroopLabel = new javax.swing.JLabel();
        jLabel160 = new javax.swing.JLabel();
        strongFactionSpecialTroopSlider = new javax.swing.JSlider();
        jPanel11 = new javax.swing.JPanel();
        jPanel14 = new javax.swing.JPanel();
        jLabel72 = new javax.swing.JLabel();
        hasChildrenProbSlider = new javax.swing.JSlider();
        hasChildrenProbLabel = new javax.swing.JLabel();
        jLabel73 = new javax.swing.JLabel();
        kingHasMoreChildrenProbSlider = new javax.swing.JSlider();
        kingHasMoreChildrenProbLabel = new javax.swing.JLabel();
        jLabel74 = new javax.swing.JLabel();
        generationHiText = new javax.swing.JTextField();
        jLabel76 = new javax.swing.JLabel();
        spouseProbSlider = new javax.swing.JSlider();
        spouseProbLabel = new javax.swing.JLabel();
        jLabel75 = new javax.swing.JLabel();
        childrenLoyaltyLoText = new javax.swing.JTextField();
        jLabel77 = new javax.swing.JLabel();
        childrenLoyaltyHiText = new javax.swing.JTextField();
        parentAffectAbilityCheckbox = new javax.swing.JCheckBox();
        jLabel79 = new javax.swing.JLabel();
        childrenPopularityHiText = new javax.swing.JTextField();
        childrenPopularityLoText = new javax.swing.JTextField();
        jLabel78 = new javax.swing.JLabel();
        jLabel80 = new javax.swing.JLabel();
        childrenAttachmentText = new javax.swing.JTextField();
        jLabel81 = new javax.swing.JLabel();
        childrenParentYearLoText = new javax.swing.JTextField();
        jLabel82 = new javax.swing.JLabel();
        childrenParentYearHiText = new javax.swing.JTextField();
        jLabel83 = new javax.swing.JLabel();
        childrenAbilityBaseText = new javax.swing.JTextField();
        jLabel84 = new javax.swing.JLabel();
        childrenAbilityVarText = new javax.swing.JTextField();
        jLabel85 = new javax.swing.JLabel();
        childrenSkillBaseText = new javax.swing.JTextField();
        jLabel86 = new javax.swing.JLabel();
        childrenSkillVarText = new javax.swing.JTextField();
        jLabel87 = new javax.swing.JLabel();
        childrenStuntBaseText = new javax.swing.JTextField();
        jLabel88 = new javax.swing.JLabel();
        childrenStuntVarText = new javax.swing.JTextField();
        jLabel89 = new javax.swing.JLabel();
        childrenPersonalTitleText = new javax.swing.JTextField();
        jLabel90 = new javax.swing.JLabel();
        childrenBattleTitleText = new javax.swing.JTextField();
        jLabel91 = new javax.swing.JLabel();
        kingHasChildrenProbSlider = new javax.swing.JSlider();
        kingHasChildrenProbLabel = new javax.swing.JLabel();
        jLabel92 = new javax.swing.JLabel();
        hasMoreChildrenProbSlider = new javax.swing.JSlider();
        hasMoreChildrenProbLabel = new javax.swing.JLabel();
        jPanel27 = new javax.swing.JPanel();
        jLabel166 = new javax.swing.JLabel();
        hateOfficerProbSlider = new javax.swing.JSlider();
        hateOfficerProbLabel = new javax.swing.JLabel();
        jLabel167 = new javax.swing.JLabel();
        spouseImitateProbSlider = new javax.swing.JSlider();
        spouseImitateProbLabel = new javax.swing.JLabel();
        jLabel168 = new javax.swing.JLabel();
        closeImitateProbSlider = new javax.swing.JSlider();
        closeImitateProbLabel = new javax.swing.JLabel();
        jLabel169 = new javax.swing.JLabel();
        imitateOfficerProbSlider = new javax.swing.JSlider();
        imitateOfficerProbLabel = new javax.swing.JLabel();
        bwrb = new javax.swing.JLabel();
        bloodImitateProbSlider = new javax.swing.JSlider();
        bloodImitateProbLabel = new javax.swing.JLabel();
        jPanel21 = new javax.swing.JPanel();
        jPanel15 = new javax.swing.JPanel();
        jLabel106 = new javax.swing.JLabel();
        moreCityFactionProbSlider = new javax.swing.JSlider();
        moreCityFactionProbLabel = new javax.swing.JLabel();
        connectedFactionCityCheckbox = new javax.swing.JCheckBox();
        jPanel16 = new javax.swing.JPanel();
        jLabel107 = new javax.swing.JLabel();
        factionDiplomacyLoText = new javax.swing.JTextField();
        jLabel108 = new javax.swing.JLabel();
        factionDiplomacyHiText = new javax.swing.JTextField();
        gaussianDiplomacyCheckbox = new javax.swing.JCheckBox();
        jPanel17 = new javax.swing.JPanel();
        jLabel109 = new javax.swing.JLabel();
        factionSpecialTroopSlider = new javax.swing.JSlider();
        factionSpecialTroopLabel = new javax.swing.JLabel();
        maleKingCheckbox = new javax.swing.JCheckBox();
        jPanel23 = new javax.swing.JPanel();
        jLabel146 = new javax.swing.JLabel();
        treasureCntLoText = new javax.swing.JTextField();
        jLabel147 = new javax.swing.JLabel();
        treasureCntHiText = new javax.swing.JTextField();
        jPanel24 = new javax.swing.JPanel();
        jLabel148 = new javax.swing.JLabel();
        treasureWeaponProbText = new javax.swing.JTextField();
        jLabel149 = new javax.swing.JLabel();
        treasureBookProbText = new javax.swing.JTextField();
        jLabel150 = new javax.swing.JLabel();
        treasureHorseProbText = new javax.swing.JTextField();
        jLabel151 = new javax.swing.JLabel();
        treasurePriceLoText = new javax.swing.JTextField();
        jLabel152 = new javax.swing.JLabel();
        treasurePriceHiText = new javax.swing.JTextField();
        jLabel153 = new javax.swing.JLabel();
        treasureYearLoText = new javax.swing.JTextField();
        jLabel154 = new javax.swing.JLabel();
        treasureYearHiText = new javax.swing.JTextField();
        jLabel155 = new javax.swing.JLabel();
        treasurePriceRateText = new javax.swing.JTextField();
        treasureOwnedProbSlider = new javax.swing.JSlider();
        treasureOwnedProbLabel = new javax.swing.JLabel();
        jLabel156 = new javax.swing.JLabel();
        treasurePriceGaussianCheckbox = new javax.swing.JCheckBox();
        jPanel25 = new javax.swing.JPanel();
        jLabel159 = new javax.swing.JLabel();
        factionTechniqueProbSlider = new javax.swing.JSlider();
        factionTechniqueProbLabel = new javax.swing.JLabel();
        jPanel28 = new javax.swing.JPanel();
        createMapCheckbox = new javax.swing.JCheckBox();
        jPanel29 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        terrainSettingTable = new javax.swing.JTable();
        jLabel162 = new javax.swing.JLabel();
        mapSizeXText = new javax.swing.JTextField();
        jLabel170 = new javax.swing.JLabel();
        mapSizeYText = new javax.swing.JTextField();
        jPanel30 = new javax.swing.JPanel();
        jLabel172 = new javax.swing.JLabel();
        mapHarbourCntLoText = new javax.swing.JTextField();
        jLabel171 = new javax.swing.JLabel();
        mapHarbourCntHiText = new javax.swing.JTextField();
        jLabel173 = new javax.swing.JLabel();
        mapCitySizeLoText = new javax.swing.JTextField();
        jLabel174 = new javax.swing.JLabel();
        mapCitySizeHiText = new javax.swing.JTextField();
        jLabel175 = new javax.swing.JLabel();
        mapCityCntLoText = new javax.swing.JTextField();
        jLabel176 = new javax.swing.JLabel();
        mapCityCntHiText = new javax.swing.JTextField();
        jLabel177 = new javax.swing.JLabel();
        mapStartTerrainCombo = new javax.swing.JComboBox();
        exportSettingButton = new javax.swing.JButton();
        importSettingButton = new javax.swing.JButton();
        changeGamePathButton = new javax.swing.JButton();
        langCombo = new javax.swing.JComboBox();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setTitle(APP_NAME);
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });
        getContentPane().setLayout(new java.awt.GridBagLayout());

        openFileButton.setText("生成劇本");
        openFileButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                openFileButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(openFileButton, gridBagConstraints);

        filePathLabel.setText("生成檔案在遊戲劇本資料夾下的generatedScen.mdb，過程一般不會超過數秒。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(filePathLabel, gridBagConstraints);

        jTabbedPane1.setPreferredSize(new java.awt.Dimension(720, 479));

        jPanel1.setPreferredSize(new java.awt.Dimension(720, 413));
        jPanel1.setLayout(new java.awt.GridBagLayout());

        jLabel1.setText("女武將機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel1.add(jLabel1, gridBagConstraints);

        femaleOfficerProbSlider.setMajorTickSpacing(10);
        femaleOfficerProbSlider.setMinorTickSpacing(1);
        femaleOfficerProbSlider.setToolTipText("生成女武將的機率。");
        femaleOfficerProbSlider.setValue(25);
        femaleOfficerProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                femaleOfficerProbSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel1.add(femaleOfficerProbSlider, gridBagConstraints);

        femaleOfficerProbLabel.setText("25%");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel1.add(femaleOfficerProbLabel, gridBagConstraints);

        jLabel2.setText("複名機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel1.add(jLabel2, gridBagConstraints);

        doubleNameProbSlider.setMajorTickSpacing(10);
        doubleNameProbSlider.setMinorTickSpacing(1);
        doubleNameProbSlider.setToolTipText("<html>生成武將名稱時，出現由兩個單字組成的名稱的機率。<br>\n注：實際機率可能與這數有出入。這是由於部分名稱在設定檔中已經是複名了，不需要組合。");
        doubleNameProbSlider.setValue(25);
        doubleNameProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                doubleNameProbSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel1.add(doubleNameProbSlider, gridBagConstraints);

        doubleNameProbLabel.setText("25%");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel1.add(doubleNameProbLabel, gridBagConstraints);

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("頭像"));
        jPanel2.setLayout(new java.awt.GridLayout(3, 0, 4, 4));

        faceRadioGroup.add(randomFaceRadio);
        randomFaceRadio.setText("完全隨意");
        randomFaceRadio.setToolTipText("完全隨意地分配武將頭像，即是男武將也可能會分配到女武將的頭像。");
        jPanel2.add(randomFaceRadio);

        faceRadioGroup.add(genderFaceRadio);
        genderFaceRadio.setText("依據性別");
        genderFaceRadio.setToolTipText("<html>把武將頭像依據武將的性別重新分配。另外會盡量避免頭像的重覆，<br>\n但假若頭像數量不足，就可能會出現重覆頭像的情況。");
        jPanel2.add(genderFaceRadio);

        faceRadioGroup.add(typedFaceRadio);
        typedFaceRadio.setSelected(true);
        typedFaceRadio.setText("依據性別及文武官");
        typedFaceRadio.setToolTipText("<html>把武將頭像依據武將的性別及能力重新分配，統武較高者分配武官頭像，<br>\n智政較高者分配文官頭像，能力低下者分配庸才頭像。<br>\n另外會盡量避免頭像的重覆，但假若頭像數量不足，就可能會出現重覆頭像的情況。");
        jPanel2.add(typedFaceRadio);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel1.add(jPanel2, gridBagConstraints);

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("年份"));
        jPanel3.setLayout(new java.awt.GridBagLayout());

        jLabel3.setText("登場年");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel3.add(jLabel3, gridBagConstraints);

        debutYearLoText.setText("160");
        debutYearLoText.setToolTipText("武將登場年份");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel3.add(debutYearLoText, gridBagConstraints);

        debutYearHiText.setText("250");
        debutYearHiText.setToolTipText("武將登場年份");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel3.add(debutYearHiText, gridBagConstraints);

        jLabel4.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel3.add(jLabel4, gridBagConstraints);

        jLabel5.setText("出生年較登場年早");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel3.add(jLabel5, gridBagConstraints);

        bornYearLoText.setText("15");
        bornYearLoText.setToolTipText("把武將出生年設在其登場年前的年數(即是登場年齡)下限");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel3.add(bornYearLoText, gridBagConstraints);

        jLabel6.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(9, 4, 0, 0);
        jPanel3.add(jLabel6, gridBagConstraints);

        bornYearHiText.setText("30");
        bornYearHiText.setToolTipText("把武將出生年設在其登場年前的年數(即是登場年齡)上限");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel3.add(bornYearHiText, gridBagConstraints);

        jLabel7.setText("死亡年較登場年遲");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel3.add(jLabel7, gridBagConstraints);

        deadYearLoText.setText("10");
        deadYearLoText.setToolTipText("把武將死亡年設在其登場年後的年數(即是在劇本出現的時間)下限");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel3.add(deadYearLoText, gridBagConstraints);

        jLabel8.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(9, 4, 0, 0);
        jPanel3.add(jLabel8, gridBagConstraints);

        deadYearHiText.setText("85");
        deadYearHiText.setToolTipText("把武將死亡年設在其登場年後的年數(即是在劇本出現的時間)上限");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel3.add(deadYearHiText, gridBagConstraints);

        jLabel9.setText("年");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel3.add(jLabel9, gridBagConstraints);

        jLabel10.setText("年");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel3.add(jLabel10, gridBagConstraints);

        scenYearLo.setText("160");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel3.add(scenYearLo, gridBagConstraints);

        jLabel32.setText("劇本年");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel3.add(jLabel32, gridBagConstraints);

        scenYearHi.setText("250");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel3.add(scenYearHi, gridBagConstraints);

        jLabel33.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel3.add(jLabel33, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel1.add(jPanel3, gridBagConstraints);

        jPanel5.setBorder(javax.swing.BorderFactory.createTitledBorder("武將生成方式"));
        jPanel5.setLayout(new java.awt.GridBagLayout());

        officerGenerationTypeGroup.add(randomTypeOfficerRadio);
        randomTypeOfficerRadio.setSelected(true);
        randomTypeOfficerRadio.setText("完全隨意");
        randomTypeOfficerRadio.setToolTipText("<html>完全隨機地生成武將。影響包括：武將能力（生成50-100間的隨機數，可在武將能力中修正 )、<br>\n武將適性、武將特技、武將性格、部分隱藏數值如義理等");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel5.add(randomTypeOfficerRadio, gridBagConstraints);

        officerGenerationTypeGroup.add(typedOfficerRadio);
        typedOfficerRadio.setText("依種類");
        typedOfficerRadio.setToolTipText("<html>生成武將時先決定武將類型，然後依據這個類型作相應的隨機化。<br>影響包括：武將能力、武將適性、武將特技、武將性格、部分隱藏數值如義理等");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.BASELINE_LEADING;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel5.add(typedOfficerRadio, gridBagConstraints);

        officerTypePanel.setBorder(javax.swing.BorderFactory.createTitledBorder("武將種類比重"));
        officerTypePanel.setLayout(new java.awt.GridBagLayout());

        jLabel14.setText("將軍");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        officerTypePanel.add(jLabel14, gridBagConstraints);

        generalTypeWeightText.setText("1");
        generalTypeWeightText.setToolTipText("<html>設定將軍型的武將（如孫堅、馬超、呂布等）數量比重。<br>\n將軍型武將擁有較高的統率、武力、適性較高、特技也偏向戰鬥型，但智力及政治較低。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        officerTypePanel.add(generalTypeWeightText, gridBagConstraints);

        jLabel15.setText("猛將");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        officerTypePanel.add(jLabel15, gridBagConstraints);

        mightyTypeWeightText.setText("1");
        mightyTypeWeightText.setToolTipText("<html>設定猛將型的武將（如典韋、許禇等）數量比重。<br>\n猛將型武將擁有很高的武力、特技也偏向戰鬥型，性格較莾撞，但其他能力，尤其智力及政治，均較低下。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        officerTypePanel.add(mightyTypeWeightText, gridBagConstraints);

        jLabel16.setText("軍師");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        officerTypePanel.add(jLabel16, gridBagConstraints);

        advisorTypeWeightText.setText("1");
        advisorTypeWeightText.setToolTipText("<html>設定軍師型的武將（如諸葛亮、司馬懿）數量比重。<br>\n軍師型武將擁有較高的統率、智力及政治，性格較冷靜，特技偏向計策型，但武力偏低。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        officerTypePanel.add(advisorTypeWeightText, gridBagConstraints);

        jLabel17.setText("識者");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        officerTypePanel.add(jLabel17, gridBagConstraints);

        politicianTypeWeightText.setText("1");
        politicianTypeWeightText.setToolTipText("<html>設定識者型的武將（如荀彧、張昭等）數量比重。<br>\n識者型武將擁有較高的智力及政治，特技偏向內政型，但統率、武力也較低。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        officerTypePanel.add(politicianTypeWeightText, gridBagConstraints);

        jLabel18.setText("智將");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        officerTypePanel.add(jLabel18, gridBagConstraints);

        intelGeneralTypeWeightText.setText("1");
        intelGeneralTypeWeightText.setToolTipText("<html>設定智將型的武將（如姜維、甘寧等）數量比重。<br>\n智將型武將擁有較高的統率、武力、智力及適性，但政治較低。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        officerTypePanel.add(intelGeneralTypeWeightText, gridBagConstraints);

        jLabel19.setText("群雄");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        officerTypePanel.add(jLabel19, gridBagConstraints);

        emperorTypeWeightText.setText("1");
        emperorTypeWeightText.setToolTipText("<html>設定群雄型的武將（如袁紹、張角等）數量比重。<br>\n群雄型武將能力較平均，武力稍低，魅力很高，野心較高。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        officerTypePanel.add(emperorTypeWeightText, gridBagConstraints);

        jLabel20.setText("全能");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        officerTypePanel.add(jLabel20, gridBagConstraints);

        allRounderTypeWeightText.setText("1");
        allRounderTypeWeightText.setToolTipText("<html>設定全能型的武將數量比重。<br>\n全能型武將擁有很高的能力、適性，而且較大機會擁有較強力的特技。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        officerTypePanel.add(allRounderTypeWeightText, gridBagConstraints);

        jLabel21.setText("平凡");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        officerTypePanel.add(jLabel21, gridBagConstraints);

        normalTypeWeightText.setText("1");
        normalTypeWeightText.setToolTipText("<html>設定平凡型的武將數量比重。<br>\n平凡型武將各項能力一般，沒有突出的才華，較少有突出之處。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        officerTypePanel.add(normalTypeWeightText, gridBagConstraints);

        jLabel22.setText("庸才");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        officerTypePanel.add(jLabel22, gridBagConstraints);

        cheapTypeWeightText.setText("1");
        cheapTypeWeightText.setToolTipText("<html>設定庸才型的武將數量比重。<br>\n庸才型武將各項能力低下，性格偏向膽小，而且義理及野心較低。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        officerTypePanel.add(cheapTypeWeightText, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel5.add(officerTypePanel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 9;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel1.add(jPanel5, gridBagConstraints);

        jLabel31.setText("在野及未登場武將數量");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel1.add(jLabel31, gridBagConstraints);

        officerCntLoText.setText("100");
        officerCntLoText.setToolTipText("生成在野及未登場武將總數，不包括子女武將。武將是否未登場由其登場年及劇本年決定。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel1.add(officerCntLoText, gridBagConstraints);

        jLabel47.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel1.add(jLabel47, gridBagConstraints);

        officerCntHiText.setText("200");
        officerCntHiText.setToolTipText("生成在野及未登場武將總數，不包括子女武將。武將是否未登場由其登場年及劇本年決定。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel1.add(officerCntHiText, gridBagConstraints);

        jPanel8.setBorder(javax.swing.BorderFactory.createTitledBorder("勢力"));
        jPanel8.setLayout(new java.awt.GridBagLayout());

        jLabel52.setText("聲望");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel8.add(jLabel52, gridBagConstraints);

        reputationLoText.setText("0");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel8.add(reputationLoText, gridBagConstraints);

        jLabel51.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel8.add(jLabel51, gridBagConstraints);

        reputationHiText.setText("200");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel8.add(reputationHiText, gridBagConstraints);

        factionOfficerHiText.setText("15");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel8.add(factionOfficerHiText, gridBagConstraints);

        factionCntHiText.setText("48");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel8.add(factionCntHiText, gridBagConstraints);

        jLabel55.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel8.add(jLabel55, gridBagConstraints);

        jLabel50.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel8.add(jLabel50, gridBagConstraints);

        factionCntLoText.setText("42");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel8.add(factionCntLoText, gridBagConstraints);

        jLabel49.setText("勢力數目");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel8.add(jLabel49, gridBagConstraints);

        jLabel53.setText(" x 10");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel8.add(jLabel53, gridBagConstraints);

        factionOfficerLoText.setText("5");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel8.add(factionOfficerLoText, gridBagConstraints);

        jLabel54.setText("每城池武將數目");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel8.add(jLabel54, gridBagConstraints);

        jLabel38.setText("勢力君主");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel8.add(jLabel38, gridBagConstraints);

        factionKingGroup.add(randomKingRadio);
        randomKingRadio.setSelected(true);
        randomKingRadio.setText("隨機");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel8.add(randomKingRadio, gridBagConstraints);

        factionKingGroup.add(bestKingRadio);
        bestKingRadio.setText("五圍最高者");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel8.add(bestKingRadio, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel1.add(jPanel8, gridBagConstraints);

        useScenOfficerCheckbox.setText("使用特定的武將");
        useScenOfficerCheckbox.setToolTipText("使用修改器資料夾下，ScenOfficer.mdb中的武將");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel1.add(useScenOfficerCheckbox, gridBagConstraints);

        jTabbedPane1.addTab("基本", jPanel1);

        jPanel4.setLayout(new java.awt.GridBagLayout());

        jPanel7.setBorder(javax.swing.BorderFactory.createTitledBorder("武將能力調整"));
        jPanel7.setLayout(new java.awt.GridBagLayout());

        jLabel23.setText("能力 = 隨機得出能力 x ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel7.add(jLabel23, gridBagConstraints);

        abilityMulText.setText("1");
        abilityMulText.setToolTipText("把所有武將的能力隨機化後，再乘上這個數字作修正");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel7.add(abilityMulText, gridBagConstraints);

        jLabel24.setText("+");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel7.add(jLabel24, gridBagConstraints);

        abilityAbsText.setText("0");
        abilityAbsText.setToolTipText("把所有武將的能力隨機化後，再加上這個數字作修正");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel7.add(abilityAbsText, gridBagConstraints);

        jLabel25.setText("最終能力");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel7.add(jLabel25, gridBagConstraints);

        abilityHiText.setText("100");
        abilityHiText.setToolTipText("經所有加成後的最終能力上限");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel7.add(abilityHiText, gridBagConstraints);

        jLabel26.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel7.add(jLabel26, gridBagConstraints);

        abilityLoText.setText("1");
        abilityLoText.setToolTipText("經所有加成後的最終能力下限");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel7.add(abilityLoText, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(jPanel7, gridBagConstraints);

        jPanel9.setBorder(javax.swing.BorderFactory.createTitledBorder("技能"));
        jPanel9.setLayout(new java.awt.GridBagLayout());

        jLabel28.setText("技能機率參數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel9.add(jLabel28, gridBagConstraints);

        specialProbText.setText("15");
        specialProbText.setToolTipText("<html>武將取得技能的機率參數，數值愈高取得技能機率愈高。\n如以種類方法生成武將，取得技能的機率將與技能級數及類型相關。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel9.add(specialProbText, gridBagConstraints);

        jLabel29.setText("能力高於");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel9.add(jLabel29, gridBagConstraints);

        specialAbyThresholdText.setText("80");
        specialAbyThresholdText.setToolTipText("武將的最大能力高於這值時，得到技能的機率增加。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel9.add(specialAbyThresholdText, gridBagConstraints);

        jLabel30.setText("額外技能機率加成");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel9.add(jLabel30, gridBagConstraints);

        specialAbyProbText.setText("1.5");
        specialAbyProbText.setToolTipText("能力達到100時，技能機率的加成乘值。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel9.add(specialAbyProbText, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.PAGE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 30);
        jPanel4.add(jPanel9, gridBagConstraints);

        jPanel10.setBorder(javax.swing.BorderFactory.createTitledBorder("特技"));
        jPanel10.setLayout(new java.awt.GridBagLayout());

        jLabel35.setText("特技機率參數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel10.add(jLabel35, gridBagConstraints);

        stuntProbText.setText("15");
        stuntProbText.setToolTipText("<html>武將取得特技的機率參數，數值愈高取得特技機率愈高。\n如以種類方法生成武將，取得特技的機率將與特技類型相關。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel10.add(stuntProbText, gridBagConstraints);

        jLabel36.setText("能力高於");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel10.add(jLabel36, gridBagConstraints);

        stuntAbyThresholdText.setText("80");
        stuntAbyThresholdText.setToolTipText("武將的最大能力高於這值時，得到特技的機率增加。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel10.add(stuntAbyThresholdText, gridBagConstraints);

        jLabel37.setText("額外特技機率加成");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel10.add(jLabel37, gridBagConstraints);

        stuntAbyProbText.setText("1.5");
        stuntAbyProbText.setToolTipText("能力達到100時，特技機率的加成乘值。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel10.add(stuntAbyProbText, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(jPanel10, gridBagConstraints);

        jPanel12.setBorder(javax.swing.BorderFactory.createTitledBorder("無稱號機率"));
        jPanel12.setLayout(new java.awt.GridLayout(9, 3, 8, 8));

        jLabel39.setText("將軍");
        jPanel12.add(jLabel39);

        noSpecialProb1Slider1.setMajorTickSpacing(10);
        noSpecialProb1Slider1.setMinorTickSpacing(1);
        noSpecialProb1Slider1.setToolTipText("將軍型武將得不到稱號的機率");
        noSpecialProb1Slider1.setValue(0);
        noSpecialProb1Slider1.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                noSpecialProb1Slider1StateChanged(evt);
            }
        });
        jPanel12.add(noSpecialProb1Slider1);

        noSpecialProb1Label.setText("0%");
        jPanel12.add(noSpecialProb1Label);

        jLabel40.setText("猛將");
        jPanel12.add(jLabel40);

        noSpecialProb1Slider2.setMajorTickSpacing(10);
        noSpecialProb1Slider2.setMinorTickSpacing(1);
        noSpecialProb1Slider2.setToolTipText("猛將型武將得不到稱號的機率");
        noSpecialProb1Slider2.setValue(0);
        noSpecialProb1Slider2.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                noSpecialProb1Slider2StateChanged(evt);
            }
        });
        jPanel12.add(noSpecialProb1Slider2);

        noSpecialProb1Label1.setText("0%");
        jPanel12.add(noSpecialProb1Label1);

        jLabel41.setText("軍師");
        jPanel12.add(jLabel41);

        noSpecialProb1Slider3.setMajorTickSpacing(10);
        noSpecialProb1Slider3.setMinorTickSpacing(1);
        noSpecialProb1Slider3.setToolTipText("軍師型武將得不到稱號的機率");
        noSpecialProb1Slider3.setValue(0);
        noSpecialProb1Slider3.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                noSpecialProb1Slider3StateChanged(evt);
            }
        });
        jPanel12.add(noSpecialProb1Slider3);

        noSpecialProb1Label2.setText("0%");
        jPanel12.add(noSpecialProb1Label2);

        jLabel42.setText("識者");
        jPanel12.add(jLabel42);

        noSpecialProb1Slider4.setMajorTickSpacing(10);
        noSpecialProb1Slider4.setMinorTickSpacing(1);
        noSpecialProb1Slider4.setToolTipText("識者型武將得不到稱號的機率");
        noSpecialProb1Slider4.setValue(0);
        noSpecialProb1Slider4.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                noSpecialProb1Slider4StateChanged(evt);
            }
        });
        jPanel12.add(noSpecialProb1Slider4);

        noSpecialProb1Label3.setText("0%");
        jPanel12.add(noSpecialProb1Label3);

        jLabel43.setText("智將");
        jPanel12.add(jLabel43);

        noSpecialProb1Slider5.setMajorTickSpacing(10);
        noSpecialProb1Slider5.setMinorTickSpacing(1);
        noSpecialProb1Slider5.setToolTipText("智將型武將得不到稱號的機率");
        noSpecialProb1Slider5.setValue(0);
        noSpecialProb1Slider5.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                noSpecialProb1Slider5StateChanged(evt);
            }
        });
        jPanel12.add(noSpecialProb1Slider5);

        noSpecialProb1Label4.setText("0%");
        jPanel12.add(noSpecialProb1Label4);

        jLabel44.setText("群雄");
        jPanel12.add(jLabel44);

        noSpecialProb1Slider6.setMajorTickSpacing(10);
        noSpecialProb1Slider6.setMinorTickSpacing(1);
        noSpecialProb1Slider6.setSnapToTicks(true);
        noSpecialProb1Slider6.setToolTipText("群雄型武將得不到稱號的機率");
        noSpecialProb1Slider6.setValue(0);
        noSpecialProb1Slider6.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                noSpecialProb1Slider6StateChanged(evt);
            }
        });
        jPanel12.add(noSpecialProb1Slider6);

        noSpecialProb1Label5.setText("0%");
        jPanel12.add(noSpecialProb1Label5);

        jLabel45.setText("全能");
        jPanel12.add(jLabel45);

        noSpecialProb1Slider7.setMajorTickSpacing(10);
        noSpecialProb1Slider7.setMinorTickSpacing(1);
        noSpecialProb1Slider7.setToolTipText("全能型武將得不到稱號的機率");
        noSpecialProb1Slider7.setValue(0);
        noSpecialProb1Slider7.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                noSpecialProb1Slider7StateChanged(evt);
            }
        });
        jPanel12.add(noSpecialProb1Slider7);

        noSpecialProb1Label6.setText("0%");
        jPanel12.add(noSpecialProb1Label6);

        jLabel46.setText("平凡");
        jPanel12.add(jLabel46);

        noSpecialProb1Slider8.setMajorTickSpacing(10);
        noSpecialProb1Slider8.setMinorTickSpacing(1);
        noSpecialProb1Slider8.setToolTipText("平凡型武將得不到稱號的機率");
        noSpecialProb1Slider8.setValue(40);
        noSpecialProb1Slider8.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                noSpecialProb1Slider8StateChanged(evt);
            }
        });
        jPanel12.add(noSpecialProb1Slider8);

        noSpecialProb1Label7.setText("40%");
        jPanel12.add(noSpecialProb1Label7);

        jLabel48.setText("庸才");
        jPanel12.add(jLabel48);

        noSpecialProb1Slider9.setMajorTickSpacing(10);
        noSpecialProb1Slider9.setMinorTickSpacing(1);
        noSpecialProb1Slider9.setSnapToTicks(true);
        noSpecialProb1Slider9.setToolTipText("庸才型武將得不到稱號的機率");
        noSpecialProb1Slider9.setValue(80);
        noSpecialProb1Slider9.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                noSpecialProb1Slider9StateChanged(evt);
            }
        });
        jPanel12.add(noSpecialProb1Slider9);

        noSpecialProb1Label8.setText("80%");
        jPanel12.add(noSpecialProb1Label8);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(jPanel12, gridBagConstraints);

        jLabel34.setText("x  10");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(jLabel34, gridBagConstraints);

        jLabel11.setText("相性");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(jLabel11, gridBagConstraints);

        attachmentLoText.setText("0");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(attachmentLoText, gridBagConstraints);

        jLabel12.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(jLabel12, gridBagConstraints);

        attachmentHiText.setText("149");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(attachmentHiText, gridBagConstraints);

        popularityHiText.setText("400");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(popularityHiText, gridBagConstraints);

        popularityLoText.setText("0");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(popularityLoText, gridBagConstraints);

        jLabel27.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(jLabel27, gridBagConstraints);

        jLabel13.setText("名聲");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(jLabel13, gridBagConstraints);

        jLabel56.setText("忠誠");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(jLabel56, gridBagConstraints);

        loyaltyLoText.setText("90");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(loyaltyLoText, gridBagConstraints);

        jLabel57.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(jLabel57, gridBagConstraints);

        leaderPossibilityFactorText.setText("5");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(leaderPossibilityFactorText, gridBagConstraints);

        jLabel161.setText("新建勢力可能性參數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(jLabel161, gridBagConstraints);

        loyaltyHiText.setText("100");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(loyaltyHiText, gridBagConstraints);

        jPanel26.setBorder(javax.swing.BorderFactory.createTitledBorder("生成稱號"));
        jPanel26.setLayout(new java.awt.GridBagLayout());

        generatedTitleLevelHiText.setText("5");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel26.add(generatedTitleLevelHiText, gridBagConstraints);

        jLabel163.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel26.add(jLabel163, gridBagConstraints);

        generatedTitleLevelLoText.setText("1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel26.add(generatedTitleLevelLoText, gridBagConstraints);

        jLabel164.setText("生成稱號等級");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel26.add(jLabel164, gridBagConstraints);

        generatedTitleProbSlider.setMajorTickSpacing(10);
        generatedTitleProbSlider.setMinorTickSpacing(1);
        generatedTitleProbSlider.setToolTipText("");
        generatedTitleProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                generatedTitleProbSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel26.add(generatedTitleProbSlider, gridBagConstraints);

        generatedTitleProbLabel.setText("50%");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel26.add(generatedTitleProbLabel, gridBagConstraints);

        jLabel165.setText("獲得生成稱號機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel26.add(jLabel165, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(jPanel26, gridBagConstraints);

        jTabbedPane1.addTab("武將", jPanel4);

        jPanel6.setLayout(new java.awt.GridBagLayout());

        jPanel13.setBorder(javax.swing.BorderFactory.createTitledBorder("據點"));
        jPanel13.setLayout(new java.awt.GridBagLayout());

        agricultureLoText.setText("50");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(agricultureLoText, gridBagConstraints);

        jLabel58.setText("農業");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(jLabel58, gridBagConstraints);

        agricultureHiText.setText("150");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(agricultureHiText, gridBagConstraints);

        jLabel59.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(jLabel59, gridBagConstraints);

        jLabel60.setText("兵糧");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(jLabel60, gridBagConstraints);

        cropLoText.setText("30");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(cropLoText, gridBagConstraints);

        jLabel61.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(jLabel61, gridBagConstraints);

        cropHiText.setText("100");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(cropHiText, gridBagConstraints);

        jLabel62.setText("人口");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(jLabel62, gridBagConstraints);

        populationLoText.setText("12");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(populationLoText, gridBagConstraints);

        jLabel63.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(jLabel63, gridBagConstraints);

        populationHiText.setText("20");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(populationHiText, gridBagConstraints);

        jLabel66.setText("每支軍隊人數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(jLabel66, gridBagConstraints);

        troopLoText.setText("8");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(troopLoText, gridBagConstraints);

        jLabel67.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(jLabel67, gridBagConstraints);

        troopHiText.setText("15");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(troopHiText, gridBagConstraints);

        jLabel68.setText("x 100");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(jLabel68, gridBagConstraints);

        jLabel69.setText("x 10000");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(jLabel69, gridBagConstraints);

        jLabel70.setText("x 1000 x 規模");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(jLabel70, gridBagConstraints);

        jLabel71.setText("x 1000");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(jLabel71, gridBagConstraints);

        jLabel93.setText("皇帝所在最小城池規模");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(jLabel93, gridBagConstraints);

        emperorLeastCitySizeText.setText("9");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(emperorLeastCitySizeText, gridBagConstraints);

        jLabel94.setText("商業");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(jLabel94, gridBagConstraints);

        commerceLoText.setText("50");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(commerceLoText, gridBagConstraints);

        jLabel95.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(jLabel95, gridBagConstraints);

        commerceHiText.setText("150");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(commerceHiText, gridBagConstraints);

        jLabel96.setText("技術");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(jLabel96, gridBagConstraints);

        technologyLoText.setText("50");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(technologyLoText, gridBagConstraints);

        jLabel97.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(jLabel97, gridBagConstraints);

        technologyHiText.setText("150");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(technologyHiText, gridBagConstraints);

        jLabel98.setText("統治");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(jLabel98, gridBagConstraints);

        dominationLoText.setText("50");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(dominationLoText, gridBagConstraints);

        jLabel99.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(jLabel99, gridBagConstraints);

        dominationHiText.setText("70");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(dominationHiText, gridBagConstraints);

        jLabel100.setText("民心");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(jLabel100, gridBagConstraints);

        moraleLoText.setText("50");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(moraleLoText, gridBagConstraints);

        jLabel101.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(jLabel101, gridBagConstraints);

        moraleHiText.setText("150");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(moraleHiText, gridBagConstraints);

        jLabel102.setText("耐久");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(jLabel102, gridBagConstraints);

        enduranceLoText.setText("100");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(enduranceLoText, gridBagConstraints);

        jLabel103.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(jLabel103, gridBagConstraints);

        enduranceHiText.setText("200");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(enduranceHiText, gridBagConstraints);

        jLabel104.setText("資金");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(jLabel104, gridBagConstraints);

        cashLoText.setText("30");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(cashLoText, gridBagConstraints);

        jLabel105.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(jLabel105, gridBagConstraints);

        cashHiText.setText("100");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(cashHiText, gridBagConstraints);

        jLabel157.setText("特性機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(jLabel157, gridBagConstraints);

        citySpecialtyProbSlider.setMajorTickSpacing(10);
        citySpecialtyProbSlider.setMinorTickSpacing(1);
        citySpecialtyProbSlider.setSnapToTicks(true);
        citySpecialtyProbSlider.setToolTipText("城池有特性的機率");
        citySpecialtyProbSlider.setValue(90);
        citySpecialtyProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                citySpecialtyProbSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(citySpecialtyProbSlider, gridBagConstraints);

        citySpecialtyProbLabel.setText("90%");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(citySpecialtyProbLabel, gridBagConstraints);

        citySpecialtyThresholdText.setText("2");
        citySpecialtyThresholdText.setToolTipText("當城池特性數量超過此數時，城池取得特性的機率迅速下降");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(citySpecialtyThresholdText, gridBagConstraints);

        jLabel158.setText("城池特性數量界限");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel13.add(jLabel158, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridheight = 4;
        jPanel6.add(jPanel13, gridBagConstraints);

        jPanel22.setBorder(javax.swing.BorderFactory.createTitledBorder("部隊"));
        jPanel22.setLayout(new java.awt.GridBagLayout());

        jLabel64.setText("軍隊數目");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel22.add(jLabel64, gridBagConstraints);

        troopCntLoText.setText("2");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel22.add(troopCntLoText, gridBagConstraints);

        jLabel65.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel22.add(jLabel65, gridBagConstraints);

        troopCntHiText.setText("4");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel22.add(troopCntHiText, gridBagConstraints);

        jLabel142.setText("軍隊經驗");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel22.add(jLabel142, gridBagConstraints);

        troopExpLoText.setText("0");
        troopExpLoText.setToolTipText("包括軍隊經驗及將領經驗。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel22.add(troopExpLoText, gridBagConstraints);

        jLabel143.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel22.add(jLabel143, gridBagConstraints);

        troopExpHiText.setText("300");
        troopExpHiText.setToolTipText("包括軍隊經驗及將領經驗。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel22.add(troopExpHiText, gridBagConstraints);

        jLabel144.setText("士氣與戰意");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel22.add(jLabel144, gridBagConstraints);

        troopMoraleLoText.setText("80");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel22.add(troopMoraleLoText, gridBagConstraints);

        jLabel145.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel22.add(jLabel145, gridBagConstraints);

        troopMoraleHiText.setText("100");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel22.add(troopMoraleHiText, gridBagConstraints);

        jPanel6.add(jPanel22, new java.awt.GridBagConstraints());

        jTabbedPane1.addTab("據點", jPanel6);

        jPanel18.setLayout(new java.awt.GridBagLayout());

        jLabel110.setText("強力勢力數量");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel18.add(jLabel110, gridBagConstraints);

        strongFactionLoText.setText("2");
        strongFactionLoText.setToolTipText("強力勢力數目。強力勢力是指較一般勢力強的勢力。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel18.add(strongFactionLoText, gridBagConstraints);

        jLabel111.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel18.add(jLabel111, gridBagConstraints);

        strongFactionHiText.setText("4");
        strongFactionHiText.setToolTipText("強力勢力數目。強力勢力是指較一般勢力強的勢力。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel18.add(strongFactionHiText, gridBagConstraints);

        jPanel19.setBorder(javax.swing.BorderFactory.createTitledBorder("強力勢力城池"));
        jPanel19.setLayout(new java.awt.GridBagLayout());

        jLabel112.setText("兵糧");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel19.add(jLabel112, gridBagConstraints);

        strongFactionCropLoText.setText("300");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel19.add(strongFactionCropLoText, gridBagConstraints);

        jLabel113.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel19.add(jLabel113, gridBagConstraints);

        strongFactionCropHiText.setText("1000");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel19.add(strongFactionCropHiText, gridBagConstraints);

        jLabel114.setText("人口");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel19.add(jLabel114, gridBagConstraints);

        strongFactionPopulationLoText.setText("40");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel19.add(strongFactionPopulationLoText, gridBagConstraints);

        jLabel115.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel19.add(jLabel115, gridBagConstraints);

        strongFactionPopulationHiText.setText("60");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel19.add(strongFactionPopulationHiText, gridBagConstraints);

        jLabel116.setText("軍隊數目");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel19.add(jLabel116, gridBagConstraints);

        strongFactionTroopCntLoText.setText("6");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel19.add(strongFactionTroopCntLoText, gridBagConstraints);

        jLabel117.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel19.add(jLabel117, gridBagConstraints);

        strongFactionTroopCntHiText.setText("8");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel19.add(strongFactionTroopCntHiText, gridBagConstraints);

        jLabel118.setText("每支軍隊人數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel19.add(jLabel118, gridBagConstraints);

        strongFactionTroopLoText.setText("10");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel19.add(strongFactionTroopLoText, gridBagConstraints);

        jLabel119.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel19.add(jLabel119, gridBagConstraints);

        strongFactionTroopHiText.setText("20");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel19.add(strongFactionTroopHiText, gridBagConstraints);

        jLabel120.setText("x 100");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel19.add(jLabel120, gridBagConstraints);

        jLabel121.setText("x 10000");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel19.add(jLabel121, gridBagConstraints);

        jLabel122.setText("x 1000 x 規模");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel19.add(jLabel122, gridBagConstraints);

        jLabel123.setText("x 1000");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel19.add(jLabel123, gridBagConstraints);

        jLabel124.setText("資金");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel19.add(jLabel124, gridBagConstraints);

        strongFactionCashLoText.setText("300");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel19.add(strongFactionCashLoText, gridBagConstraints);

        jLabel125.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel19.add(jLabel125, gridBagConstraints);

        strongFactionCashHiText.setText("1000");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel19.add(strongFactionCashHiText, gridBagConstraints);

        jLabel126.setText("勢力有額外城池機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel19.add(jLabel126, gridBagConstraints);

        strongFactionMoreCityProbSlider.setMajorTickSpacing(10);
        strongFactionMoreCityProbSlider.setMinorTickSpacing(1);
        strongFactionMoreCityProbSlider.setToolTipText("強力勢力較一般勢力有多一個城池的機率，每多一個城池，則以這個機率再增加城池。");
        strongFactionMoreCityProbSlider.setValue(40);
        strongFactionMoreCityProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                strongFactionMoreCityProbSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel19.add(strongFactionMoreCityProbSlider, gridBagConstraints);

        strongFactionMoreCityProbLabel.setText("40%");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel19.add(strongFactionMoreCityProbLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel18.add(jPanel19, gridBagConstraints);

        jLabel127.setText("勢力獲得技術機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel18.add(jLabel127, gridBagConstraints);

        strongFactionTechniqueProbSlider.setMajorTickSpacing(10);
        strongFactionTechniqueProbSlider.setMinorTickSpacing(1);
        strongFactionTechniqueProbSlider.setToolTipText("勢力獲得技術機率。如技術有前提技術，勢力必須擁有其前提技術再可獲該技術。\n");
        strongFactionTechniqueProbSlider.setValue(30);
        strongFactionTechniqueProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                strongFactionTechniqueProbSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel18.add(strongFactionTechniqueProbSlider, gridBagConstraints);

        strongFactionTechniqueProbLabel.setText("30%");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel18.add(strongFactionTechniqueProbLabel, gridBagConstraints);

        jPanel20.setBorder(javax.swing.BorderFactory.createTitledBorder("強力勢力武將"));
        jPanel20.setLayout(new java.awt.GridBagLayout());

        jLabel128.setText("勢力武將強化機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel20.add(jLabel128, gridBagConstraints);

        strongOfficerProbSlider.setMajorTickSpacing(10);
        strongOfficerProbSlider.setMinorTickSpacing(1);
        strongOfficerProbSlider.setToolTipText("強力勢力中，把這個百分比的武將的能力再加以強化。");
        strongOfficerProbSlider.setValue(25);
        strongOfficerProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                strongOfficerProbSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel20.add(strongOfficerProbSlider, gridBagConstraints);

        strongOfficerProbLabel.setText("25%");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel20.add(strongOfficerProbLabel, gridBagConstraints);

        jLabel129.setText("能力 = 原能力 x ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel20.add(jLabel129, gridBagConstraints);

        strongOfficerAbilityMulText.setText("1");
        strongOfficerAbilityMulText.setToolTipText("把強力武將的能力再乘上這個數字");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel20.add(strongOfficerAbilityMulText, gridBagConstraints);

        jLabel130.setText("+");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel20.add(jLabel130, gridBagConstraints);

        strongOfficerAbilityAbsText.setText("20");
        strongOfficerAbilityAbsText.setToolTipText("把強力武將的能力再加上這個數字");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel20.add(strongOfficerAbilityAbsText, gridBagConstraints);

        jLabel131.setText("技能機率參數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel20.add(jLabel131, gridBagConstraints);

        strongOfficerSpecialProbText.setText("30");
        strongOfficerSpecialProbText.setToolTipText("<html>強力武將取得額外技能的機率參數，數值愈高取得技能機率愈高。\n如以種類方法生成武將，取得技能的機率將與技能級數及類型相關。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel20.add(strongOfficerSpecialProbText, gridBagConstraints);

        jLabel134.setText("特技機率參數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel20.add(jLabel134, gridBagConstraints);

        strongOfficerStuntProbText.setText("30");
        strongOfficerStuntProbText.setToolTipText("<html>武將取得特技的額外機率參數，數值愈高取得特技機率愈高。\n如以種類方法生成武將，取得特技的機率將與特技類型相關。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel20.add(strongOfficerStuntProbText, gridBagConstraints);

        jLabel137.setText("每城池額外武將數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel20.add(jLabel137, gridBagConstraints);

        strongFactionOfficerLoText.setText("4");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel20.add(strongFactionOfficerLoText, gridBagConstraints);

        jLabel138.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel20.add(jLabel138, gridBagConstraints);

        strongFactionOfficerHiText.setText("8");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel20.add(strongFactionOfficerHiText, gridBagConstraints);

        jLabel139.setText("x  10");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel20.add(jLabel139, gridBagConstraints);

        strongOfficerPopularityHiText.setText("400");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel20.add(strongOfficerPopularityHiText, gridBagConstraints);

        jLabel140.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel20.add(jLabel140, gridBagConstraints);

        strongOfficerPopularityLoText.setText("0");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel20.add(strongOfficerPopularityLoText, gridBagConstraints);

        jLabel141.setText("名聲");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel20.add(jLabel141, gridBagConstraints);

        strongOfficerIdealTendencyCheckbox.setText("強力武將非常在意相性");
        strongOfficerIdealTendencyCheckbox.setToolTipText("令強力武將非常在意相性，令其較難被其他勢力所登庸");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel20.add(strongOfficerIdealTendencyCheckbox, gridBagConstraints);

        strongKingAmbitionCheckbox.setText("勢力君主野心最高");
        strongKingAmbitionCheckbox.setToolTipText("強力勢力的君主的野心設置為最大");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel20.add(strongKingAmbitionCheckbox, gridBagConstraints);

        strongOfficerLoyaltyCheckbox.setText("強力武將忠誠最高");
        strongOfficerLoyaltyCheckbox.setToolTipText("把強力武將的忠誠設置得很高，令其較難被其他勢力所登庸");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel20.add(strongOfficerLoyaltyCheckbox, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.PAGE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel18.add(jPanel20, gridBagConstraints);

        jLabel132.setText("強力勢力最少武將數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel18.add(jLabel132, gridBagConstraints);

        strongFactionMinOfficerText.setText("10");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel18.add(strongFactionMinOfficerText, gridBagConstraints);

        jLabel133.setText("聲望");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel18.add(jLabel133, gridBagConstraints);

        strongFactionReputationLoText.setText("200");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel18.add(strongFactionReputationLoText, gridBagConstraints);

        jLabel135.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel18.add(jLabel135, gridBagConstraints);

        strongFactionReputationHiText.setText("500");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel18.add(strongFactionReputationHiText, gridBagConstraints);

        jLabel136.setText(" x 10");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel18.add(jLabel136, gridBagConstraints);

        strongFactionSpecialTroopLabel.setText("30%");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel18.add(strongFactionSpecialTroopLabel, gridBagConstraints);

        jLabel160.setText("勢力獲得特殊兵種機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel18.add(jLabel160, gridBagConstraints);

        strongFactionSpecialTroopSlider.setMajorTickSpacing(10);
        strongFactionSpecialTroopSlider.setMinorTickSpacing(1);
        strongFactionSpecialTroopSlider.setToolTipText("勢力獲得特殊兵種機率。\n");
        strongFactionSpecialTroopSlider.setValue(30);
        strongFactionSpecialTroopSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                strongFactionSpecialTroopSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel18.add(strongFactionSpecialTroopSlider, gridBagConstraints);

        jTabbedPane1.addTab("強力勢力", jPanel18);

        jPanel11.setLayout(new java.awt.GridBagLayout());

        jPanel14.setBorder(javax.swing.BorderFactory.createTitledBorder("父母子女"));
        jPanel14.setLayout(new java.awt.GridBagLayout());

        jLabel72.setText("有子女機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(jLabel72, gridBagConstraints);

        hasChildrenProbSlider.setMajorTickSpacing(10);
        hasChildrenProbSlider.setMinorTickSpacing(1);
        hasChildrenProbSlider.setToolTipText("武將有子女的機率");
        hasChildrenProbSlider.setValue(10);
        hasChildrenProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                hasChildrenProbSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        jPanel14.add(hasChildrenProbSlider, gridBagConstraints);

        hasChildrenProbLabel.setText("10%");
        hasChildrenProbLabel.setToolTipText("武將有子女的機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(hasChildrenProbLabel, gridBagConstraints);

        jLabel73.setText("君主有更多子女機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(jLabel73, gridBagConstraints);

        kingHasMoreChildrenProbSlider.setMajorTickSpacing(10);
        kingHasMoreChildrenProbSlider.setMinorTickSpacing(1);
        kingHasMoreChildrenProbSlider.setToolTipText("君主有超過一名子女的額外機率");
        kingHasMoreChildrenProbSlider.setValue(30);
        kingHasMoreChildrenProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                kingHasMoreChildrenProbSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        jPanel14.add(kingHasMoreChildrenProbSlider, gridBagConstraints);

        kingHasMoreChildrenProbLabel.setText("30%");
        kingHasMoreChildrenProbLabel.setToolTipText("君主有超過一名子女的額外機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(kingHasMoreChildrenProbLabel, gridBagConstraints);

        jLabel74.setText("最大世代");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(jLabel74, gridBagConstraints);

        generationHiText.setText("3");
        generationHiText.setToolTipText("一個家族下可傳承的最大世代數目");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(generationHiText, gridBagConstraints);

        jLabel76.setText("配偶機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(jLabel76, gridBagConstraints);

        spouseProbSlider.setMajorTickSpacing(10);
        spouseProbSlider.setMinorTickSpacing(1);
        spouseProbSlider.setToolTipText("武將的配偶也為武將的機率");
        spouseProbSlider.setValue(75);
        spouseProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                spouseProbSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        jPanel14.add(spouseProbSlider, gridBagConstraints);

        spouseProbLabel.setText("75%");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(spouseProbLabel, gridBagConstraints);

        jLabel75.setText("子女忠誠");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(jLabel75, gridBagConstraints);

        childrenLoyaltyLoText.setText("100");
        childrenLoyaltyLoText.setToolTipText("子女武將對國家的忠誠");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(childrenLoyaltyLoText, gridBagConstraints);

        jLabel77.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(jLabel77, gridBagConstraints);

        childrenLoyaltyHiText.setText("120");
        childrenLoyaltyHiText.setToolTipText("子女武將對國家的忠誠");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(childrenLoyaltyHiText, gridBagConstraints);

        parentAffectAbilityCheckbox.setSelected(true);
        parentAffectAbilityCheckbox.setText("子女能力受父母影響");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(parentAffectAbilityCheckbox, gridBagConstraints);

        jLabel79.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(jLabel79, gridBagConstraints);

        childrenPopularityHiText.setText("0.2");
        childrenPopularityHiText.setToolTipText("子女的名聲為父母名聲的比率值");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(childrenPopularityHiText, gridBagConstraints);

        childrenPopularityLoText.setText("0.01");
        childrenPopularityLoText.setToolTipText("子女的名聲為父母名聲的比率值");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(childrenPopularityLoText, gridBagConstraints);

        jLabel78.setText("子女名聲乘數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(jLabel78, gridBagConstraints);

        jLabel80.setText("子女相性最大相差");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(jLabel80, gridBagConstraints);

        childrenAttachmentText.setText("10");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(childrenAttachmentText, gridBagConstraints);

        jLabel81.setText("子女與父母出生年相距");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(jLabel81, gridBagConstraints);

        childrenParentYearLoText.setText("20");
        childrenParentYearLoText.setToolTipText("母親");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(childrenParentYearLoText, gridBagConstraints);

        jLabel82.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(jLabel82, gridBagConstraints);

        childrenParentYearHiText.setText("60");
        childrenParentYearHiText.setToolTipText("母親生下子女的母親年齡界限");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(childrenParentYearHiText, gridBagConstraints);

        jLabel83.setText("子女能力額外基值");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(jLabel83, gridBagConstraints);

        childrenAbilityBaseText.setText("0");
        childrenAbilityBaseText.setToolTipText("子女的能力為父母的能力之間外，額外再加上這個數字");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(childrenAbilityBaseText, gridBagConstraints);

        jLabel84.setText("變異參數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(jLabel84, gridBagConstraints);

        childrenAbilityVarText.setText("10");
        childrenAbilityVarText.setToolTipText("子女的能力最大可高於或低於父母的能力的相差");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(childrenAbilityVarText, gridBagConstraints);

        jLabel85.setText("子女技能習得基值");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(jLabel85, gridBagConstraints);

        childrenSkillBaseText.setText("50");
        childrenSkillBaseText.setToolTipText("子女能從父母習得技能的參數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(childrenSkillBaseText, gridBagConstraints);

        jLabel86.setText("變異參數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(jLabel86, gridBagConstraints);

        childrenSkillVarText.setText("10");
        childrenSkillVarText.setToolTipText("子女習得父母均沒有的技能，或不能習得父母皆有的技能的參數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(childrenSkillVarText, gridBagConstraints);

        jLabel87.setText("子女特技習得基值");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(jLabel87, gridBagConstraints);

        childrenStuntBaseText.setText("50");
        childrenStuntBaseText.setToolTipText("子女能從父母習得特技的參數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(childrenStuntBaseText, gridBagConstraints);

        jLabel88.setText("變異參數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(jLabel88, gridBagConstraints);

        childrenStuntVarText.setText("10");
        childrenStuntVarText.setToolTipText("子女習得父母均沒有的特技，或不能習得父母皆有的特技的參數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(childrenStuntVarText, gridBagConstraints);

        jLabel89.setText("子女個人稱號傳承參數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(jLabel89, gridBagConstraints);

        childrenPersonalTitleText.setText("15");
        childrenPersonalTitleText.setToolTipText("子女得到父母的個人稱號參數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(childrenPersonalTitleText, gridBagConstraints);

        jLabel90.setText("子女戰鬥稱號傳承參數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(jLabel90, gridBagConstraints);

        childrenBattleTitleText.setText("15");
        childrenBattleTitleText.setToolTipText("子女得到父母的戰鬥稱號參數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(childrenBattleTitleText, gridBagConstraints);

        jLabel91.setText("君主有子女機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(jLabel91, gridBagConstraints);

        kingHasChildrenProbSlider.setMajorTickSpacing(10);
        kingHasChildrenProbSlider.setMinorTickSpacing(1);
        kingHasChildrenProbSlider.setToolTipText("君主有子女的額外機率");
        kingHasChildrenProbSlider.setValue(30);
        kingHasChildrenProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                kingHasChildrenProbSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        jPanel14.add(kingHasChildrenProbSlider, gridBagConstraints);

        kingHasChildrenProbLabel.setText("30%");
        kingHasChildrenProbLabel.setToolTipText("君主有子女的額外機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(kingHasChildrenProbLabel, gridBagConstraints);

        jLabel92.setText("有更多子女機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(jLabel92, gridBagConstraints);

        hasMoreChildrenProbSlider.setMajorTickSpacing(10);
        hasMoreChildrenProbSlider.setMinorTickSpacing(1);
        hasMoreChildrenProbSlider.setToolTipText("武將有超過一名子女的機率");
        hasMoreChildrenProbSlider.setValue(10);
        hasMoreChildrenProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                hasMoreChildrenProbSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        jPanel14.add(hasMoreChildrenProbSlider, gridBagConstraints);

        hasMoreChildrenProbLabel.setText("10%");
        hasMoreChildrenProbLabel.setToolTipText("武將有超過一名子女的機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel14.add(hasMoreChildrenProbLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel11.add(jPanel14, gridBagConstraints);

        jPanel27.setBorder(javax.swing.BorderFactory.createTitledBorder("武將關係"));
        jPanel27.setLayout(new java.awt.GridBagLayout());

        jLabel166.setText("厭惡武將機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 8, 8);
        jPanel27.add(jLabel166, gridBagConstraints);

        hateOfficerProbSlider.setMajorTickSpacing(10);
        hateOfficerProbSlider.setMinorTickSpacing(1);
        hateOfficerProbSlider.setToolTipText("武將選擇任意厭惡武將的機率");
        hateOfficerProbSlider.setValue(15);
        hateOfficerProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                hateOfficerProbSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.insets = new java.awt.Insets(4, 8, 4, 8);
        jPanel27.add(hateOfficerProbSlider, gridBagConstraints);

        hateOfficerProbLabel.setText("15%");
        hateOfficerProbLabel.setToolTipText("武將有子女的機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 8, 8);
        jPanel27.add(hateOfficerProbLabel, gridBagConstraints);

        jLabel167.setText("配偶親愛機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 8, 8);
        jPanel27.add(jLabel167, gridBagConstraints);

        spouseImitateProbSlider.setMajorTickSpacing(10);
        spouseImitateProbSlider.setMinorTickSpacing(1);
        spouseImitateProbSlider.setToolTipText("武將親愛其配偶的機率");
        spouseImitateProbSlider.setValue(95);
        spouseImitateProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                spouseImitateProbSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.insets = new java.awt.Insets(4, 8, 4, 8);
        jPanel27.add(spouseImitateProbSlider, gridBagConstraints);

        spouseImitateProbLabel.setText("95%");
        spouseImitateProbLabel.setToolTipText("武將有子女的機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 8, 8);
        jPanel27.add(spouseImitateProbLabel, gridBagConstraints);

        jLabel168.setText("親密血緣親愛機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 8, 8);
        jPanel27.add(jLabel168, gridBagConstraints);

        closeImitateProbSlider.setMajorTickSpacing(10);
        closeImitateProbSlider.setMinorTickSpacing(1);
        closeImitateProbSlider.setToolTipText("武將親愛其父母、兄弟姊妹的機率");
        closeImitateProbSlider.setValue(60);
        closeImitateProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                closeImitateProbSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.insets = new java.awt.Insets(4, 8, 4, 8);
        jPanel27.add(closeImitateProbSlider, gridBagConstraints);

        closeImitateProbLabel.setText("60%");
        closeImitateProbLabel.setToolTipText("武將有子女的機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 8, 8);
        jPanel27.add(closeImitateProbLabel, gridBagConstraints);

        jLabel169.setText("親愛武將機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 8, 8);
        jPanel27.add(jLabel169, gridBagConstraints);

        imitateOfficerProbSlider.setMajorTickSpacing(10);
        imitateOfficerProbSlider.setMinorTickSpacing(1);
        imitateOfficerProbSlider.setToolTipText("武將選擇任意親愛武將的機率");
        imitateOfficerProbSlider.setValue(15);
        imitateOfficerProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                imitateOfficerProbSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.insets = new java.awt.Insets(4, 8, 4, 8);
        jPanel27.add(imitateOfficerProbSlider, gridBagConstraints);

        imitateOfficerProbLabel.setText("15%");
        imitateOfficerProbLabel.setToolTipText("武將有子女的機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 8, 8);
        jPanel27.add(imitateOfficerProbLabel, gridBagConstraints);

        bwrb.setText("血緣親愛機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 8, 8);
        jPanel27.add(bwrb, gridBagConstraints);

        bloodImitateProbSlider.setMajorTickSpacing(10);
        bloodImitateProbSlider.setMinorTickSpacing(1);
        bloodImitateProbSlider.setToolTipText("武將親愛其同族將領的機率");
        bloodImitateProbSlider.setValue(20);
        bloodImitateProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                bloodImitateProbSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.insets = new java.awt.Insets(4, 8, 4, 8);
        jPanel27.add(bloodImitateProbSlider, gridBagConstraints);

        bloodImitateProbLabel.setText("20%");
        bloodImitateProbLabel.setToolTipText("武將有子女的機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 8, 8);
        jPanel27.add(bloodImitateProbLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel11.add(jPanel27, gridBagConstraints);

        jTabbedPane1.addTab("人物關係", jPanel11);

        jPanel21.setLayout(new java.awt.GridBagLayout());

        jPanel15.setBorder(javax.swing.BorderFactory.createTitledBorder("勢力據點"));
        jPanel15.setLayout(new java.awt.GridBagLayout());

        jLabel106.setText("勢力有更多城池機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel15.add(jLabel106, gridBagConstraints);

        moreCityFactionProbSlider.setMajorTickSpacing(10);
        moreCityFactionProbSlider.setMinorTickSpacing(1);
        moreCityFactionProbSlider.setToolTipText("勢力有多一個城池的機率，每多一個城池，則以這個機率再增加城池。");
        moreCityFactionProbSlider.setValue(25);
        moreCityFactionProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                moreCityFactionProbSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 120;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel15.add(moreCityFactionProbSlider, gridBagConstraints);

        moreCityFactionProbLabel.setText("25%");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel15.add(moreCityFactionProbLabel, gridBagConstraints);

        connectedFactionCityCheckbox.setSelected(true);
        connectedFactionCityCheckbox.setText("勢力城池必須為連續");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel15.add(connectedFactionCityCheckbox, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel21.add(jPanel15, gridBagConstraints);

        jPanel16.setBorder(javax.swing.BorderFactory.createTitledBorder("勢力外交度"));
        jPanel16.setLayout(new java.awt.GridBagLayout());

        jLabel107.setText("勢力外交度");
        jPanel16.add(jLabel107, new java.awt.GridBagConstraints());

        factionDiplomacyLoText.setText("-100");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel16.add(factionDiplomacyLoText, gridBagConstraints);

        jLabel108.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel16.add(jLabel108, gridBagConstraints);

        factionDiplomacyHiText.setText("100");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel16.add(factionDiplomacyHiText, gridBagConstraints);

        gaussianDiplomacyCheckbox.setText("勢力外交集中於中間值");
        gaussianDiplomacyCheckbox.setToolTipText("如點上這項，勢力的外交度會集中在上下限的中間值，否則外交度會在上下限間平均分佈。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        jPanel16.add(gaussianDiplomacyCheckbox, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel21.add(jPanel16, gridBagConstraints);

        jPanel17.setBorder(javax.swing.BorderFactory.createTitledBorder("勢力特殊兵種"));
        jPanel17.setLayout(new java.awt.GridBagLayout());

        jLabel109.setText("勢力獲得特殊兵種機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel17.add(jLabel109, gridBagConstraints);

        factionSpecialTroopSlider.setMajorTickSpacing(10);
        factionSpecialTroopSlider.setMinorTickSpacing(1);
        factionSpecialTroopSlider.setToolTipText("勢力獲得技術機率。如技術有前提技術，勢力必須擁有其前提技術再可獲該技術。\n");
        factionSpecialTroopSlider.setValue(15);
        factionSpecialTroopSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                factionSpecialTroopSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.ipadx = 150;
        jPanel17.add(factionSpecialTroopSlider, gridBagConstraints);

        factionSpecialTroopLabel.setText("15%");
        jPanel17.add(factionSpecialTroopLabel, new java.awt.GridBagConstraints());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel21.add(jPanel17, gridBagConstraints);

        maleKingCheckbox.setText("勢力君主必為男性");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel21.add(maleKingCheckbox, gridBagConstraints);

        jPanel23.setBorder(javax.swing.BorderFactory.createTitledBorder("寶物"));
        jPanel23.setLayout(new java.awt.GridBagLayout());

        jLabel146.setText("寶物數量");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel23.add(jLabel146, gridBagConstraints);

        treasureCntLoText.setText("90");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel23.add(treasureCntLoText, gridBagConstraints);

        jLabel147.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel23.add(jLabel147, gridBagConstraints);

        treasureCntHiText.setText("110");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel23.add(treasureCntHiText, gridBagConstraints);

        jPanel24.setBorder(javax.swing.BorderFactory.createTitledBorder("寶物種類比重"));
        jPanel24.setLayout(new java.awt.GridLayout(3, 2, 4, 4));

        jLabel148.setText("武器");
        jPanel24.add(jLabel148);

        treasureWeaponProbText.setText("5");
        treasureWeaponProbText.setToolTipText("生成寶物時，生成武器的機率比重");
        jPanel24.add(treasureWeaponProbText);

        jLabel149.setText("書籍");
        jPanel24.add(jLabel149);

        treasureBookProbText.setText("4");
        treasureBookProbText.setToolTipText("生成寶物時，生成書籍的機率比重");
        jPanel24.add(treasureBookProbText);

        jLabel150.setText("馬匹");
        jPanel24.add(jLabel150);

        treasureHorseProbText.setText("1");
        treasureHorseProbText.setToolTipText("生成寶物時，生成馬匹的機率比重");
        jPanel24.add(treasureHorseProbText);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel23.add(jPanel24, gridBagConstraints);

        jLabel151.setText("寶物價值");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel23.add(jLabel151, gridBagConstraints);

        treasurePriceLoText.setText("10");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel23.add(treasurePriceLoText, gridBagConstraints);

        jLabel152.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel23.add(jLabel152, gridBagConstraints);

        treasurePriceHiText.setText("50");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel23.add(treasurePriceHiText, gridBagConstraints);

        jLabel153.setText("寶物出現年份");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel23.add(jLabel153, gridBagConstraints);

        treasureYearLoText.setText("160");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel23.add(treasureYearLoText, gridBagConstraints);

        jLabel154.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel23.add(jLabel154, gridBagConstraints);

        treasureYearHiText.setText("250");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel23.add(treasureYearHiText, gridBagConstraints);

        jLabel155.setText("寶物性價比參數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel23.add(jLabel155, gridBagConstraints);

        treasurePriceRateText.setText("1.5");
        treasurePriceRateText.setToolTipText("<html>寶物實質能力與其價值的比例參數。數值愈高，價值相等的情況下，寶物實質能力愈強。<br>\n所有寶物均有大致相同的性價比。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel23.add(treasurePriceRateText, gridBagConstraints);

        treasureOwnedProbSlider.setMajorTickSpacing(10);
        treasureOwnedProbSlider.setMinorTickSpacing(1);
        treasureOwnedProbSlider.setToolTipText("寶物在遊戲開始時已經有擁有者的機率。");
        treasureOwnedProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                treasureOwnedProbSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel23.add(treasureOwnedProbSlider, gridBagConstraints);

        treasureOwnedProbLabel.setText("50%");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel23.add(treasureOwnedProbLabel, gridBagConstraints);

        jLabel156.setText("寶物已有擁有者機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel23.add(jLabel156, gridBagConstraints);

        treasurePriceGaussianCheckbox.setText("寶物價值集中中間值");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel23.add(treasurePriceGaussianCheckbox, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel21.add(jPanel23, gridBagConstraints);

        jPanel25.setBorder(javax.swing.BorderFactory.createTitledBorder("勢力技術"));
        jPanel25.setLayout(new java.awt.GridBagLayout());

        jLabel159.setText("勢力獲得技術機率");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel25.add(jLabel159, gridBagConstraints);

        factionTechniqueProbSlider.setMajorTickSpacing(10);
        factionTechniqueProbSlider.setMinorTickSpacing(1);
        factionTechniqueProbSlider.setToolTipText("勢力獲得特殊兵種機率。");
        factionTechniqueProbSlider.setValue(10);
        factionTechniqueProbSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                factionTechniqueProbSliderStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.ipadx = 150;
        jPanel25.add(factionTechniqueProbSlider, gridBagConstraints);

        factionTechniqueProbLabel.setText("10%");
        jPanel25.add(factionTechniqueProbLabel, new java.awt.GridBagConstraints());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel21.add(jPanel25, gridBagConstraints);

        jTabbedPane1.addTab("勢力與寶物", jPanel21);

        jPanel28.setLayout(new java.awt.GridBagLayout());

        createMapCheckbox.setText("生成地圖");
        createMapCheckbox.setToolTipText("<html>是否把地圖換成生成地圖。<br>\n注意：生成地圖可能會導致城池出現在水上，甚至沒有連接。");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel28.add(createMapCheckbox, gridBagConstraints);

        jPanel29.setBorder(javax.swing.BorderFactory.createTitledBorder("地型設定"));
        jPanel29.setMinimumSize(new java.awt.Dimension(500, 200));
        jPanel29.setLayout(new java.awt.BorderLayout());

        jScrollPane1.setMaximumSize(new java.awt.Dimension(480, 170));

        terrainSettingTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {"沙漠", new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0)},
                {"濕地", new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0)},
                {"雪地", new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0)},
                {"荒地", new Integer(4), new Integer(12), new Integer(225), new Integer(400), new Integer(0), new Integer(0)},
                {"平地", new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0)},
                {"草原", new Integer(4), new Integer(12), new Integer(500), new Integer(800), new Integer(0), new Integer(0)},
                {"山地", new Integer(40), new Integer(80), new Integer(150), new Integer(200), new Integer(0), new Integer(0)},
                {"森林", new Integer(40), new Integer(80), new Integer(150), new Integer(200), new Integer(0), new Integer(0)},
                {"峻嶺", new Integer(25), new Integer(40), new Integer(15), new Integer(40), new Integer(1000), new Integer(1000)},
                {"水域", new Integer(4), new Integer(6), new Integer(400), new Integer(1000), new Integer(5), new Integer(20)}
            },
            new String [] {
                "地型", "塊數下限", "塊數上限", "大小下限", "大小上限", "幼長度下限", "幼長度上限"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.String.class, java.lang.Integer.class, java.lang.Integer.class, java.lang.Integer.class, java.lang.Integer.class, java.lang.Integer.class, java.lang.Integer.class
            };
            boolean[] canEdit = new boolean [] {
                false, true, true, true, true, true, true
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        terrainSettingTable.setToolTipText("<html>把其他地型加進只有起始地型的地圖中。");
        terrainSettingTable.setMinimumSize(new java.awt.Dimension(525, 240));
        terrainSettingTable.getTableHeader().setReorderingAllowed(false);
        jScrollPane1.setViewportView(terrainSettingTable);

        jPanel29.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.ipady = -239;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel28.add(jPanel29, gridBagConstraints);

        jLabel162.setText("大小");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel28.add(jLabel162, gridBagConstraints);

        mapSizeXText.setText("150");
        mapSizeXText.setToolTipText("地圖東至西格數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel28.add(mapSizeXText, gridBagConstraints);

        jLabel170.setText("x");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel28.add(jLabel170, gridBagConstraints);

        mapSizeYText.setText("150");
        mapSizeYText.setToolTipText("地圖南至北格數");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel28.add(mapSizeYText, gridBagConstraints);

        jPanel30.setBorder(javax.swing.BorderFactory.createTitledBorder("城池數目"));
        jPanel30.setLayout(new java.awt.GridBagLayout());

        jLabel172.setText("城池數目");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel30.add(jLabel172, gridBagConstraints);

        mapHarbourCntLoText.setText("12");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel30.add(mapHarbourCntLoText, gridBagConstraints);

        jLabel171.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel30.add(jLabel171, gridBagConstraints);

        mapHarbourCntHiText.setText("25");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel30.add(mapHarbourCntHiText, gridBagConstraints);

        jLabel173.setText("港口數目");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel30.add(jLabel173, gridBagConstraints);

        mapCitySizeLoText.setText("1");
        mapCitySizeLoText.setToolTipText("城池所佔格數下限");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel30.add(mapCitySizeLoText, gridBagConstraints);

        jLabel174.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel30.add(jLabel174, gridBagConstraints);

        mapCitySizeHiText.setText("9");
        mapCitySizeHiText.setToolTipText("城池所佔格數上限");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel30.add(mapCitySizeHiText, gridBagConstraints);

        jLabel175.setText("城池大小");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel30.add(jLabel175, gridBagConstraints);

        mapCityCntLoText.setText("45");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel30.add(mapCityCntLoText, gridBagConstraints);

        jLabel176.setText("至");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel30.add(jLabel176, gridBagConstraints);

        mapCityCntHiText.setText("66");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel30.add(mapCityCntHiText, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel28.add(jPanel30, gridBagConstraints);

        jLabel177.setText("起始地型");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LAST_LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel28.add(jLabel177, gridBagConstraints);

        mapStartTerrainCombo.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "平地", "草原", "森林", "山地", "水域", "荒地", "峻嶺", "濕地", "沙漠", "雪地" }));
        mapStartTerrainCombo.setToolTipText("生成地圖時，原來的地圖地型");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LAST_LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel28.add(mapStartTerrainCombo, gridBagConstraints);

        jTabbedPane1.addTab("地圖", jPanel28);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipady = -39;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(jTabbedPane1, gridBagConstraints);

        exportSettingButton.setText("導出");
        exportSettingButton.setToolTipText("導出設定檔。");
        exportSettingButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                exportSettingButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(exportSettingButton, gridBagConstraints);

        importSettingButton.setText("導入");
        importSettingButton.setToolTipText("導入設定檔。");
        importSettingButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                importSettingButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(importSettingButton, gridBagConstraints);

        changeGamePathButton.setText("設置遊戲路徑");
        changeGamePathButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                changeGamePathButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(changeGamePathButton, gridBagConstraints);

        langCombo.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "繁體版", "简体版" }));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(langCombo, gridBagConstraints);

        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setBounds((screenSize.width-749)/2, (screenSize.height-555)/2, 749, 555);
    }// </editor-fold>//GEN-END:initComponents

    private Officer generateOfficer(Database db, int id, int scenYear, List<Building> allBuildings, Officer father, Officer mother,
            boolean parentAffect, Connection commonData) throws SQLException, IOException {
        Officer o = new Officer(db, id, (father != null && father.isStrong()) || (mother != null && mother.isStrong()), commonData);

        o.setParent(father, mother);

        o.setRandomGender(femaleOfficerProbSlider.getValue() / 100.0);

        o.setRandomNames(doubleNameProbSlider.getValue() / 100.0);

        if (parentAffect) {
            o.abilityFromParent(Integer.parseInt(abilityLoText.getText()), Integer.parseInt(abilityHiText.getText()),
                    Integer.parseInt(childrenAbilityBaseText.getText()), Integer.parseInt(childrenAbilityVarText.getText()));
        } else {
            o.randomAbility(Double.parseDouble(abilityMulText.getText()), Double.parseDouble(abilityAbsText.getText()),
                    Integer.parseInt(abilityLoText.getText()), Integer.parseInt(abilityHiText.getText()));
        }

        if (randomFaceRadio.isSelected()) {
            o.randomFaceImage();
        } else if (genderFaceRadio.isSelected()) {
            o.setFace(db);
        } else {
            o.setTypedFace(db);
        }

        o.yearFromParent(scenYear,
                Integer.parseInt(bornYearLoText.getText()),
                Integer.parseInt(bornYearHiText.getText()),
                Integer.parseInt(deadYearLoText.getText()),
                Integer.parseInt(deadYearHiText.getText()), allBuildings,
                Integer.parseInt(childrenParentYearLoText.getText()),
                Integer.parseInt(childrenParentYearHiText.getText()));

        double noSpecialProb = 0;
        if (o instanceof TypedOfficer) {
            switch (((TypedOfficer) o).getType()) {
                case 0:
                    noSpecialProb = noSpecialProb1Slider1.getValue() / 100.0;
                    break;
                case 1:
                    noSpecialProb = noSpecialProb1Slider2.getValue() / 100.0;
                    break;
                case 2:
                    noSpecialProb = noSpecialProb1Slider3.getValue() / 100.0;
                    break;
                case 3:
                    noSpecialProb = noSpecialProb1Slider4.getValue() / 100.0;
                    break;
                case 4:
                    noSpecialProb = noSpecialProb1Slider5.getValue() / 100.0;
                    break;
                case 5:
                    noSpecialProb = noSpecialProb1Slider6.getValue() / 100.0;
                    break;
                case 6:
                    noSpecialProb = noSpecialProb1Slider7.getValue() / 100.0;
                    break;
                case 7:
                    noSpecialProb = noSpecialProb1Slider8.getValue() / 100.0;
                    break;
                case 8:
                    noSpecialProb = noSpecialProb1Slider9.getValue() / 100.0;
                    break;
            }
        } else {
            noSpecialProb = noSpecialProb1Slider1.getValue() / 100.0;
        }

        if (parentAffect) {
            o.attachmentFromParent(Integer.parseInt(attachmentLoText.getText()), Integer.parseInt(attachmentHiText.getText()), Integer.parseInt(childrenAttachmentText.getText()));

            o.popularityFromParent(Double.parseDouble(childrenPopularityLoText.getText()), Double.parseDouble(childrenPopularityHiText.getText()));

            o.hiddenValuesFromParent();

            o.specialFromParent(Integer.parseInt(childrenSkillBaseText.getText()), Integer.parseInt(childrenSkillVarText.getText()));

            o.personalTitleFromParent(noSpecialProb, Integer.parseInt(childrenPersonalTitleText.getText()));

            o.battleTitleFromParent(noSpecialProb, Integer.parseInt(childrenBattleTitleText.getText()));

            o.stuntFromParent(Integer.parseInt(childrenStuntBaseText.getText()), Integer.parseInt(childrenStuntVarText.getText()));
        } else {
            o.randomPersonAttachment(Integer.parseInt(attachmentLoText.getText()), Integer.parseInt(attachmentHiText.getText()));

            o.randomPopularity(Integer.parseInt(popularityLoText.getText()), Integer.parseInt(popularityHiText.getText()));

            o.randomHiddenValues();
            
            o.randomLeaderPossibility(Integer.parseInt(leaderPossibilityFactorText.getText()));

            o.randomSpecials(Double.parseDouble(specialProbText.getText()), Integer.parseInt(specialAbyThresholdText.getText()),
                    Double.parseDouble(specialAbyProbText.getText()));

            o.randomPersonalTitles(noSpecialProb);
            o.randomBattleTitles(noSpecialProb);
            
            if (Utility.probTestPercentage(generatedTitleProbSlider.getValue())){
                if (!Utility.probTestPercentage(noSpecialProb)){
                    o.createUniquePersonalTitle(Integer.parseInt(generatedTitleLevelLoText.getText()), Integer.parseInt(generatedTitleLevelHiText.getText())); 
                }
            } else {
                o.randomPersonalTitles(noSpecialProb);
            }

            if (Utility.probTestPercentage(generatedTitleProbSlider.getValue())){
                if (!Utility.probTestPercentage(noSpecialProb)){
                    o.createUniqueBattleTitle(Integer.parseInt(generatedTitleLevelLoText.getText()), Integer.parseInt(generatedTitleLevelHiText.getText())); 
                }
            } else {
                o.randomBattleTitles(noSpecialProb);
            }

            o.randomStunts(Double.parseDouble(stuntProbText.getText()), Integer.parseInt(stuntAbyThresholdText.getText()),
                    Double.parseDouble(stuntAbyProbText.getText()));
        }
        if (o.isStrong() && strongOfficerIdealTendencyCheckbox.isSelected()){
            o.setMaxIdealTendency();
            o.ensureIdealTendency(father == null ? mother : father);
        }
        if (o.isStrong() && strongKingAmbitionCheckbox.isSelected()){
            o.setMaxAmbition();
        }

        if (o.isAvailable()) {
            o.placeInBuildingUnemployed(allBuildings);
        }
        o.setLocationFromParent(Integer.parseInt(childrenLoyaltyLoText.getText()), Integer.parseInt(childrenLoyaltyHiText.getText()));

        return o;

    }

    private Officer generateOfficer(Database db, int id, int scenYear, List<Building> allBuildings, boolean isEmployed, boolean strong, Connection commonData) throws SQLException, IOException {
        Officer o;
        if (randomTypeOfficerRadio.isSelected()) {
            o = new Officer(db, id, strong, commonData);
        } else {
            o = new TypedOfficer(db, Utility.randomCategorize_i(
                    Integer.parseInt(generalTypeWeightText.getText()),
                    Integer.parseInt(mightyTypeWeightText.getText()),
                    Integer.parseInt(advisorTypeWeightText.getText()),
                    Integer.parseInt(politicianTypeWeightText.getText()),
                    Integer.parseInt(intelGeneralTypeWeightText.getText()),
                    Integer.parseInt(emperorTypeWeightText.getText()),
                    Integer.parseInt(allRounderTypeWeightText.getText()),
                    Integer.parseInt(normalTypeWeightText.getText()),
                    Integer.parseInt(cheapTypeWeightText.getText())), id, strong, commonData);
        }
        
        o.completeRandomYears(scenYear,
                Integer.parseInt(debutYearLoText.getText()),
                Integer.parseInt(debutYearHiText.getText()),
                Integer.parseInt(bornYearLoText.getText()),
                Integer.parseInt(bornYearHiText.getText()),
                Integer.parseInt(deadYearLoText.getText()),
                Integer.parseInt(deadYearHiText.getText()),
                isEmployed, allBuildings);
        
        if (isEmployed && !o.isAvailable()) return null;

        o.setRandomGender(femaleOfficerProbSlider.getValue() / 100.0);

        o.setRandomNames(doubleNameProbSlider.getValue() / 100.0);

        o.randomAbility(Double.parseDouble(abilityMulText.getText()), Double.parseDouble(abilityAbsText.getText()),
                Integer.parseInt(abilityLoText.getText()), Integer.parseInt(abilityHiText.getText()));
        if (strong) {
            o.tweakAbility(Double.parseDouble(strongOfficerAbilityMulText.getText()), Integer.parseInt(strongOfficerAbilityAbsText.getText()));
        }

        if (randomFaceRadio.isSelected()) {
            o.randomFaceImage();
        } else if (genderFaceRadio.isSelected()) {
            o.setFace(db);
        } else {
            o.setTypedFace(db);
        }

        o.randomPersonAttachment(Integer.parseInt(attachmentLoText.getText()), Integer.parseInt(attachmentHiText.getText()));

        o.randomPopularity(strong ? Integer.parseInt(strongOfficerPopularityLoText.getText()) : Integer.parseInt(popularityLoText.getText()),
                strong ? Integer.parseInt(strongOfficerPopularityHiText.getText()) : Integer.parseInt(popularityHiText.getText()));

        o.randomHiddenValues();
        if (strong && strongOfficerIdealTendencyCheckbox.isSelected()) {
            o.setMaxIdealTendency();
        }
        
        o.randomLeaderPossibility(Integer.parseInt(leaderPossibilityFactorText.getText()));

        o.randomSpecials(strong ? Double.parseDouble(strongOfficerSpecialProbText.getText()) : Double.parseDouble(specialProbText.getText()),
                Integer.parseInt(specialAbyThresholdText.getText()), Double.parseDouble(specialAbyProbText.getText()));

        double noSpecialProb = 0;
        if (o instanceof TypedOfficer) {
            switch (((TypedOfficer) o).getType()) {
                case 0:
                    noSpecialProb = noSpecialProb1Slider1.getValue() / 100.0;
                    break;
                case 1:
                    noSpecialProb = noSpecialProb1Slider2.getValue() / 100.0;
                    break;
                case 2:
                    noSpecialProb = noSpecialProb1Slider3.getValue() / 100.0;
                    break;
                case 3:
                    noSpecialProb = noSpecialProb1Slider4.getValue() / 100.0;
                    break;
                case 4:
                    noSpecialProb = noSpecialProb1Slider5.getValue() / 100.0;
                    break;
                case 5:
                    noSpecialProb = noSpecialProb1Slider6.getValue() / 100.0;
                    break;
                case 6:
                    noSpecialProb = noSpecialProb1Slider7.getValue() / 100.0;
                    break;
                case 7:
                    noSpecialProb = noSpecialProb1Slider8.getValue() / 100.0;
                    break;
                case 8:
                    noSpecialProb = noSpecialProb1Slider9.getValue() / 100.0;
                    break;
            }
        }
        
        o.randomPersonalTitles(noSpecialProb);
        o.randomBattleTitles(noSpecialProb);
        
        if (Utility.probTestPercentage(generatedTitleProbSlider.getValue())){
            o.createUniquePersonalTitle(Integer.parseInt(generatedTitleLevelLoText.getText()), Integer.parseInt(generatedTitleLevelHiText.getText())); 
        } else {
            o.randomPersonalTitles(noSpecialProb);
        }
        
        if (Utility.probTestPercentage(generatedTitleProbSlider.getValue())){
            o.createUniqueBattleTitle(Integer.parseInt(generatedTitleLevelLoText.getText()), Integer.parseInt(generatedTitleLevelHiText.getText()));
        } else {
            o.randomBattleTitles(noSpecialProb);
        }
        
        o.randomStunts(strong ? Double.parseDouble(strongOfficerStuntProbText.getText()) : Double.parseDouble(stuntProbText.getText()),
                Integer.parseInt(stuntAbyThresholdText.getText()), Double.parseDouble(stuntAbyProbText.getText()));

        if (o.isStrong() && strongKingAmbitionCheckbox.isSelected()){
            o.setMaxAmbition();
        }
        
        if (o.isAvailable()) {
            o.placeInBuildingUnemployed(allBuildings);
        }

        return o;
    }

    private void randomize(Connection scenConn, Connection commonDataConn) throws SQLException, IOException, ClassNotFoundException {
        Database db = new Database(true);

        //write scenyear
        int scenYear = Utility.randBetween(Integer.parseInt(scenYearLo.getText()), Integer.parseInt(scenYearHi.getText()));
        Statement stmt = null;
        try {
            stmt = scenConn.createStatement();
            stmt.executeUpdate("update GameSurvey set GYear = " + scenYear);
        } finally {
            stmt.close();
        }
        
        //create the map
        List<Building> allBuildings;
        GameMap map = null; 
        boolean createMap = createMapCheckbox.isSelected();
        if (createMap){
            List<GameMap.MapSetting> setting = new ArrayList<GameMap.MapSetting>();
            for (int i = 0; i < terrainSettingTable.getModel().getRowCount(); ++i){
                String terrain = terrainSettingTable.getModel().getValueAt(i, 0).toString();
                GameMap.MapSetting e = new GameMap.MapSetting();
                e.terrain = GameMap.strToTerrain(terrain);
                e.pieceLo = Integer.parseInt(terrainSettingTable.getModel().getValueAt(i, 1).toString());
                e.pieceHi = Integer.parseInt(terrainSettingTable.getModel().getValueAt(i, 2).toString());
                e.sizeLo = Integer.parseInt(terrainSettingTable.getModel().getValueAt(i, 3).toString());
                e.sizeLo = Integer.parseInt(terrainSettingTable.getModel().getValueAt(i, 4).toString());
                e.thinnessLo = Integer.parseInt(terrainSettingTable.getModel().getValueAt(i, 5).toString());
                e.thinnessHi = Integer.parseInt(terrainSettingTable.getModel().getValueAt(i, 6).toString());
                setting.add(e);
            }
            String terrainStartStr = (String) mapStartTerrainCombo.getSelectedItem();
            map = GameMap.createMap(Integer.parseInt(mapSizeXText.getText()), Integer.parseInt(mapSizeYText.getText()), 
                    GameMap.strToTerrain(terrainStartStr), setting);
            allBuildings = map.populateWithNewBuildings(Integer.parseInt(mapCityCntLoText.getText()), Integer.parseInt(mapCityCntHiText.getText()),
                    Integer.parseInt(mapHarbourCntLoText.getText()), Integer.parseInt(mapHarbourCntHiText.getText()),
                    Integer.parseInt(mapCitySizeLoText.getText()), Integer.parseInt(mapCitySizeHiText.getText()));
        } else {
            allBuildings = Building.readBuildings(scenConn);
        }
        
        //create influences
        InfluenceRate.addInfluences(commonDataConn, InfluenceKindRate.generateInfluences(commonDataConn, Utility.randBetween(800, 1200)));

        List<Officer> allOfficers = new ArrayList<Officer>();

        /**
         * Only Officers, Buildings and Factions are created directly by frontend. Other objects are called by other related
         * entites.
         */
        Statement stmt2 = null;
        try {
            stmt2 = scenConn.createStatement();
            stmt2.executeUpdate("update Architecture set Persons =''");
        } finally {
            stmt2.close();
        }

        //get ids of colors
        stmt2 = null;
        List<Integer> colorIds = null;
        try {
            stmt2 = commonDataConn.createStatement();
            ResultSet rs = stmt2.executeQuery("select ID from Color");
            colorIds = Utility.resultSetToId(rs);
        } finally {
            stmt2.close();
        }

        //choose kings and colors
        int factionNo = Utility.randBetween(Integer.parseInt(factionCntLoText.getText()), Integer.parseInt(factionCntHiText.getText()));
        List<Integer> colors;
        if (colorIds.size() < factionNo) {
            colors = new ArrayList<Integer>(colorIds);
            Collections.shuffle(colors);
        } else {
            colors = Utility.subset(colorIds, factionNo);
        }
        List<Faction> factions = new ArrayList<Faction>();

        //generate factions, and officers on the fly
        int officerId = 1000;
        int strongFactionCnt = Utility.randBetween(Integer.parseInt(strongFactionLoText.getText()), Integer.parseInt(strongFactionHiText.getText()));
        int strongFactionMade = 0;
        for (int i = 0; i < factionNo; ++i) {
            if (allOfficers.size() > MAX_OFFICER) {
                break;
            }
            int cityCnt = 1;
            while (Utility.probTestPercentage(moreCityFactionProbSlider.getValue())) {
                cityCnt++;
            }
            int factionOfficerCnt = Utility.randBetween(Integer.parseInt(factionOfficerLoText.getText()) * cityCnt, Integer.parseInt(factionOfficerHiText.getText()) * cityCnt);
            boolean strong = false;
            if (strongFactionMade < strongFactionCnt && factionOfficerCnt > Integer.parseInt(strongFactionMinOfficerText.getText())) {
                strong = true;
                strongFactionMade++;
                while (Utility.probTestPercentage(strongFactionMoreCityProbSlider.getValue())) {
                    cityCnt++;
                }
                factionOfficerCnt += Utility.randBetween(Integer.parseInt(strongFactionOfficerLoText.getText()) * cityCnt, Integer.parseInt(strongFactionOfficerHiText.getText()) * cityCnt);
            }
            Faction f = new Faction(i, strong, commonDataConn);
            f.randomReputation(Integer.parseInt(strong ? strongFactionReputationLoText.getText() : reputationLoText.getText()),
                    Integer.parseInt(strong ? strongFactionReputationHiText.getText() : reputationHiText.getText()));
            f.randomTroopKinds(strong ? strongFactionSpecialTroopSlider.getValue() : factionSpecialTroopSlider.getValue());
            f.randomTechniques((strong ? strongFactionTechniqueProbSlider.getValue() : factionTechniqueProbSlider.getValue()) / 100.0);
            f.setColor(colors.get(i % colors.size()));
            //prepare officer in the faction and populate the faction
            List<Officer> officers = new ArrayList<Officer>();
            List<Officer> kingCandidates = new ArrayList<Officer>();
            for (int j = 0; j < factionOfficerCnt; j++) {
                //search for available officer id first
                Officer o;
                if (useScenOfficerCheckbox.isSelected()){
                    o = ScenOfficerReader.readOfficer(commonDataConn, tc, officerId);
                    if (o == null){
                        o = generateOfficer(db, officerId, scenYear, allBuildings, true, strong && Utility.probTestPercentage(strongOfficerProbSlider.getValue()), commonDataConn);
                    } else {
                        o.setAvailability(scenYear, allBuildings);
                    }
                } else {
                    o = generateOfficer(db, officerId, scenYear, allBuildings, true, strong && Utility.probTestPercentage(strongOfficerProbSlider.getValue()), commonDataConn);
                }
                if (o != null && o.isAvailable()) {
                    officerId++;
                    allOfficers.add(o);
                    officers.add(o);
                    if (!maleKingCheckbox.isSelected() || o.getGender() == Officer.MALE) {
                        kingCandidates.add(o);
                    }
                } else {
                    j--;
                    if (useScenOfficerCheckbox.isSelected()){
                        officerId++;
                    }
                }
            }
            if (kingCandidates.isEmpty()) {
                f.setKing(Utility.randomPick(officers));
            } else {
                f.setKing(randomKingRadio.isSelected() ? Utility.randomPick(kingCandidates)
                        : Collections.max(kingCandidates, new Comparator<Officer>() {

                    @Override
                    public int compare(Officer o1, Officer o2) {
                        return o1.getAbilitySum() - o2.getAbilitySum();
                    }
                }));
            }
            if (!f.populateOfficers(allBuildings, cityCnt, connectedFactionCityCheckbox.isSelected(),
                    officers, Integer.parseInt(loyaltyLoText.getText()), Integer.parseInt(loyaltyHiText.getText()),
                    strongOfficerLoyaltyCheckbox.isSelected())) {
                break;
            }
            //write it
            f.writeFaction(scenConn);
            factions.add(f);
        }
        Faction.writeFactionDiplomacy(scenConn, factions,
                Integer.parseInt(factionDiplomacyLoText.getText()), Integer.parseInt(factionDiplomacyHiText.getText()), gaussianDiplomacyCheckbox.isSelected());

        //generate unemployed officers
        int unemployedCnt = Utility.randBetween(Integer.parseInt(officerCntLoText.getText()), Integer.parseInt(officerCntHiText.getText()));
        for (int i = 0; i < unemployedCnt; ++i) {
            if (allOfficers.size() > MAX_OFFICER) {
                break;
            }
            allOfficers.add(generateOfficer(db, officerId, scenYear, allBuildings, false, false, commonDataConn));
            officerId++;
        }

        //generate children
        for (int i = 0; i < allOfficers.size(); ++i) {
            if (allOfficers.size() > MAX_OFFICER) {
                break;
            }
            if (allOfficers.get(i).getGeneration() >= Integer.parseInt(generationHiText.getText())) {
                continue;
            }
            if ((Utility.probTestPercentage(hasChildrenProbSlider.getValue()) || (allOfficers.get(i).isKing() && Utility.probTestPercentage(kingHasChildrenProbSlider.getValue())))
                    && allOfficers.get(i).getSpouse() == null) {
                Officer father = null, mother = null;
                if (allOfficers.get(i).getGender() == Officer.MALE) {
                    father = allOfficers.get(i);
                } else {
                    mother = allOfficers.get(i);
                }
                if (Utility.probTestPercentage(spouseProbSlider.getValue())) {
                    List<Officer> candidate = new ArrayList<Officer>();
                    for (Officer j : allOfficers) {
                        if (j.getGender() != allOfficers.get(i).getGender() && j.getTightBlood() != allOfficers.get(i).getTightBlood()
                                && j.getSpouse() == null && Math.abs(j.getBornYear() - allOfficers.get(i).getBornYear()) < 40) {
                            candidate.add(j);
                        }
                    }
                    if (candidate.isEmpty()) {
                        continue;
                    }
                    Officer pick = Utility.randomPick(candidate);
                    allOfficers.get(i).setSpouse(pick);
                    pick.setSpouse(allOfficers.get(i));
                    if (allOfficers.get(i).getGender() == Officer.MALE) {
                        mother = allOfficers.get(i).getSpouse();
                    } else {
                        father = allOfficers.get(i).getSpouse();
                    }
                }
                allOfficers.add(generateOfficer(db, officerId, scenYear, allBuildings, father, mother, parentAffectAbilityCheckbox.isSelected(), commonDataConn));
                officerId++;
                while (Utility.probTestPercentage(kingHasMoreChildrenProbSlider.getValue()) || (allOfficers.get(i).isKing() && Utility.probTestPercentage(kingHasChildrenProbSlider.getValue()))) {
                    allOfficers.add(generateOfficer(db, officerId, scenYear, allBuildings, father, mother, parentAffectAbilityCheckbox.isSelected(), commonDataConn));
                    officerId++;
                }
            }
        }
        
        //handle imitate/hate
        for (Officer o : allOfficers){
            o.randomImitateOfficers(allOfficers, imitateOfficerProbSlider.getValue());
            o.randomHateOfficers(allOfficers, hateOfficerProbSlider.getValue());
            o.imitateFamilyOfficers(allOfficers, spouseImitateProbSlider.getValue(), closeImitateProbSlider.getValue(),
                    bloodImitateProbSlider.getValue());
        }
        
        //generate Treasure
        int treasureCnt = Utility.randBetween(Integer.parseInt(treasureCntLoText.getText()), Integer.parseInt(treasureCntHiText.getText()));
        for (int i = 0; i < treasureCnt; ++i){
            Treasure t = new Treasure(Utility.randomCategorize_i(
                    Integer.parseInt(treasureWeaponProbText.getText()), Integer.parseInt(treasureBookProbText.getText()), Integer.parseInt(treasureHorseProbText.getText())));
            int mean = (Integer.parseInt(treasurePriceLoText.getText()) + Integer.parseInt(treasurePriceHiText.getText())) / 2;
            int var = mean - Integer.parseInt(treasurePriceLoText.getText());
            t.randomize(commonDataConn, (int)
                    (treasurePriceGaussianCheckbox.isSelected() ? Utility.randGaussian(mean, var) :
                    Utility.randBetween(Integer.parseInt(treasurePriceLoText.getText()), Integer.parseInt(treasurePriceHiText.getText())))
                    ,
                    Utility.randBetween(Integer.parseInt(treasureYearLoText.getText()), Integer.parseInt(treasureYearHiText.getText())), 
                    Double.parseDouble(treasurePriceRateText.getText()));
            t.place(treasureOwnedProbSlider.getValue(), scenYear, allOfficers, allBuildings);
            t.writeTreasure(scenConn);
        }
        
        //write generated common data
        Title.writeTitles(commonDataConn);

        //write officers
        for (Officer i : allOfficers) {
            i.writeOfficer(scenConn);
        }

        for (Building i : allBuildings) {
            if (i.isStrong()) {
                i.randomCash(Integer.parseInt(strongFactionCashLoText.getText()), Integer.parseInt(strongFactionCashHiText.getText()));
                i.randomCrop(Integer.parseInt(strongFactionCropLoText.getText()), Integer.parseInt(strongFactionCropHiText.getText()));
                i.randomPopulation(Integer.parseInt(strongFactionPopulationLoText.getText()), Integer.parseInt(strongFactionPopulationHiText.getText()));
                i.randomArmy(Integer.parseInt(strongFactionTroopCntLoText.getText()), Integer.parseInt(strongFactionTroopCntHiText.getText()),
                        Integer.parseInt(strongFactionTroopLoText.getText()), Integer.parseInt(strongFactionTroopHiText.getText()),
                        Integer.parseInt(troopMoraleLoText.getText()), Integer.parseInt(troopMoraleHiText.getText()),
                        Integer.parseInt(troopExpLoText.getText()), Integer.parseInt(troopExpHiText.getText()));
            } else {
                i.randomCash(Integer.parseInt(cashLoText.getText()), Integer.parseInt(cashHiText.getText()));
                i.randomCrop(Integer.parseInt(cropLoText.getText()), Integer.parseInt(cropHiText.getText()));
                i.randomPopulation(Integer.parseInt(populationLoText.getText()), Integer.parseInt(populationHiText.getText()));
                i.randomArmy(Integer.parseInt(troopCntLoText.getText()), Integer.parseInt(troopCntHiText.getText()),
                        Integer.parseInt(troopLoText.getText()), Integer.parseInt(troopHiText.getText()),
                        Integer.parseInt(troopMoraleLoText.getText()), Integer.parseInt(troopMoraleHiText.getText()),
                        Integer.parseInt(troopExpLoText.getText()), Integer.parseInt(troopExpHiText.getText()));
            }
            i.randomInternal(Integer.parseInt(agricultureLoText.getText()), Integer.parseInt(agricultureHiText.getText()),
                    Integer.parseInt(commerceLoText.getText()), Integer.parseInt(commerceHiText.getText()),
                    Integer.parseInt(technologyLoText.getText()), Integer.parseInt(technologyHiText.getText()),
                    Integer.parseInt(dominationLoText.getText()), Integer.parseInt(dominationHiText.getText()),
                    Integer.parseInt(moraleLoText.getText()), Integer.parseInt(moraleHiText.getText()),
                    Integer.parseInt(enduranceLoText.getText()), Integer.parseInt(enduranceHiText.getText()));
            i.randomFacility(commonDataConn);
            i.randomSpecialties(commonDataConn, citySpecialtyProbSlider.getValue(), Integer.parseInt(citySpecialtyThresholdText.getText()));
        }

        //put in emperor
        List<Building> b = new ArrayList<Building>();
        for (Building i : allBuildings) {
            if (i.getSize() >= Integer.parseInt(emperorLeastCitySizeText.getText())) {
                b.add(i);
            }
        }
        if (b.size() > 0) {
            Utility.randomPick(b).setEmperorToHere();
        } else {
            Utility.randomPick(allBuildings).setEmperorToHere();
        }

        if (createMap){
            Building.prepareBuildingForCreatedMap(scenConn);
            map.writeMap(scenConn);
        }
        for (Building i : allBuildings) {
            i.writeBuilding(scenConn, createMap);
        }

        //last but not least, write description
        PreparedStatement pstmt = null;
        try {
            pstmt = scenConn.prepareStatement("update GameSurvey set Description = ?, GMonth = ?, GDay = ?");
            pstmt.setString(1, "由" + APP_NAME + "生成的劇本");
            pstmt.setInt(2, 1);
            pstmt.setInt(3, 1);
            pstmt.executeUpdate();
        } finally {
            pstmt.close();
        }

    }

    private void openFileButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_openFileButtonMouseClicked
        Connection scenConn = null;
        Connection commonDataConn = null;
        tc = langCombo.getSelectedIndex() == 0;
        try {
            Utility.copyFile("ScenGenTemplate.mdb", gamePath + "/GameData/Scenario/generatedScen.mdb");
            try {
                Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
                java.util.Properties prop = new java.util.Properties();
                prop.put("charSet", tc ? "Big5" : "GBK");
                scenConn = DriverManager.getConnection("jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)};DBQ=" + gamePath + "/GameData/Scenario/generatedScen.mdb", prop);
                commonDataConn = DriverManager.getConnection("jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)};DBQ=" + gamePath + "/GameData/Common/CommonData.mdb", prop);
            } catch (SQLException ex) {
                JOptionPane.showMessageDialog(this, "修改檔案途中出現問題：" + ex.getMessage(), APP_NAME, JOptionPane.ERROR_MESSAGE);
                ex.printStackTrace();
                return;
            } catch (ClassNotFoundException ex) {
                System.err.println("JDBC driver failed!");
                ex.printStackTrace();
                System.exit(1);
            }
            try {
                randomize(scenConn, commonDataConn);
                JOptionPane.showMessageDialog(this, "劇本生成成功！", APP_NAME, JOptionPane.INFORMATION_MESSAGE);
            } catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this, "輸入錯誤：" + ex.getMessage(), APP_NAME, JOptionPane.ERROR_MESSAGE);
                ex.printStackTrace();
                return;
            } catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "修改檔案途中出現問題：" + ex.getMessage(), APP_NAME, JOptionPane.ERROR_MESSAGE);
                ex.printStackTrace();
                return;
            }
        } catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "修改檔案途中出現問題：" + ex.getMessage(), APP_NAME, JOptionPane.ERROR_MESSAGE);
            ex.printStackTrace();
            return;
        } finally {
            try {
                scenConn.close();
                commonDataConn.close();
            } catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }//GEN-LAST:event_openFileButtonMouseClicked

    private void saveSetting(File file) throws Exception {
        String pathname = file.getCanonicalPath();
        if (!pathname.endsWith(SETTING_FILE_EXTENSION)) {
            pathname += "." + SETTING_FILE_EXTENSION;
        }
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(pathname), "UTF-8"));
        Field[] fields = Frontend.class.getDeclaredFields();
        for (Field f : fields) {
            if (Modifier.isFinal(f.getModifiers())) {
                continue; //do not write final fields - it won't be read
            }
            Object swingObj = f.get(this);
            if (swingObj instanceof javax.swing.JTextField) {
                w.write(f.getName() + " " + ((javax.swing.JTextField) swingObj).getText());
                w.newLine();
            } else if (swingObj instanceof javax.swing.JSlider) {
                w.write(f.getName() + " " + String.valueOf(((javax.swing.JSlider) swingObj).getValue()));
                w.newLine();
            } else if (swingObj instanceof javax.swing.JToggleButton) { //includes checkbox/radio
                w.write(f.getName() + " " + (((javax.swing.JToggleButton) swingObj).isSelected() ? "1" : "0"));
                w.newLine();
            } else if (swingObj instanceof javax.swing.JComboBox) {
                w.write(f.getName() + " " + String.valueOf(((javax.swing.JComboBox) swingObj).getSelectedIndex()));
                w.newLine();
            } else if (swingObj instanceof javax.swing.JTable){
                w.write(f.getName() + " ");
                javax.swing.JTable t = (javax.swing.JTable) swingObj;
                for (int i = 0; i < t.getRowCount(); ++i){
                    for (int j = 0; j < t.getColumnCount(); ++j){
                        w.write(t.getModel().getValueAt(i, j).toString() + " ");
                    }
                }
                w.newLine();
            }
        }
        w.close();
    }

    private void exportSettingButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_exportSettingButtonMouseClicked
        int answer = settingFileChooser.showOpenDialog(this);
        if (answer == JFileChooser.APPROVE_OPTION) {
            File file = settingFileChooser.getSelectedFile();
            try {
                saveSetting(file);
            } catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "儲存檔案途中出現問題：" + ex.getMessage(), APP_NAME, JOptionPane.ERROR_MESSAGE);
                ex.printStackTrace();
            }
        }
    }//GEN-LAST:event_exportSettingButtonMouseClicked

    private void loadSetting(File file) throws Exception {
        BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(file), "UTF-8"));
        Map<String, String> fieldValue = new HashMap<String, String>();
        String line;
        while ((line = r.readLine()) != null) {
            String[] temp = line.split(" ", 2);
            fieldValue.put(temp[0], temp[1]);
        }
        Field[] fields = Frontend.class.getDeclaredFields();
        for (Field f : fields) {
            if (Modifier.isFinal(f.getModifiers())) {
                continue; //do not attempt to write to final fields
            }
            String value = fieldValue.get(f.getName());
            if (value != null) {
                Object swingObj = f.get(this);
                if (swingObj instanceof javax.swing.JTextField) {
                    ((javax.swing.JTextField) swingObj).setText(value);
                } else if (swingObj instanceof javax.swing.JSlider) {
                    ((javax.swing.JSlider) swingObj).setValue(Integer.parseInt(value));
                } else if (swingObj instanceof javax.swing.JToggleButton) { //includes checkbox/radio
                    ((javax.swing.JToggleButton) swingObj).setSelected(value.equals("1") ? true : false);
                } else if (swingObj instanceof javax.swing.JComboBox) {
                    ((javax.swing.JComboBox) swingObj).setSelectedIndex(Integer.parseInt(value));
                } else if (swingObj instanceof javax.swing.JTable){
                    String[] s = value.split(" ");
                    javax.swing.JTable t = (javax.swing.JTable) swingObj;
                    for (int i = 0, k = 0; i < t.getRowCount(); ++i){
                        for (int j = 0; j < t.getColumnCount(); ++j, ++k){
                            t.getModel().setValueAt(s[k], i, j);
                        }
                    }
                }
            }
        }
        r.close();
    }

    private void importSettingButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_importSettingButtonMouseClicked
        int answer = settingFileChooser.showOpenDialog(this);
        if (answer == JFileChooser.APPROVE_OPTION) {
            File file = settingFileChooser.getSelectedFile();
            try {
                loadSetting(file);
            } catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "讀取檔案途中出現問題：" + ex.getMessage(), APP_NAME, JOptionPane.ERROR_MESSAGE);
                ex.printStackTrace();
            }
        }
    }//GEN-LAST:event_importSettingButtonMouseClicked

    private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter("CSSG.ini"));
            bw.write(gamePath);
            bw.newLine();
            bw.close();
            saveSetting(new File("last.ORSET"));
        } catch (Exception ex) {
        }
        this.dispose();
    }//GEN-LAST:event_formWindowClosing

    private void changeGamePathButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_changeGamePathButtonMouseClicked
        gamePathChooser.showOpenDialog(null);
        if (gamePathChooser.getSelectedFile() != null) {
            gamePath = gamePathChooser.getSelectedFile().getAbsolutePath();
        }
    }//GEN-LAST:event_changeGamePathButtonMouseClicked

    private void hasMoreChildrenProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_hasMoreChildrenProbSliderStateChanged
        hasMoreChildrenProbLabel.setText(hasMoreChildrenProbSlider.getValue() + "%");
}//GEN-LAST:event_hasMoreChildrenProbSliderStateChanged

    private void kingHasChildrenProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_kingHasChildrenProbSliderStateChanged
        kingHasChildrenProbLabel.setText(kingHasChildrenProbSlider.getValue() + "%");
}//GEN-LAST:event_kingHasChildrenProbSliderStateChanged

    private void spouseProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_spouseProbSliderStateChanged
        spouseProbLabel.setText(spouseProbSlider.getValue() + "%");
}//GEN-LAST:event_spouseProbSliderStateChanged

    private void kingHasMoreChildrenProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_kingHasMoreChildrenProbSliderStateChanged
        kingHasMoreChildrenProbLabel.setText(kingHasMoreChildrenProbSlider.getValue() + "%");
}//GEN-LAST:event_kingHasMoreChildrenProbSliderStateChanged

    private void hasChildrenProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_hasChildrenProbSliderStateChanged
        hasChildrenProbLabel.setText(hasChildrenProbSlider.getValue() + "%");
}//GEN-LAST:event_hasChildrenProbSliderStateChanged

    private void moreCityFactionProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_moreCityFactionProbSliderStateChanged
        moreCityFactionProbLabel.setText(moreCityFactionProbSlider.getValue() + "%");
}//GEN-LAST:event_moreCityFactionProbSliderStateChanged

    private void noSpecialProb1Slider9StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_noSpecialProb1Slider9StateChanged
        noSpecialProb1Label8.setText(noSpecialProb1Slider9.getValue() + "%");
}//GEN-LAST:event_noSpecialProb1Slider9StateChanged

    private void noSpecialProb1Slider8StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_noSpecialProb1Slider8StateChanged
        noSpecialProb1Label7.setText(noSpecialProb1Slider8.getValue() + "%");
}//GEN-LAST:event_noSpecialProb1Slider8StateChanged

    private void noSpecialProb1Slider7StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_noSpecialProb1Slider7StateChanged
        noSpecialProb1Label6.setText(noSpecialProb1Slider7.getValue() + "%");
}//GEN-LAST:event_noSpecialProb1Slider7StateChanged

    private void noSpecialProb1Slider6StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_noSpecialProb1Slider6StateChanged
        noSpecialProb1Label5.setText(noSpecialProb1Slider6.getValue() + "%");
}//GEN-LAST:event_noSpecialProb1Slider6StateChanged

    private void noSpecialProb1Slider5StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_noSpecialProb1Slider5StateChanged
        noSpecialProb1Label4.setText(noSpecialProb1Slider5.getValue() + "%");
}//GEN-LAST:event_noSpecialProb1Slider5StateChanged

    private void noSpecialProb1Slider4StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_noSpecialProb1Slider4StateChanged
        noSpecialProb1Label3.setText(noSpecialProb1Slider4.getValue() + "%");
}//GEN-LAST:event_noSpecialProb1Slider4StateChanged

    private void noSpecialProb1Slider3StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_noSpecialProb1Slider3StateChanged
        noSpecialProb1Label2.setText(noSpecialProb1Slider3.getValue() + "%");
}//GEN-LAST:event_noSpecialProb1Slider3StateChanged

    private void noSpecialProb1Slider2StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_noSpecialProb1Slider2StateChanged
        noSpecialProb1Label1.setText(noSpecialProb1Slider2.getValue() + "%");
}//GEN-LAST:event_noSpecialProb1Slider2StateChanged

    private void noSpecialProb1Slider1StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_noSpecialProb1Slider1StateChanged
        noSpecialProb1Label.setText(noSpecialProb1Slider1.getValue() + "%");
}//GEN-LAST:event_noSpecialProb1Slider1StateChanged

    private void doubleNameProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_doubleNameProbSliderStateChanged
        doubleNameProbLabel.setText(doubleNameProbSlider.getValue() + "%");
}//GEN-LAST:event_doubleNameProbSliderStateChanged

    private void femaleOfficerProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_femaleOfficerProbSliderStateChanged
        femaleOfficerProbLabel.setText(femaleOfficerProbSlider.getValue() + "%");
}//GEN-LAST:event_femaleOfficerProbSliderStateChanged

    private void factionTechniqueProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_factionTechniqueProbSliderStateChanged
        factionTechniqueProbLabel.setText(factionTechniqueProbSlider.getValue() + "%");
    }//GEN-LAST:event_factionTechniqueProbSliderStateChanged

    private void strongFactionMoreCityProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_strongFactionMoreCityProbSliderStateChanged
        strongFactionMoreCityProbLabel.setText(strongFactionMoreCityProbSlider.getValue() + "%");
    }//GEN-LAST:event_strongFactionMoreCityProbSliderStateChanged

    private void strongFactionTechniqueProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_strongFactionTechniqueProbSliderStateChanged
        strongFactionTechniqueProbLabel.setText(strongFactionTechniqueProbSlider.getValue() + "%");
    }//GEN-LAST:event_strongFactionTechniqueProbSliderStateChanged

    private void strongOfficerProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_strongOfficerProbSliderStateChanged
        strongOfficerProbLabel.setText(strongOfficerProbSlider.getValue() + "%");
    }//GEN-LAST:event_strongOfficerProbSliderStateChanged

    private void treasureOwnedProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_treasureOwnedProbSliderStateChanged
        treasureOwnedProbLabel.setText(treasureOwnedProbSlider.getValue() + "%");
    }//GEN-LAST:event_treasureOwnedProbSliderStateChanged

    private void citySpecialtyProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_citySpecialtyProbSliderStateChanged
        citySpecialtyProbLabel.setText(citySpecialtyProbSlider.getValue() + "%");
    }//GEN-LAST:event_citySpecialtyProbSliderStateChanged

    private void factionSpecialTroopSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_factionSpecialTroopSliderStateChanged
        factionSpecialTroopLabel.setText(factionSpecialTroopSlider.getValue() + "%");
    }//GEN-LAST:event_factionSpecialTroopSliderStateChanged

    private void strongFactionSpecialTroopSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_strongFactionSpecialTroopSliderStateChanged
        strongFactionSpecialTroopLabel.setText(strongFactionSpecialTroopSlider.getValue() + "%");
    }//GEN-LAST:event_strongFactionSpecialTroopSliderStateChanged

    private void generatedTitleProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_generatedTitleProbSliderStateChanged
        generatedTitleProbLabel.setText(generatedTitleProbSlider.getValue() + "%");
    }//GEN-LAST:event_generatedTitleProbSliderStateChanged

    private void hateOfficerProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_hateOfficerProbSliderStateChanged
        hateOfficerProbLabel.setText(hateOfficerProbSlider.getValue() + "%");
    }//GEN-LAST:event_hateOfficerProbSliderStateChanged

    private void spouseImitateProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_spouseImitateProbSliderStateChanged
        spouseImitateProbLabel.setText(spouseImitateProbSlider.getValue() + "%");
    }//GEN-LAST:event_spouseImitateProbSliderStateChanged

    private void closeImitateProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_closeImitateProbSliderStateChanged
        closeImitateProbLabel.setText(closeImitateProbSlider.getValue() + "%");
    }//GEN-LAST:event_closeImitateProbSliderStateChanged

    private void imitateOfficerProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_imitateOfficerProbSliderStateChanged
        imitateOfficerProbLabel.setText(imitateOfficerProbSlider.getValue() + "%");
    }//GEN-LAST:event_imitateOfficerProbSliderStateChanged

    private void bloodImitateProbSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_bloodImitateProbSliderStateChanged
        bloodImitateProbLabel.setText(bloodImitateProbSlider.getValue() + "%");
    }//GEN-LAST:event_bloodImitateProbSliderStateChanged

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        } catch (InstantiationException ex) {
            ex.printStackTrace();
        } catch (IllegalAccessException ex) {
            ex.printStackTrace();
        } catch (UnsupportedLookAndFeelException ex) {
            ex.printStackTrace();
        }
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                new Frontend().setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField abilityAbsText;
    private javax.swing.JTextField abilityHiText;
    private javax.swing.JTextField abilityLoText;
    private javax.swing.JTextField abilityMulText;
    private javax.swing.JTextField advisorTypeWeightText;
    private javax.swing.JTextField agricultureHiText;
    private javax.swing.JTextField agricultureLoText;
    private javax.swing.JTextField allRounderTypeWeightText;
    private javax.swing.JTextField attachmentHiText;
    private javax.swing.JTextField attachmentLoText;
    private javax.swing.JRadioButton bestKingRadio;
    private javax.swing.ButtonGroup bloodGroup;
    private javax.swing.ButtonGroup bloodImitateGroup;
    private javax.swing.JLabel bloodImitateProbLabel;
    private javax.swing.JSlider bloodImitateProbSlider;
    private javax.swing.JTextField bornYearHiText;
    private javax.swing.JTextField bornYearLoText;
    private javax.swing.ButtonGroup brotherGroup;
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JLabel bwrb;
    private javax.swing.JTextField cashHiText;
    private javax.swing.JTextField cashLoText;
    private javax.swing.JButton changeGamePathButton;
    private javax.swing.JTextField cheapTypeWeightText;
    private javax.swing.JTextField childrenAbilityBaseText;
    private javax.swing.JTextField childrenAbilityVarText;
    private javax.swing.JTextField childrenAttachmentText;
    private javax.swing.JTextField childrenBattleTitleText;
    private javax.swing.JTextField childrenLoyaltyHiText;
    private javax.swing.JTextField childrenLoyaltyLoText;
    private javax.swing.JTextField childrenParentYearHiText;
    private javax.swing.JTextField childrenParentYearLoText;
    private javax.swing.JTextField childrenPersonalTitleText;
    private javax.swing.JTextField childrenPopularityHiText;
    private javax.swing.JTextField childrenPopularityLoText;
    private javax.swing.JTextField childrenSkillBaseText;
    private javax.swing.JTextField childrenSkillVarText;
    private javax.swing.JTextField childrenStuntBaseText;
    private javax.swing.JTextField childrenStuntVarText;
    private javax.swing.JLabel citySpecialtyProbLabel;
    private javax.swing.JSlider citySpecialtyProbSlider;
    private javax.swing.JTextField citySpecialtyThresholdText;
    private javax.swing.JLabel closeImitateProbLabel;
    private javax.swing.JSlider closeImitateProbSlider;
    private javax.swing.JTextField commerceHiText;
    private javax.swing.JTextField commerceLoText;
    private javax.swing.JCheckBox connectedFactionCityCheckbox;
    private javax.swing.JCheckBox createMapCheckbox;
    private javax.swing.JTextField cropHiText;
    private javax.swing.JTextField cropLoText;
    private javax.swing.JTextField deadYearHiText;
    private javax.swing.JTextField deadYearLoText;
    private javax.swing.JTextField debutYearHiText;
    private javax.swing.JTextField debutYearLoText;
    private javax.swing.JTextField dominationHiText;
    private javax.swing.JTextField dominationLoText;
    private javax.swing.JLabel doubleNameProbLabel;
    private javax.swing.JSlider doubleNameProbSlider;
    private javax.swing.JTextField emperorLeastCitySizeText;
    private javax.swing.JTextField emperorTypeWeightText;
    private javax.swing.JTextField enduranceHiText;
    private javax.swing.JTextField enduranceLoText;
    private javax.swing.JButton exportSettingButton;
    private javax.swing.ButtonGroup faceRadioGroup;
    private javax.swing.JTextField factionCntHiText;
    private javax.swing.JTextField factionCntLoText;
    private javax.swing.JTextField factionDiplomacyHiText;
    private javax.swing.JTextField factionDiplomacyLoText;
    private javax.swing.ButtonGroup factionKingGroup;
    private javax.swing.JTextField factionOfficerHiText;
    private javax.swing.JTextField factionOfficerLoText;
    private javax.swing.JLabel factionSpecialTroopLabel;
    private javax.swing.JSlider factionSpecialTroopSlider;
    private javax.swing.ButtonGroup factionTechniqueButtonGroup;
    private javax.swing.JLabel factionTechniqueProbLabel;
    private javax.swing.JSlider factionTechniqueProbSlider;
    private javax.swing.JLabel femaleOfficerProbLabel;
    private javax.swing.JSlider femaleOfficerProbSlider;
    private javax.swing.JLabel filePathLabel;
    private javax.swing.JCheckBox gaussianDiplomacyCheckbox;
    private javax.swing.JRadioButton genderFaceRadio;
    private javax.swing.JTextField generalTypeWeightText;
    private javax.swing.JTextField generatedTitleLevelHiText;
    private javax.swing.JTextField generatedTitleLevelLoText;
    private javax.swing.JLabel generatedTitleProbLabel;
    private javax.swing.JSlider generatedTitleProbSlider;
    private javax.swing.JTextField generationHiText;
    private javax.swing.JLabel hasChildrenProbLabel;
    private javax.swing.JSlider hasChildrenProbSlider;
    private javax.swing.JLabel hasMoreChildrenProbLabel;
    private javax.swing.JSlider hasMoreChildrenProbSlider;
    private javax.swing.ButtonGroup hateGroup;
    private javax.swing.JLabel hateOfficerProbLabel;
    private javax.swing.JSlider hateOfficerProbSlider;
    private javax.swing.ButtonGroup imitateGroup;
    private javax.swing.JLabel imitateOfficerProbLabel;
    private javax.swing.JSlider imitateOfficerProbSlider;
    private javax.swing.JButton importSettingButton;
    private javax.swing.JTextField intelGeneralTypeWeightText;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel100;
    private javax.swing.JLabel jLabel101;
    private javax.swing.JLabel jLabel102;
    private javax.swing.JLabel jLabel103;
    private javax.swing.JLabel jLabel104;
    private javax.swing.JLabel jLabel105;
    private javax.swing.JLabel jLabel106;
    private javax.swing.JLabel jLabel107;
    private javax.swing.JLabel jLabel108;
    private javax.swing.JLabel jLabel109;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel110;
    private javax.swing.JLabel jLabel111;
    private javax.swing.JLabel jLabel112;
    private javax.swing.JLabel jLabel113;
    private javax.swing.JLabel jLabel114;
    private javax.swing.JLabel jLabel115;
    private javax.swing.JLabel jLabel116;
    private javax.swing.JLabel jLabel117;
    private javax.swing.JLabel jLabel118;
    private javax.swing.JLabel jLabel119;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel120;
    private javax.swing.JLabel jLabel121;
    private javax.swing.JLabel jLabel122;
    private javax.swing.JLabel jLabel123;
    private javax.swing.JLabel jLabel124;
    private javax.swing.JLabel jLabel125;
    private javax.swing.JLabel jLabel126;
    private javax.swing.JLabel jLabel127;
    private javax.swing.JLabel jLabel128;
    private javax.swing.JLabel jLabel129;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel130;
    private javax.swing.JLabel jLabel131;
    private javax.swing.JLabel jLabel132;
    private javax.swing.JLabel jLabel133;
    private javax.swing.JLabel jLabel134;
    private javax.swing.JLabel jLabel135;
    private javax.swing.JLabel jLabel136;
    private javax.swing.JLabel jLabel137;
    private javax.swing.JLabel jLabel138;
    private javax.swing.JLabel jLabel139;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel140;
    private javax.swing.JLabel jLabel141;
    private javax.swing.JLabel jLabel142;
    private javax.swing.JLabel jLabel143;
    private javax.swing.JLabel jLabel144;
    private javax.swing.JLabel jLabel145;
    private javax.swing.JLabel jLabel146;
    private javax.swing.JLabel jLabel147;
    private javax.swing.JLabel jLabel148;
    private javax.swing.JLabel jLabel149;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel150;
    private javax.swing.JLabel jLabel151;
    private javax.swing.JLabel jLabel152;
    private javax.swing.JLabel jLabel153;
    private javax.swing.JLabel jLabel154;
    private javax.swing.JLabel jLabel155;
    private javax.swing.JLabel jLabel156;
    private javax.swing.JLabel jLabel157;
    private javax.swing.JLabel jLabel158;
    private javax.swing.JLabel jLabel159;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel160;
    private javax.swing.JLabel jLabel161;
    private javax.swing.JLabel jLabel162;
    private javax.swing.JLabel jLabel163;
    private javax.swing.JLabel jLabel164;
    private javax.swing.JLabel jLabel165;
    private javax.swing.JLabel jLabel166;
    private javax.swing.JLabel jLabel167;
    private javax.swing.JLabel jLabel168;
    private javax.swing.JLabel jLabel169;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JLabel jLabel170;
    private javax.swing.JLabel jLabel171;
    private javax.swing.JLabel jLabel172;
    private javax.swing.JLabel jLabel173;
    private javax.swing.JLabel jLabel174;
    private javax.swing.JLabel jLabel175;
    private javax.swing.JLabel jLabel176;
    private javax.swing.JLabel jLabel177;
    private javax.swing.JLabel jLabel18;
    private javax.swing.JLabel jLabel19;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel20;
    private javax.swing.JLabel jLabel21;
    private javax.swing.JLabel jLabel22;
    private javax.swing.JLabel jLabel23;
    private javax.swing.JLabel jLabel24;
    private javax.swing.JLabel jLabel25;
    private javax.swing.JLabel jLabel26;
    private javax.swing.JLabel jLabel27;
    private javax.swing.JLabel jLabel28;
    private javax.swing.JLabel jLabel29;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel30;
    private javax.swing.JLabel jLabel31;
    private javax.swing.JLabel jLabel32;
    private javax.swing.JLabel jLabel33;
    private javax.swing.JLabel jLabel34;
    private javax.swing.JLabel jLabel35;
    private javax.swing.JLabel jLabel36;
    private javax.swing.JLabel jLabel37;
    private javax.swing.JLabel jLabel38;
    private javax.swing.JLabel jLabel39;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel40;
    private javax.swing.JLabel jLabel41;
    private javax.swing.JLabel jLabel42;
    private javax.swing.JLabel jLabel43;
    private javax.swing.JLabel jLabel44;
    private javax.swing.JLabel jLabel45;
    private javax.swing.JLabel jLabel46;
    private javax.swing.JLabel jLabel47;
    private javax.swing.JLabel jLabel48;
    private javax.swing.JLabel jLabel49;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel50;
    private javax.swing.JLabel jLabel51;
    private javax.swing.JLabel jLabel52;
    private javax.swing.JLabel jLabel53;
    private javax.swing.JLabel jLabel54;
    private javax.swing.JLabel jLabel55;
    private javax.swing.JLabel jLabel56;
    private javax.swing.JLabel jLabel57;
    private javax.swing.JLabel jLabel58;
    private javax.swing.JLabel jLabel59;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel60;
    private javax.swing.JLabel jLabel61;
    private javax.swing.JLabel jLabel62;
    private javax.swing.JLabel jLabel63;
    private javax.swing.JLabel jLabel64;
    private javax.swing.JLabel jLabel65;
    private javax.swing.JLabel jLabel66;
    private javax.swing.JLabel jLabel67;
    private javax.swing.JLabel jLabel68;
    private javax.swing.JLabel jLabel69;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel70;
    private javax.swing.JLabel jLabel71;
    private javax.swing.JLabel jLabel72;
    private javax.swing.JLabel jLabel73;
    private javax.swing.JLabel jLabel74;
    private javax.swing.JLabel jLabel75;
    private javax.swing.JLabel jLabel76;
    private javax.swing.JLabel jLabel77;
    private javax.swing.JLabel jLabel78;
    private javax.swing.JLabel jLabel79;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel80;
    private javax.swing.JLabel jLabel81;
    private javax.swing.JLabel jLabel82;
    private javax.swing.JLabel jLabel83;
    private javax.swing.JLabel jLabel84;
    private javax.swing.JLabel jLabel85;
    private javax.swing.JLabel jLabel86;
    private javax.swing.JLabel jLabel87;
    private javax.swing.JLabel jLabel88;
    private javax.swing.JLabel jLabel89;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JLabel jLabel90;
    private javax.swing.JLabel jLabel91;
    private javax.swing.JLabel jLabel92;
    private javax.swing.JLabel jLabel93;
    private javax.swing.JLabel jLabel94;
    private javax.swing.JLabel jLabel95;
    private javax.swing.JLabel jLabel96;
    private javax.swing.JLabel jLabel97;
    private javax.swing.JLabel jLabel98;
    private javax.swing.JLabel jLabel99;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel10;
    private javax.swing.JPanel jPanel11;
    private javax.swing.JPanel jPanel12;
    private javax.swing.JPanel jPanel13;
    private javax.swing.JPanel jPanel14;
    private javax.swing.JPanel jPanel15;
    private javax.swing.JPanel jPanel16;
    private javax.swing.JPanel jPanel17;
    private javax.swing.JPanel jPanel18;
    private javax.swing.JPanel jPanel19;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel20;
    private javax.swing.JPanel jPanel21;
    private javax.swing.JPanel jPanel22;
    private javax.swing.JPanel jPanel23;
    private javax.swing.JPanel jPanel24;
    private javax.swing.JPanel jPanel25;
    private javax.swing.JPanel jPanel26;
    private javax.swing.JPanel jPanel27;
    private javax.swing.JPanel jPanel28;
    private javax.swing.JPanel jPanel29;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel30;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanel7;
    private javax.swing.JPanel jPanel8;
    private javax.swing.JPanel jPanel9;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JLabel kingHasChildrenProbLabel;
    private javax.swing.JSlider kingHasChildrenProbSlider;
    private javax.swing.JLabel kingHasMoreChildrenProbLabel;
    private javax.swing.JSlider kingHasMoreChildrenProbSlider;
    private javax.swing.JComboBox langCombo;
    private javax.swing.JTextField leaderPossibilityFactorText;
    private javax.swing.JTextField loyaltyHiText;
    private javax.swing.JTextField loyaltyLoText;
    private javax.swing.JCheckBox maleKingCheckbox;
    private javax.swing.JTextField mapCityCntHiText;
    private javax.swing.JTextField mapCityCntLoText;
    private javax.swing.JTextField mapCitySizeHiText;
    private javax.swing.JTextField mapCitySizeLoText;
    private javax.swing.JTextField mapHarbourCntHiText;
    private javax.swing.JTextField mapHarbourCntLoText;
    private javax.swing.JTextField mapSizeXText;
    private javax.swing.JTextField mapSizeYText;
    private javax.swing.JComboBox mapStartTerrainCombo;
    private javax.swing.JTextField mightyTypeWeightText;
    private javax.swing.JTextField moraleHiText;
    private javax.swing.JTextField moraleLoText;
    private javax.swing.JLabel moreCityFactionProbLabel;
    private javax.swing.JSlider moreCityFactionProbSlider;
    private javax.swing.JLabel noSpecialProb1Label;
    private javax.swing.JLabel noSpecialProb1Label1;
    private javax.swing.JLabel noSpecialProb1Label2;
    private javax.swing.JLabel noSpecialProb1Label3;
    private javax.swing.JLabel noSpecialProb1Label4;
    private javax.swing.JLabel noSpecialProb1Label5;
    private javax.swing.JLabel noSpecialProb1Label6;
    private javax.swing.JLabel noSpecialProb1Label7;
    private javax.swing.JLabel noSpecialProb1Label8;
    private javax.swing.JSlider noSpecialProb1Slider1;
    private javax.swing.JSlider noSpecialProb1Slider2;
    private javax.swing.JSlider noSpecialProb1Slider3;
    private javax.swing.JSlider noSpecialProb1Slider4;
    private javax.swing.JSlider noSpecialProb1Slider5;
    private javax.swing.JSlider noSpecialProb1Slider6;
    private javax.swing.JSlider noSpecialProb1Slider7;
    private javax.swing.JSlider noSpecialProb1Slider8;
    private javax.swing.JSlider noSpecialProb1Slider9;
    private javax.swing.JTextField normalTypeWeightText;
    private javax.swing.JTextField officerCntHiText;
    private javax.swing.JTextField officerCntLoText;
    private javax.swing.ButtonGroup officerGenerationTypeGroup;
    private javax.swing.JPanel officerTypePanel;
    private javax.swing.JButton openFileButton;
    private javax.swing.JCheckBox parentAffectAbilityCheckbox;
    private javax.swing.JTextField politicianTypeWeightText;
    private javax.swing.JTextField popularityHiText;
    private javax.swing.JTextField popularityLoText;
    private javax.swing.JTextField populationHiText;
    private javax.swing.JTextField populationLoText;
    private javax.swing.JRadioButton randomFaceRadio;
    private javax.swing.JRadioButton randomKingRadio;
    private javax.swing.JRadioButton randomTypeOfficerRadio;
    private javax.swing.ButtonGroup randomizeCountGroup;
    private javax.swing.ButtonGroup randomizeSpecialGroup;
    private javax.swing.JTextField reputationHiText;
    private javax.swing.JTextField reputationLoText;
    private javax.swing.JTextField scenYearHi;
    private javax.swing.JTextField scenYearLo;
    private javax.swing.ButtonGroup selectedRandomizeOfficerButtonGroup;
    private javax.swing.JTextField specialAbyProbText;
    private javax.swing.JTextField specialAbyThresholdText;
    private javax.swing.JTextField specialProbText;
    private javax.swing.JLabel spouseImitateProbLabel;
    private javax.swing.JSlider spouseImitateProbSlider;
    private javax.swing.JLabel spouseProbLabel;
    private javax.swing.JSlider spouseProbSlider;
    private javax.swing.JTextField strongFactionCashHiText;
    private javax.swing.JTextField strongFactionCashLoText;
    private javax.swing.JTextField strongFactionCropHiText;
    private javax.swing.JTextField strongFactionCropLoText;
    private javax.swing.JTextField strongFactionHiText;
    private javax.swing.JTextField strongFactionLoText;
    private javax.swing.JTextField strongFactionMinOfficerText;
    private javax.swing.JLabel strongFactionMoreCityProbLabel;
    private javax.swing.JSlider strongFactionMoreCityProbSlider;
    private javax.swing.JTextField strongFactionOfficerHiText;
    private javax.swing.JTextField strongFactionOfficerLoText;
    private javax.swing.JTextField strongFactionPopulationHiText;
    private javax.swing.JTextField strongFactionPopulationLoText;
    private javax.swing.JTextField strongFactionReputationHiText;
    private javax.swing.JTextField strongFactionReputationLoText;
    private javax.swing.JLabel strongFactionSpecialTroopLabel;
    private javax.swing.JSlider strongFactionSpecialTroopSlider;
    private javax.swing.JLabel strongFactionTechniqueProbLabel;
    private javax.swing.JSlider strongFactionTechniqueProbSlider;
    private javax.swing.JTextField strongFactionTroopCntHiText;
    private javax.swing.JTextField strongFactionTroopCntLoText;
    private javax.swing.JTextField strongFactionTroopHiText;
    private javax.swing.JTextField strongFactionTroopLoText;
    private javax.swing.JCheckBox strongKingAmbitionCheckbox;
    private javax.swing.JTextField strongOfficerAbilityAbsText;
    private javax.swing.JTextField strongOfficerAbilityMulText;
    private javax.swing.JCheckBox strongOfficerIdealTendencyCheckbox;
    private javax.swing.JCheckBox strongOfficerLoyaltyCheckbox;
    private javax.swing.JTextField strongOfficerPopularityHiText;
    private javax.swing.JTextField strongOfficerPopularityLoText;
    private javax.swing.JLabel strongOfficerProbLabel;
    private javax.swing.JSlider strongOfficerProbSlider;
    private javax.swing.JTextField strongOfficerSpecialProbText;
    private javax.swing.JTextField strongOfficerStuntProbText;
    private javax.swing.JTextField stuntAbyProbText;
    private javax.swing.JTextField stuntAbyThresholdText;
    private javax.swing.JTextField stuntProbText;
    private javax.swing.ButtonGroup teamGroup;
    private javax.swing.JTextField technologyHiText;
    private javax.swing.JTextField technologyLoText;
    private javax.swing.JTable terrainSettingTable;
    private javax.swing.JTextField treasureBookProbText;
    private javax.swing.JTextField treasureCntHiText;
    private javax.swing.JTextField treasureCntLoText;
    private javax.swing.JTextField treasureHorseProbText;
    private javax.swing.JLabel treasureOwnedProbLabel;
    private javax.swing.JSlider treasureOwnedProbSlider;
    private javax.swing.JCheckBox treasurePriceGaussianCheckbox;
    private javax.swing.JTextField treasurePriceHiText;
    private javax.swing.JTextField treasurePriceLoText;
    private javax.swing.JTextField treasurePriceRateText;
    private javax.swing.JTextField treasureWeaponProbText;
    private javax.swing.JTextField treasureYearHiText;
    private javax.swing.JTextField treasureYearLoText;
    private javax.swing.JTextField troopCntHiText;
    private javax.swing.JTextField troopCntLoText;
    private javax.swing.JTextField troopExpHiText;
    private javax.swing.JTextField troopExpLoText;
    private javax.swing.JTextField troopHiText;
    private javax.swing.JTextField troopLoText;
    private javax.swing.JTextField troopMoraleHiText;
    private javax.swing.JTextField troopMoraleLoText;
    private javax.swing.JRadioButton typedFaceRadio;
    private javax.swing.JRadioButton typedOfficerRadio;
    private javax.swing.JCheckBox useScenOfficerCheckbox;
    // End of variables declaration//GEN-END:variables
}
