/*
 * Decompiled with CFR 0.152.
 */
package CSanScenGenerator;

import CSanScenGenerator.Officer;
import CSanScenGenerator.Utility;
import CSanScenGenerator.frontend.Frontend;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class Army {
    protected int id = autoId++;
    protected int type;
    protected String name;
    protected int soldier;
    protected int morale;
    protected int combativity;
    protected int experience;
    protected Officer leader = null;
    protected Officer followedLeader = null;
    protected int leaderExperience;
    private static int autoId = 1;

    public void randomType(boolean water) {
        if (water && Utility.probTestPercentage(50.0)) {
            this.type = 30;
            this.name = Frontend.isTc() ? "\u8d70\u8238\u968a" : "\u8d70\u8238\u961f";
        } else {
            this.type = Utility.randBetween(0, 2);
            this.name = Frontend.isTc() ? (this.type == 0 ? "\u8f15\u6b65\u5175" : (this.type == 1 ? "\u8f15\u5f29\u5175" : "\u8f15\u9a0e\u5175")) + "\u968a" : (this.type == 0 ? "\u8f7b\u6b65\u5175" : (this.type == 1 ? "\u8f7b\u5f29\u5175" : "\u8f7b\u9a91\u5175")) + "\u961f";
        }
    }

    public void randomMorale(int moraleLo, int moraleHi) {
        this.morale = Utility.randBetween(moraleLo, moraleHi);
        this.combativity = Utility.randBetween(moraleLo, moraleHi);
    }

    public void randomLeader(Set<Officer> officers, int expLo, int expHi) {
        this.leader = Utility.randomPick(officers);
        this.experience = Utility.randBetween(expLo, expHi);
        this.leaderExperience = Utility.randBetween(expLo, expHi);
        if (this.leaderExperience >= 1000) {
            this.followedLeader = this.leader;
            this.leaderExperience = 0;
        }
    }

    public void randomSoldier(int lo, int hi) {
        this.soldier = Utility.randBetween(lo, hi) * 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeArmy(Connection conn) throws SQLException {
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("insert into Military (ID, Name, KindID, Quantity, Morale, Combativity, Experience, FollowedLeaderID, LeaderID, LeaderExperience) values (?, ?, ?, ?, ?, ?,  ?, ?, ?, ?)");
            pstmt.setInt(1, this.id);
            pstmt.setString(2, this.name);
            pstmt.setInt(3, this.type);
            pstmt.setInt(4, this.soldier);
            pstmt.setInt(5, this.morale);
            pstmt.setInt(6, this.combativity);
            pstmt.setInt(7, this.experience);
            pstmt.setInt(8, this.followedLeader == null ? -1 : this.followedLeader.id);
            pstmt.setInt(9, this.leader == null ? -1 : this.leader.id);
            pstmt.setInt(10, this.leaderExperience);
            pstmt.executeUpdate();
        }
        finally {
            pstmt.close();
        }
    }

    public static String toListStr(Collection<Army> t) {
        int[] r = new int[t.size()];
        Iterator<Army> it = t.iterator();
        int i = 0;
        while (it.hasNext()) {
            r[i++] = it.next().id;
        }
        return Utility.join(r, " ");
    }
}

