/*
 * Decompiled with CFR 0.152.
 */
package CSanScenGenerator;

import CSanScenGenerator.Army;
import CSanScenGenerator.Facility;
import CSanScenGenerator.FacilityKind;
import CSanScenGenerator.InfluenceRate;
import CSanScenGenerator.Officer;
import CSanScenGenerator.Point;
import CSanScenGenerator.Team;
import CSanScenGenerator.Utility;
import CSanScenGenerator.frontend.Frontend;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Building {
    public static final int TYPE_CITY = 1;
    public static final int TYPE_GATE = 2;
    public static final int TYPE_PORT = 3;
    public static final int TYPE_BASE = 4;
    protected int id;
    protected int type;
    protected Set<Point> location;
    protected Set<Officer> officers;
    protected Set<Officer> unemployedOfficers;
    protected Set<Army> armies;
    protected String name;
    protected int cash;
    protected int crop;
    protected int population;
    protected Team team;
    protected boolean emperor;
    protected int agriculture;
    protected int commerce;
    protected int technology;
    protected int domination;
    protected int morale;
    protected int endurance;
    protected Set<Facility> facilities;
    protected Set<Integer> specialties = new HashSet<Integer>();
    protected List<Integer> connectedLandCity;
    protected List<Integer> connectedWaterCity;
    private static int autoId = 1;
    private static List<String> nameList;
    private static Map<Integer, Double> facilityProb;

    private Building() {
        this.officers = new HashSet<Officer>();
        this.unemployedOfficers = new HashSet<Officer>();
        this.location = new HashSet<Point>();
        this.armies = new HashSet<Army>();
        this.facilities = new HashSet<Facility>();
    }

    public static Building createBuilding(int type) throws IOException {
        Building b = new Building();
        b.id = autoId++;
        if (nameList == null) {
            String s;
            nameList = new ArrayList<String>();
            BufferedReader f = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("DATA/" + (Frontend.isTc() ? "" : "GBK/") + "cityName.txt"), "UTF8"));
            while ((s = f.readLine()) != null) {
                nameList.add(s);
            }
        }
        b.name = "";
        int nameLen = 2;
        for (int i = 0; i < nameLen; ++i) {
            b.name = b.name + Utility.randomPick(nameList);
        }
        if (type == 2) {
            b.name = b.name + "\u95dc";
        } else if (type == 3) {
            b.name = b.name + "\u6e2f";
        }
        b.type = type;
        return b;
    }

    public int getSize() {
        return this.location.size();
    }

    public void setLocation(Collection<Point> p) {
        this.location = new HashSet<Point>(p);
    }

    public static Building getBuildingFromId(List<Building> b, int id) {
        for (Building i : b) {
            if (i.id != id) continue;
            return i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Building> readBuildings(Connection conn) throws SQLException {
        ArrayList<Building> r = new ArrayList<Building>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery("select * from Architecture");
            while (rs.next()) {
                int i;
                String landLink = rs.getString("AILandLinks");
                String waterLink = rs.getString("AIWaterLinks");
                String[] landLinkBase = landLink == null ? new String[]{} : landLink.split("\\s");
                String[] waterLinkBase = waterLink == null ? new String[]{} : waterLink.split("\\s");
                Building b = new Building();
                b.id = rs.getInt("ID");
                b.type = rs.getInt("Kind");
                b.name = rs.getString("Name");
                String location = rs.getString("Area");
                String[] s = location.split("\\s");
                for (i = 0; i < s.length; i += 2) {
                    Point p = new Point(Integer.parseInt(s[i]), Integer.parseInt(s[i + 1]));
                    b.location.add(p);
                }
                b.connectedLandCity = new ArrayList<Integer>();
                b.connectedWaterCity = new ArrayList<Integer>();
                for (i = 0; i < landLinkBase.length; ++i) {
                    try {
                        b.connectedLandCity.add(Integer.parseInt(landLinkBase[i]));
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                }
                for (i = 0; i < waterLinkBase.length; ++i) {
                    try {
                        b.connectedWaterCity.add(Integer.parseInt(waterLinkBase[i]));
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                }
                r.add(b);
            }
        }
        finally {
            rs.close();
            stmt.close();
        }
        return r;
    }

    public void populateOfficers(Team team, Officer officer, Officer king, int loyaltyLo, int loyaltyHi, boolean strongHiLoyalty) {
        officer.joinFaction(this, king, loyaltyLo, loyaltyHi, strongHiLoyalty);
        this.team = team;
    }

    public boolean isStrong() {
        return this.team != null && this.team.faction != null && this.team.faction.strong;
    }

    public void randomCash(int lo, int hi) {
        this.cash = this.team != null ? Utility.randBetween(lo, hi) * 100 : 0;
    }

    public void randomCrop(int lo, int hi) {
        this.crop = this.team != null ? Utility.randBetween(lo, hi) * 10000 : 0;
    }

    public void randomPopulation(int lo, int hi) {
        this.population = this.type == 1 ? Utility.randBetween(lo, hi) * this.getSize() * 1000 : (this.type == 3 ? Utility.randBetween(lo, hi) * this.getSize() * 500 : 0);
    }

    public void randomArmy(int cntLo, int cntHi, int troopLo, int troopHi, int mlo, int mhi, int elo, int ehi) {
        if (this.team != null) {
            int cnt = Utility.randBetween(cntLo, cntHi);
            for (int i = 0; i < cnt; ++i) {
                Army a = new Army();
                a.randomSoldier(troopLo, troopHi);
                a.randomType(this.type == 3);
                a.randomMorale(mlo, mhi);
                a.randomLeader(this.officers, elo, ehi);
                this.armies.add(a);
            }
        }
    }

    public void randomInternal(int alo, int ahi, int clo, int chi, int tlo, int thi, int dlo, int dhi, int mlo, int mhi, int elo, int ehi) {
        if (this.type == 1 || this.type == 3) {
            this.agriculture = Utility.randBetween(alo, ahi);
            this.commerce = Utility.randBetween(clo, chi);
            this.technology = Utility.randBetween(tlo, thi);
            this.domination = Utility.randBetween(dlo, dhi);
            this.morale = Utility.randBetween(mlo, mhi);
            this.endurance = Utility.randBetween(elo, ehi);
        } else if (this.type == 2) {
            this.morale = 0;
            this.commerce = 0;
            this.agriculture = 0;
            this.technology = Utility.randBetween(tlo, thi);
            this.domination = Utility.randBetween(dlo, dhi);
            this.endurance = Utility.randBetween(elo, ehi);
        } else {
            this.morale = 0;
            this.technology = 0;
            this.commerce = 0;
            this.agriculture = 0;
            this.domination = Utility.randBetween(dlo, dhi);
            this.endurance = Utility.randBetween(elo, ehi);
        }
    }

    private static void getFacilityProb() {
        facilityProb = new HashMap<Integer, Double>();
        BufferedReader file = null;
        try {
            file = new BufferedReader(new FileReader("DATA/facility.txt"));
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            return;
        }
        try {
            String s;
            while ((s = file.readLine()) != null) {
                String[] temps = s.split("\\s");
                int id = Integer.parseInt(temps[0]);
                double prob = Double.parseDouble(temps[1]);
                facilityProb.put(id, prob);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
    }

    public void randomFacility(Connection commonData) throws SQLException {
        if (this.type == 1) {
            int spaceOccupied = 0;
            if (facilityProb == null) {
                Building.getFacilityProb();
            }
            Map<Integer, FacilityKind> fk = FacilityKind.getFacilities(commonData);
            for (Map.Entry<Integer, Double> i : facilityProb.entrySet()) {
                if (!Utility.probTestPercentage(i.getValue()) || spaceOccupied + fk.get(i.getKey()).getOccupySpace() > 4 * this.getSize()) continue;
                Facility f = new Facility(fk.get(i.getKey()));
                this.facilities.add(f);
            }
        }
    }

    public void randomSpecialties(Connection cdData, double prob, int threshold) throws IOException, SQLException {
        double realProb = prob;
        int i = 0;
        if (this.type == 1) {
            while (Utility.probTestPercentage(realProb)) {
                Map<Integer, Integer> probMap = InfluenceRate.getBuildingRates(cdData);
                this.specialties.add(Utility.randomCategorize(probMap));
                if (++i < threshold) continue;
                realProb /= 2.0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepareBuildingForCreatedMap(Connection conn) throws SQLException {
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("delete from Region");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("insert into Region (ID, Name, States, RegionCore) values (?, ?, ?, ?)");
            pstmt.setInt(1, 1);
            pstmt.setString(2, "");
            pstmt.setString(3, "1");
            pstmt.setInt(4, -1);
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("delete from State");
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("insert into State (ID, Name, ContactStates, StateAdmin) values (?, ?, ?, ?)");
            pstmt.setInt(1, 1);
            pstmt.setString(2, "");
            pstmt.setString(3, "");
            pstmt.setInt(4, -1);
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("delete from Architecture");
            pstmt.executeUpdate();
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBuilding(Connection conn, boolean createdMap) throws SQLException {
        PreparedStatement pstmt = null;
        try {
            pstmt = !createdMap ? conn.prepareStatement("update Architecture set Persons = ?, NoFactionPersons = ?, Fund = ?, Food = ?, Population = ?, Militaries = ?,  Agriculture = ?, Commerce = ?, Technology = ?, Domination = ?, Morale = ?, Endurance = ?, Emperor = ?, Facilities = ?, Characteristics =?, Area = ?, AILandLinks = ?, AIWaterLinks = ?, Name = ?, Kind = ? where ID = ?") : conn.prepareStatement("insert into Architecture (Persons, NoFactionPersons, Fund, Food, Population, Militaries, Agriculture,Commerce, Technology, Domination, Morale, Endurance, Emperor, Facilities, Characteristics, Area, AILandLinks, AIWaterLinks,Name, Kind, ID, IsStrategicCenter, StateID, CaptionID) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, false, 1, 9999)");
            pstmt.setString(1, Officer.toListStr(this.officers));
            pstmt.setString(2, Officer.toListStr(this.unemployedOfficers));
            pstmt.setInt(3, this.cash);
            pstmt.setInt(4, this.crop);
            pstmt.setInt(5, this.population);
            pstmt.setString(6, Army.toListStr(this.armies));
            pstmt.setInt(7, this.agriculture);
            pstmt.setInt(8, this.commerce);
            pstmt.setInt(9, this.technology);
            pstmt.setInt(10, this.domination);
            pstmt.setInt(11, this.morale);
            pstmt.setInt(12, this.endurance);
            pstmt.setBoolean(13, this.emperor);
            pstmt.setString(14, Facility.toListStr(this.facilities));
            pstmt.setString(15, Utility.join(this.specialties.toArray(), " "));
            pstmt.setString(16, Utility.joinPoints(this.location, " "));
            pstmt.setString(17, this.connectedLandCity == null ? "" : Utility.join(this.connectedLandCity.toArray(), " "));
            pstmt.setString(18, this.connectedWaterCity == null ? "" : Utility.join(this.connectedWaterCity.toArray(), " "));
            pstmt.setString(19, this.name);
            pstmt.setInt(20, this.type);
            pstmt.setInt(21, this.id);
            pstmt.executeUpdate();
            for (Army a : this.armies) {
                a.writeArmy(conn);
            }
            for (Facility f : this.facilities) {
                f.writeFacility(conn);
            }
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
            }
        }
    }

    public void setEmperorToHere() {
        this.emperor = true;
    }

    public static String toListStr(List<Building> t) {
        int[] r = new int[t.size()];
        for (int i = 0; i < t.size(); ++i) {
            r[i] = t.get((int)i).id;
        }
        return Utility.join(r, " ");
    }

    static {
        facilityProb = null;
    }
}

