/*
 * Decompiled with CFR 0.152.
 */
package CSanScenGenerator;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class FacilityKind {
    private static Map<Integer, FacilityKind> facilities;
    private int id;
    private int occupySpace;
    private boolean buildingUnique;
    private boolean factionUnique;
    private boolean populationRelated;
    private int maxEndurance;

    private FacilityKind(int id, int occupySpace, boolean buildingUnique, boolean factionUnique, boolean populationRelated, int maxEndurance) {
        this.id = id;
        this.occupySpace = occupySpace;
        this.buildingUnique = buildingUnique;
        this.factionUnique = factionUnique;
        this.populationRelated = populationRelated;
        this.maxEndurance = maxEndurance;
    }

    public static Map<Integer, FacilityKind> getFacilities(Connection commonData) throws SQLException {
        if (facilities == null) {
            Statement stmt = commonData.createStatement();
            ResultSet rs = stmt.executeQuery("select ID, PositionOccupied, UniqueInArchitecture, UniqueInFaction, PopulationRelated, Endurance from FacilityKind");
            facilities = new HashMap<Integer, FacilityKind>();
            while (rs.next()) {
                int id = rs.getInt("ID");
                int occupies = rs.getInt("PositionOccupied");
                boolean uia = rs.getBoolean("UniqueInArchitecture");
                boolean uif = rs.getBoolean("UniqueInFaction");
                boolean pr = rs.getBoolean("PopulationRelated");
                int me = rs.getInt("Endurance");
                facilities.put(id, new FacilityKind(id, occupies, uia, uif, pr, me));
            }
            rs.close();
            stmt.close();
        }
        return facilities;
    }

    public int getId() {
        return this.id;
    }

    public int getOccupySpace() {
        return this.occupySpace;
    }

    public boolean isBuildingUnique() {
        return this.buildingUnique;
    }

    public boolean isFactionUnique() {
        return this.factionUnique;
    }

    public boolean isPopulationRelated() {
        return this.populationRelated;
    }

    public int getMaxEndurance() {
        return this.maxEndurance;
    }
}

