/*
 * Decompiled with CFR 0.152.
 */
package CSanScenGenerator;

import CSanScenGenerator.Building;
import CSanScenGenerator.Officer;
import CSanScenGenerator.Team;
import CSanScenGenerator.Technique;
import CSanScenGenerator.Utility;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Faction {
    protected int id;
    protected int color;
    protected int capital;
    protected int reputation;
    protected Officer king;
    protected String name;
    protected List<Building> buildings;
    protected List<Team> teams;
    protected Set<Integer> troopKinds;
    protected Set<Integer> techniques;
    private Connection commonData;
    protected boolean strong;
    private static Set<Integer> usableTroopKinds;

    public Faction(int id, boolean isStrong, Connection commonDataConn) {
        this.id = id;
        this.buildings = new ArrayList<Building>();
        this.teams = new ArrayList<Team>();
        this.troopKinds = new HashSet<Integer>();
        this.techniques = new HashSet<Integer>();
        this.strong = isStrong;
        this.commonData = commonDataConn;
    }

    public void randomReputation(int lo, int hi) {
        this.reputation = Utility.randBetween(lo, hi) * 10;
    }

    private boolean tryToGetTechnique(Map<Integer, Technique> allTech, Integer toGetId, double prob) {
        if (this.techniques.contains(toGetId)) {
            return true;
        }
        Integer requiredTechId = allTech.get(toGetId).getPreId();
        if (Utility.probTestPercentage(prob * 100.0)) {
            if (requiredTechId == -1) {
                this.techniques.add(toGetId);
                return true;
            }
            if (this.tryToGetTechnique(allTech, requiredTechId, prob)) {
                this.techniques.add(toGetId);
                return true;
            }
            return false;
        }
        return false;
    }

    public void randomTechniques(double prob) throws SQLException {
        this.techniques.clear();
        Map<Integer, Technique> allTech = Technique.getTechniques(this.commonData);
        for (Map.Entry<Integer, Technique> i : allTech.entrySet()) {
            Integer requiredTechId = i.getValue().getPreId();
            if (!Utility.probTestPercentage(prob * 100.0)) continue;
            if (requiredTechId == -1) {
                this.techniques.add(i.getKey());
                continue;
            }
            if (!this.tryToGetTechnique(allTech, requiredTechId, prob)) continue;
            this.techniques.add(i.getKey());
        }
    }

    public void defaultTroopKinds() {
        this.troopKinds.addAll(Arrays.asList(0, 1, 2, 29, 30));
    }

    public void randomTroopKinds(double prob) throws IOException {
        if (usableTroopKinds == null) {
            String s;
            usableTroopKinds = new HashSet<Integer>();
            BufferedReader f = new BufferedReader(new FileReader("DATA/factionSpecialMilitary.txt"));
            while ((s = f.readLine()) != null) {
                usableTroopKinds.add(Integer.parseInt(s));
            }
        }
        this.troopKinds.clear();
        this.defaultTroopKinds();
        while (Utility.probTestPercentage(prob)) {
            this.troopKinds.add(Utility.randomPick(usableTroopKinds));
        }
    }

    public void setKing(Officer o) {
        this.king = o;
        this.name = o.getName();
        o.setKing(true);
    }

    public void setColor(int c) {
        this.color = c;
    }

    public boolean populateOfficers(List<Building> allBuildings, int cityCnt, boolean connectedCity, List<Officer> officers, int loyaltyLo, int loyaltyHi, boolean strongHiLoyalty) {
        Team t = new Team(this.id);
        this.buildings = t.populateOfficers(this, cityCnt, connectedCity, allBuildings, officers, this.king, loyaltyLo, loyaltyHi, strongHiLoyalty);
        if (this.buildings.size() > 0) {
            this.teams.add(t);
            this.capital = Utility.randomPick(t.buildings).id;
        }
        return this.buildings.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFaction(Connection conn) throws SQLException {
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("insert into Faction (ID, LeaderID, ColorIndex, FName, CapitalID, Reputation, Sections, Architectures, BaseMilitaryKinds, AvailableTechniques)values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            pstmt.setInt(1, this.id);
            pstmt.setInt(2, this.king.id);
            pstmt.setInt(3, this.color);
            pstmt.setString(4, this.name);
            pstmt.setInt(5, this.capital);
            pstmt.setInt(6, this.reputation);
            pstmt.setString(7, Team.toListStr(this.teams));
            pstmt.setString(8, Team.toListBuildingStr(this.teams));
            pstmt.setString(9, Utility.join(this.troopKinds.toArray(), " "));
            pstmt.setString(10, Utility.join(this.techniques.toArray(), " "));
            pstmt.executeUpdate();
            for (Team t : this.teams) {
                t.writeTeam(conn);
            }
        }
        finally {
            pstmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFactionDiplomacy(Connection conn, List<Faction> f, int lo, int hi, boolean gaussian) throws SQLException {
        Statement pstmt = null;
        try {
            int j;
            int i;
            int[][] diplomacy = new int[f.size()][f.size()];
            for (i = 0; i < diplomacy.length; ++i) {
                for (j = 0; j < diplomacy.length; ++j) {
                    diplomacy[i][j] = (int)(gaussian ? Utility.randGaussian((lo + hi) / 2, (hi - lo) / 2) : (long)Utility.randBetween(lo, hi));
                    diplomacy[j][i] = diplomacy[i][j];
                }
            }
            pstmt = conn.prepareStatement("insert into DiplomaticRelation (Faction1ID, Faction2ID, Relation) values (?, ?, ?)");
            for (i = 0; i < diplomacy.length; ++i) {
                for (j = 0; j < diplomacy.length; ++j) {
                    if (i == j) continue;
                    pstmt.setInt(1, i);
                    pstmt.setInt(2, j);
                    pstmt.setInt(3, diplomacy[i][j]);
                    pstmt.executeUpdate();
                }
            }
        }
        finally {
            pstmt.close();
        }
    }
}

