/*
 * Decompiled with CFR 0.152.
 */
package CSanScenGenerator;

import CSanScenGenerator.Building;
import CSanScenGenerator.Point;
import CSanScenGenerator.Utility;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class GameMap {
    private Terrain[][] mapData;
    private int dimensionX;
    private int dimensionY;

    private GameMap() {
    }

    public static Terrain strToTerrain(String s) {
        if (s.equals("\u5e73\u5730")) {
            return Terrain.FLATLAND;
        }
        if (s.equals("\u8349\u539f")) {
            return Terrain.GRASSLAND;
        }
        if (s.equals("\u68ee\u6797")) {
            return Terrain.FOREST;
        }
        if (s.equals("\u5c71\u5730")) {
            return Terrain.HILL;
        }
        if (s.equals("\u8352\u5730")) {
            return Terrain.WASTELAND;
        }
        if (s.equals("\u6fd5\u5730")) {
            return Terrain.MARSHLAND;
        }
        if (s.equals("\u6c34\u57df")) {
            return Terrain.WATER;
        }
        if (s.equals("\u5cfb\u5dba")) {
            return Terrain.MOUNTAIN;
        }
        if (s.equals("\u6c99\u6f20")) {
            return Terrain.DESERT;
        }
        if (s.equals("\u96ea\u5730")) {
            return Terrain.SNOWLAND;
        }
        return Terrain.FLATLAND;
    }

    public static GameMap createMap(int sizeX, int sizeY, Terrain start, List<MapSetting> setting) {
        GameMap m = new GameMap();
        m.dimensionX = sizeX;
        m.dimensionY = sizeY;
        m.mapData = new Terrain[m.dimensionX][m.dimensionY];
        for (int i = 0; i < m.mapData.length; ++i) {
            for (int j = 0; j < m.mapData[i].length; ++j) {
                m.mapData[i][j] = start;
            }
        }
        for (MapSetting i : setting) {
            m.placeMass(i.terrain, Utility.randBetween(i.pieceLo, i.pieceHi), Utility.randBetween(i.sizeLo, i.sizeHi), i.thinnessLo, i.thinnessHi);
        }
        return m;
    }

    private void placeMass(Terrain terrain, int massCnt, int massSize, double directionFactorLo, double directionFactionHi) {
        for (int i = 0; i < massCnt; ++i) {
            int leftWeight = 100;
            int rightWeight = 100;
            int upWeight = 100;
            int downWeight = 100;
            double directionFactor = Utility.randBetween(directionFactorLo, directionFactionHi);
            if (directionFactor > 0.0) {
                int angle = Utility.randBetween(0, 360);
                leftWeight = (int)((Math.sin((double)angle - 0.7853981633974483) + 1.0) * directionFactor + 100.0);
                rightWeight = (int)((Math.sin((double)angle + 0.7853981633974483) + 1.0) * directionFactor + 100.0);
                upWeight = (int)((Math.sin(angle) + 1.0) * directionFactor + 100.0);
                downWeight = (int)((Math.sin((double)angle + 1.5707963267948966) + 1.0) * directionFactor + 100.0);
            }
            LinkedList<Point> points = new LinkedList<Point>();
            Point newPoint = new Point(Utility.randBetween(0, this.dimensionX - 1), Utility.randBetween(0, this.dimensionY - 1));
            points.add(newPoint);
            this.mapData[newPoint.x][newPoint.y] = terrain;
            for (int j = 0; j < massSize; ++j) {
                Point reference = (Point)points.remove();
                switch (Utility.randomCategorize_i(rightWeight, leftWeight, downWeight, upWeight)) {
                    case 0: {
                        newPoint = new Point(reference.x + 1, reference.y);
                        break;
                    }
                    case 1: {
                        newPoint = new Point(reference.x - 1, reference.y);
                        break;
                    }
                    case 2: {
                        newPoint = new Point(reference.x, reference.y + 1);
                        break;
                    }
                    case 3: {
                        newPoint = new Point(reference.x, reference.y - 1);
                    }
                }
                if (newPoint.x >= 0 && newPoint.x < this.dimensionX && newPoint.y >= 0 && newPoint.y < this.dimensionY) {
                    this.mapData[newPoint.x][newPoint.y] = terrain;
                }
                points.add(newPoint);
            }
        }
    }

    public List<Building> populateWithNewBuildings(int cityCntLo, int cityCntHi, int harbourCntLo, int harbourCntHi, int sizeLo, int sizeHi) throws IOException {
        int i;
        Object loc;
        int buildingCnt = Utility.randBetween(cityCntLo, cityCntHi);
        int harbourCnt = Utility.randBetween(harbourCntLo, harbourCntHi);
        ArrayList<Building> result = new ArrayList<Building>(buildingCnt);
        HashSet<Point> occupiedPoints = new HashSet<Point>();
        for (int i2 = 0; i2 < buildingCnt; ++i2) {
            Point candidate;
            Building b = Building.createBuilding(1);
            int size = (int)Utility.randGaussian((sizeLo + sizeHi) / 2, (sizeHi - sizeLo) / 2);
            if (size <= 0) {
                size = 1;
            }
            loc = new HashSet();
            while (occupiedPoints.contains(candidate = new Point(Utility.randBetween(0, this.dimensionX - 1), Utility.randBetween(0, this.dimensionY - 1)))) {
            }
            occupiedPoints.add(candidate);
            loc.add(candidate);
            for (int j = 1; j < size; ++j) {
                do {
                    Point start = (Point)Utility.randomPick(loc);
                    switch (Utility.randBetween(1, 4)) {
                        case 1: {
                            candidate = new Point(start.x + 1, start.y);
                            break;
                        }
                        case 2: {
                            candidate = new Point(start.x - 1, start.y);
                            break;
                        }
                        case 3: {
                            candidate = new Point(start.x, start.y + 1);
                            break;
                        }
                        case 4: {
                            candidate = new Point(start.x, start.y - 1);
                        }
                    }
                } while (occupiedPoints.contains(candidate));
                if (candidate.x >= 0 && candidate.x < this.dimensionX && candidate.y >= 0 && candidate.y < this.dimensionY) {
                    occupiedPoints.add(candidate);
                    loc.add(candidate);
                    if (this.mapData[candidate.y][candidate.x] != Terrain.MOUNTAIN) continue;
                    this.mapData[candidate.y][candidate.x] = Terrain.HILL;
                    continue;
                }
                --j;
            }
            b.setLocation((Collection<Point>)loc);
            result.add(b);
        }
        HashSet<Point> besideWaterLoc = new HashSet<Point>();
        for (i = 0; i < this.mapData.length; ++i) {
            for (int j = 0; j < this.mapData[i].length; ++j) {
                if (occupiedPoints.contains(new Point(i, j)) || this.mapData[i][j] != Terrain.WATER) continue;
                if (i > 0 && this.mapData[i - 1][j] != Terrain.WATER) {
                    besideWaterLoc.add(new Point(j, i));
                }
                if (i < this.mapData.length - 1 && this.mapData[i + 1][j] != Terrain.WATER) {
                    besideWaterLoc.add(new Point(j, i));
                }
                if (j > 0 && this.mapData[i][j - 1] != Terrain.WATER) {
                    besideWaterLoc.add(new Point(j, i));
                }
                if (j >= this.mapData[i].length - 1 || this.mapData[i][j + 1] == Terrain.WATER) continue;
                besideWaterLoc.add(new Point(j, i));
            }
        }
        if (besideWaterLoc.size() > 0) {
            for (i = 0; i < harbourCnt; ++i) {
                Building b = Building.createBuilding(3);
                loc = (Point)Utility.randomPick(besideWaterLoc);
                b.setLocation(Collections.singleton(loc));
                besideWaterLoc.remove(loc);
                result.add(b);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMap(Connection conn) throws SQLException {
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("Update Map set DimensionX = ?, DimensionY = ?, MapData = ?, FileName = '', useSimpleArchImages = yes");
            pstmt.setInt(1, this.dimensionX);
            pstmt.setInt(2, this.dimensionY);
            StringBuilder mapDataBuilder = new StringBuilder();
            for (int i = 0; i < this.mapData.length; ++i) {
                for (int j = 0; j < this.mapData[i].length; ++j) {
                    mapDataBuilder.append(this.mapData[i][j].ordinal() + 1).append(" ");
                }
            }
            pstmt.setString(3, mapDataBuilder.toString());
            pstmt.executeUpdate();
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
            }
        }
    }

    public static class MapSetting {
        public Terrain terrain;
        public int pieceLo;
        public int pieceHi;
        public int sizeLo;
        public int sizeHi;
        public int thinnessLo;
        public int thinnessHi;
    }

    public static enum Terrain {
        FLATLAND,
        GRASSLAND,
        FOREST,
        MARSHLAND,
        HILL,
        WATER,
        MOUNTAIN,
        WASTELAND,
        DESERT,
        SNOWLAND;

    }
}

