/*
 * Decompiled with CFR 0.152.
 */
package CSanScenGenerator;

import CSanScenGenerator.InfluenceRate;
import CSanScenGenerator.Utility;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class InfluenceKindRate {
    private static Map<Integer, InfluenceKindRate> influences;
    private int id;
    private int weaponRate;
    private int bookRate;
    private int horseRate;
    private int[] titleRate = new int[9];
    private boolean isBattle;
    private double leaderProb;
    private double baseValue;
    private boolean baseValueInverse;
    private double buildingRate;
    private boolean buildingRateInverse;
    private double paramMin;
    private double paramMax;
    private boolean integralParam;
    private String description;

    private static Map<Integer, InfluenceKindRate> getInfluenceKindRates() throws IOException, SQLException {
        if (influences == null) {
            influences = new HashMap<Integer, InfluenceKindRate>();
            BufferedReader f = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("DATA/influenceKind.txt"), "UTF-8"));
            while (true) {
                InfluenceKindRate r = new InfluenceKindRate();
                String line = f.readLine();
                if (line == null) break;
                String[] s = line.split("\\s");
                r.id = Integer.parseInt(s[0]);
                r.weaponRate = Integer.parseInt(s[1]);
                r.bookRate = Integer.parseInt(s[2]);
                r.horseRate = Integer.parseInt(s[3]);
                r.baseValue = Double.parseDouble(s[4]);
                r.baseValueInverse = s[5].equals("1");
                r.buildingRate = Double.parseDouble(s[6]);
                r.buildingRateInverse = s[7].equals("1");
                try {
                    r.paramMin = Integer.parseInt(s[8]);
                    r.paramMax = Integer.parseInt(s[9]);
                    r.integralParam = true;
                }
                catch (NumberFormatException ex) {
                    r.paramMin = Double.parseDouble(s[8]);
                    r.paramMax = Double.parseDouble(s[9]);
                    r.integralParam = false;
                }
                for (int i = 0; i < 9; ++i) {
                    r.titleRate[i] = Integer.parseInt(s[i + 10]);
                }
                r.isBattle = s[19].equals("1");
                r.leaderProb = Double.parseDouble(s[20]);
                r.description = s[21];
                influences.put(r.id, r);
            }
            f.close();
        }
        return influences;
    }

    public static Map<Integer, InfluenceRate> generateInfluences(Connection commonData, int cnt) throws IOException, SQLException {
        commonData.createStatement().execute("delete from Influence where ID >= 10000");
        Map<Integer, InfluenceKindRate> kinds = InfluenceKindRate.getInfluenceKindRates();
        HashMap<Integer, InfluenceRate> result = new HashMap<Integer, InfluenceRate>();
        for (int i = 0; i < cnt; ++i) {
            double param;
            InfluenceRate r = new InfluenceRate();
            r.id = 10000 + i;
            InfluenceKindRate k = Utility.randomPick(kinds.values());
            r.bookRate = k.bookRate;
            r.horseRate = k.horseRate;
            r.weaponRate = k.weaponRate;
            r.leaderProb = k.leaderProb;
            r.isBattle = k.isBattle;
            r.titleRate = Arrays.copyOf(k.titleRate, k.titleRate.length);
            String desc = k.description;
            if (k.integralParam) {
                int lo = (int)Math.round(k.paramMin);
                int hi = (int)Math.round(k.paramMax);
                int paramI = Utility.randBetween(lo, hi);
                desc = desc.replace("$i", Integer.toString(paramI)).replace("$d", Integer.toString(paramI)).replace("$f", Integer.toString(paramI * 100)).replace("$e", Integer.toString((1 - paramI) * 100)).replace("$m", Double.toString(paramI * 10000));
                param = paramI;
            } else {
                double lo = k.paramMin;
                double hi = k.paramMax;
                param = Utility.randBetween(lo, hi);
                param = Utility.roundToSignificantFigures(param, 2);
                DecimalFormat df2 = new DecimalFormat("0.00");
                DecimalFormat df = new DecimalFormat("0");
                desc = desc.replace("$i", df2.format(param)).replace("$d", df.format(param * 100.0)).replace("$f", df.format((param - 1.0) * 100.0)).replace("$e", df.format((1.0 - param) * 100.0)).replace("$m", df.format(param * 10000.0));
            }
            r.actualValue = k.baseValueInverse ? (int)Math.round(k.baseValue / param) : (int)Math.round(k.baseValue * param);
            r.buildingRate = k.buildingRateInverse ? (int)Math.round(k.buildingRate / param) : (int)Math.round(k.buildingRate / param);
            PreparedStatement stmt = commonData.prepareStatement("insert into Influence (ID, Kind, Name, Description, Parameter, Parameter2) values (?, ?, ?, ?, ?, ?)");
            stmt.setInt(1, r.id);
            stmt.setInt(2, k.id);
            if (desc.contains("$t")) {
                int terrain = Utility.randBetween(1, 9);
                if (terrain >= 7) {
                    ++terrain;
                }
                String terrainString = "";
                double costMod = 1.0;
                switch (terrain) {
                    case 1: {
                        terrainString = "\u5e73\u539f";
                        costMod = 2.0;
                        break;
                    }
                    case 2: {
                        terrainString = "\u8349\u539f";
                        costMod = 2.0;
                        break;
                    }
                    case 3: {
                        terrainString = "\u68ee\u6797";
                        break;
                    }
                    case 4: {
                        terrainString = "\u6e7f\u5730";
                        costMod = 0.5;
                        break;
                    }
                    case 5: {
                        terrainString = "\u5c71\u5730";
                        break;
                    }
                    case 6: {
                        terrainString = "\u6c34\u57df";
                        costMod = 1.5;
                        break;
                    }
                    case 8: {
                        terrainString = "\u8352\u5730";
                        break;
                    }
                    case 9: {
                        terrainString = "\u6c99\u6f20";
                        costMod = 0.5;
                        break;
                    }
                    case 10: {
                        terrainString = "\u96ea\u5730";
                        costMod = 0.5;
                    }
                }
                r.actualValue = (int)((double)r.actualValue * costMod);
                desc = desc.replace("$t", terrainString);
                stmt.setString(3, desc);
                stmt.setString(4, desc);
                stmt.setInt(5, terrain);
                stmt.setDouble(6, param);
            } else if (desc.contains("$s")) {
                int military = Utility.randBetween(0, 4);
                String militaryString = "";
                switch (military) {
                    case 0: {
                        militaryString = "\u6b65\u5175";
                        break;
                    }
                    case 1: {
                        militaryString = "\u5f29\u5175";
                        break;
                    }
                    case 2: {
                        militaryString = "\u9a0e\u5175";
                        break;
                    }
                    case 3: {
                        militaryString = "\u6c34\u8ecd";
                        break;
                    }
                    case 4: {
                        militaryString = "\u5668\u68b0";
                    }
                }
                desc = desc.replace("$s", militaryString);
                stmt.setString(3, desc);
                stmt.setString(4, desc);
                stmt.setInt(5, military);
                stmt.setDouble(6, param);
            } else if (desc.contains("$z")) {
                int disaster = Utility.randBetween(0, 5);
                String disasterString = "";
                switch (disaster) {
                    case 0: {
                        disasterString = "\u6c34\u707d";
                        break;
                    }
                    case 1: {
                        disasterString = "\u65f1\u707d";
                        break;
                    }
                    case 2: {
                        disasterString = "\u5730\u9707";
                        break;
                    }
                    case 3: {
                        disasterString = "\u8757\u707d";
                        break;
                    }
                    case 4: {
                        disasterString = "\u761f\u75ab";
                        break;
                    }
                    case 5: {
                        disasterString = "\u98a8\u707d";
                    }
                }
                desc = desc.replace("$z", disasterString);
                stmt.setString(3, desc);
                stmt.setString(4, desc);
                stmt.setInt(5, disaster);
                stmt.setDouble(6, param);
            } else {
                stmt.setString(3, desc);
                stmt.setString(4, desc);
                stmt.setDouble(5, param);
                if (k.id == 352 || k.id == 6140) {
                    stmt.setInt(6, 1);
                } else {
                    stmt.setString(6, "");
                }
            }
            r.description = desc;
            stmt.executeUpdate();
            result.put(r.id, r);
        }
        return result;
    }
}

