/*
 * Decompiled with CFR 0.152.
 */
package CSanScenGenerator;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class InfluenceRate {
    private static Map<Integer, InfluenceRate> influences;
    int id;
    int weaponRate;
    int bookRate;
    int horseRate;
    int[] titleRate = new int[9];
    boolean isBattle;
    double leaderProb;
    int actualValue;
    int buildingRate;
    String description;
    private static Map<Integer, Map<Integer, Integer>> titleRates;
    private static Map<Integer, Map<Integer, Integer>> battleRates;

    public static void addInfluences(Connection commonData, Map<Integer, InfluenceRate> rates) throws IOException, SQLException {
        if (influences == null) {
            InfluenceRate.getInfluenceRates(commonData);
        }
        influences.putAll(rates);
    }

    private static Map<Integer, InfluenceRate> getInfluenceRates(Connection commonData) throws IOException, SQLException {
        if (influences == null) {
            ResultSet rs;
            Statement stmt;
            BufferedReader f;
            block3: {
                InfluenceRate r;
                influences = new HashMap<Integer, InfluenceRate>();
                f = new BufferedReader(new FileReader("DATA/influence.txt"));
                stmt = commonData.createStatement();
                rs = null;
                while (true) {
                    r = new InfluenceRate();
                    String line = f.readLine();
                    if (line == null) break block3;
                    String[] s = line.split("\\s");
                    r.id = Integer.parseInt(s[0]);
                    r.weaponRate = Integer.parseInt(s[1]);
                    r.bookRate = Integer.parseInt(s[2]);
                    r.horseRate = Integer.parseInt(s[3]);
                    r.actualValue = Integer.parseInt(s[4]);
                    r.buildingRate = Integer.parseInt(s[5]);
                    for (int i = 0; i < 9; ++i) {
                        r.titleRate[i] = Integer.parseInt(s[i + 6]);
                    }
                    r.isBattle = s[15].equals("1");
                    r.leaderProb = Double.parseDouble(s[16]);
                    influences.put(r.id, r);
                    rs = stmt.executeQuery("select Description from Influence where ID = " + r.id);
                    if (!rs.next()) break;
                    r.description = rs.getString(1);
                }
                throw new IllegalArgumentException("influnece.txt\u4e2d\u7684\u5f71\u97ff\u7de8\u865f" + r.id + "\u4e0d\u5b58\u5728");
            }
            f.close();
            rs.close();
            stmt.close();
        }
        return influences;
    }

    public static Map<Integer, Integer> getWeaponRates(Connection cdData) throws SQLException, IOException {
        HashMap<Integer, Integer> r = new HashMap<Integer, Integer>();
        for (InfluenceRate i : InfluenceRate.getInfluenceRates(cdData).values()) {
            r.put(i.id, i.weaponRate);
        }
        return r;
    }

    public static Map<Integer, Integer> getBookRates(Connection cdData) throws SQLException, IOException {
        HashMap<Integer, Integer> r = new HashMap<Integer, Integer>();
        for (InfluenceRate i : InfluenceRate.getInfluenceRates(cdData).values()) {
            r.put(i.id, i.bookRate);
        }
        return r;
    }

    public static Map<Integer, Integer> getHorseRates(Connection cdData) throws SQLException, IOException {
        HashMap<Integer, Integer> r = new HashMap<Integer, Integer>();
        for (InfluenceRate i : InfluenceRate.getInfluenceRates(cdData).values()) {
            r.put(i.id, i.horseRate);
        }
        return r;
    }

    public static Map<Integer, Integer> getBuildingRates(Connection cdData) throws SQLException, IOException {
        HashMap<Integer, Integer> r = new HashMap<Integer, Integer>();
        for (InfluenceRate i : InfluenceRate.getInfluenceRates(cdData).values()) {
            r.put(i.id, i.buildingRate);
        }
        return r;
    }

    public static Map<Integer, Integer> getTitleRates(Connection cdData, int type, boolean battleOnly) throws IOException, SQLException {
        if (battleOnly) {
            if (!battleRates.containsKey(type)) {
                battleRates.put(type, new HashMap());
                for (InfluenceRate i : InfluenceRate.getInfluenceRates(cdData).values()) {
                    if (!i.isBattle) continue;
                    battleRates.get(type).put(i.id, i.titleRate[type]);
                }
            }
            return battleRates.get(type);
        }
        if (!titleRates.containsKey(type)) {
            titleRates.put(type, new HashMap());
            for (InfluenceRate i : InfluenceRate.getInfluenceRates(cdData).values()) {
                titleRates.get(type).put(i.id, i.titleRate[type]);
            }
        }
        return titleRates.get(type);
    }

    public static boolean isBattle(Connection cdData, int influenceId) throws IOException, SQLException {
        return InfluenceRate.getInfluenceRates((Connection)cdData).get((Object)Integer.valueOf((int)influenceId)).isBattle;
    }

    public static double getLeaderProb(Connection cdData, int influenceId) throws IOException, SQLException {
        return InfluenceRate.getInfluenceRates((Connection)cdData).get((Object)Integer.valueOf((int)influenceId)).leaderProb;
    }

    public static int getActualValue(Connection cdData, int influenceId) throws IOException, SQLException {
        return InfluenceRate.getInfluenceRates((Connection)cdData).get((Object)Integer.valueOf((int)influenceId)).actualValue;
    }

    public static String getDescription(Connection cdData, int influenceId) throws IOException, SQLException {
        return InfluenceRate.getInfluenceRates((Connection)cdData).get((Object)Integer.valueOf((int)influenceId)).description;
    }

    static {
        titleRates = new HashMap<Integer, Map<Integer, Integer>>();
        battleRates = new HashMap<Integer, Map<Integer, Integer>>();
    }
}

