/*
 * Decompiled with CFR 0.152.
 */
package CSanScenGenerator;

import CSanScenGenerator.Building;
import CSanScenGenerator.Database;
import CSanScenGenerator.Skill;
import CSanScenGenerator.Stunt;
import CSanScenGenerator.Title;
import CSanScenGenerator.Utility;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class Officer {
    private static Map<Integer, Integer> personalConsiderationAttachment;
    public static final boolean MALE = false;
    public static final boolean FEMALE = true;
    protected Random rng = new Random();
    protected Database db;
    protected boolean gender = false;
    protected String surname;
    protected String givenname;
    protected String calledname;
    protected int leadership;
    protected int might;
    protected int intelligence;
    protected int politics;
    protected int glamour;
    protected int face;
    protected int debut;
    protected int born;
    protected int dead;
    protected int debutLocation;
    protected int deadReason;
    protected int personAttachment;
    protected int loyalty;
    protected int righteous;
    protected int ambition;
    protected int popularity;
    protected int calm;
    protected int gut;
    protected int personalityConsideration;
    protected int personality;
    protected int officerTendency;
    protected int hanAttitude;
    protected int stretagicalAttitude;
    protected int bornLocation;
    protected Set<Integer> skill = new HashSet<Integer>();
    protected Set<Integer> stunt = new HashSet<Integer>();
    protected int personalTitle = -1;
    protected int battleTitle = -1;
    protected boolean debutted;
    protected boolean living;
    protected int id;
    protected int blood;
    protected int tightblood;
    protected boolean canStartFaction;
    protected Building building;
    protected boolean employed;
    protected Officer father;
    protected Officer mother;
    protected Officer spouse;
    protected Officer brother;
    protected int generation;
    private boolean isKing = false;
    private Officer king;
    protected boolean strong;
    protected boolean leaderPossibility;
    protected Connection commonData;
    protected List<Officer> imitateOfficer = new ArrayList<Officer>();
    protected List<Officer> hateOfficer = new ArrayList<Officer>();
    private static int maxIdealTendencyId;
    private static int maleFaceIndex;
    private static int femaleFaceIndex;
    private static int maleFaceAIndex;
    private static int maleFaceMIndex;
    private static int maleFaceUIndex;
    private static int femaleFaceAIndex;
    private static int femaleFaceMIndex;

    Officer(Connection commonDataConn) throws SQLException {
        if (personalConsiderationAttachment == null) {
            personalConsiderationAttachment = new HashMap<Integer, Integer>();
            Statement stmt2 = commonDataConn.createStatement();
            ResultSet rs = stmt2.executeQuery("select ID, offset from IdealTendencyKind");
            while (rs.next()) {
                int a = rs.getInt("offset");
                int b = rs.getInt("ID");
                personalConsiderationAttachment.put(b, a);
            }
            rs.close();
            stmt2.close();
        }
    }

    public Officer(Database db, int id, boolean inStrong, Connection commonDataConn) throws SQLException {
        this.db = db;
        this.id = id;
        this.strong = inStrong;
        this.blood = id;
        this.tightblood = id;
        this.generation = 0;
        if (personalConsiderationAttachment == null) {
            personalConsiderationAttachment = new HashMap<Integer, Integer>();
            Statement stmt2 = commonDataConn.createStatement();
            ResultSet rs = stmt2.executeQuery("select ID, offset from IdealTendencyKind");
            while (rs.next()) {
                int a = rs.getInt("offset");
                int b = rs.getInt("ID");
                personalConsiderationAttachment.put(b, a);
            }
            rs.close();
            stmt2.close();
        }
        this.commonData = commonDataConn;
    }

    public boolean isStrong() {
        return this.strong;
    }

    public boolean isAlive() {
        return this.living;
    }

    public void setParent(Officer inFather, Officer inMother) {
        this.father = inFather;
        this.mother = inMother;
        if (inFather != null) {
            this.blood = inFather.blood;
            this.tightblood = inFather.tightblood;
            this.generation = inFather.generation + 1;
        } else if (inMother != null) {
            this.tightblood = inMother.tightblood;
            this.generation = inMother.generation + 1;
        }
    }

    public void setSpouse(Officer o) {
        this.spouse = o;
        if (o != null) {
            this.tightblood = o.tightblood;
        }
    }

    public Officer getSpouse() {
        return this.spouse;
    }

    public int getGeneration() {
        return this.generation;
    }

    public int getTightBlood() {
        return this.tightblood;
    }

    public boolean getGender() {
        return this.gender;
    }

    public void setRandomGender(double femaleProb) {
        this.gender = (double)this.rng.nextFloat() <= femaleProb;
    }

    public void setRandomNames(double doubleNameProb) {
        String picked;
        List<String> surnameList = this.db.getSurname();
        List<String> givennameList = !this.gender ? this.db.getMalegivenname() : this.db.getFemalegivenname();
        this.surname = picked = surnameList.get(this.rng.nextInt(surnameList.size()));
        this.givenname = picked = givennameList.get(this.rng.nextInt(givennameList.size()));
        if (picked.length() < 2 && (double)this.rng.nextFloat() <= doubleNameProb && (picked = givennameList.get(this.rng.nextInt(givennameList.size()))).length() == 1) {
            this.givenname = this.givenname + picked;
        }
        this.calledname = "";
        if (this.father != null) {
            this.surname = this.father.surname;
        }
    }

    public String getName() {
        return this.surname + this.givenname;
    }

    public int getId() {
        return this.id;
    }

    public void randomFaceImage() {
        List<Integer> list = !this.gender ? this.db.getMaleface() : this.db.getFemaleface();
        this.face = list.get(this.rng.nextInt(list.size()));
    }

    public void setFace(int x) {
        this.face = x;
    }

    public int maxAbility() {
        int r = this.leadership;
        if (this.might > r) {
            r = this.might;
        }
        if (this.intelligence > r) {
            r = this.intelligence;
        }
        if (this.politics > r) {
            r = this.politics;
        }
        return r;
    }

    public void tweakAbility(double mul, int abs) {
        this.leadership = (int)((double)this.leadership * mul + (double)abs);
        this.might = (int)((double)this.might * mul + (double)abs);
        this.intelligence = (int)((double)this.intelligence * mul + (double)abs);
        this.politics = (int)((double)this.politics * mul + (double)abs);
        this.glamour = (int)((double)this.glamour * mul + (double)abs);
    }

    public void randomAbility(double mul, double abs, int loCap, int hiCap) {
        this.leadership = Utility.randBetween_f(1.0 * mul + abs, 100.0 * mul + abs);
        this.might = Utility.randBetween_f(1.0 * mul + abs, 100.0 * mul + abs);
        this.intelligence = Utility.randBetween_f(1.0 * mul + abs, 100.0 * mul + abs);
        this.politics = Utility.randBetween_f(1.0 * mul + abs, 100.0 * mul + abs);
        this.glamour = Utility.randBetween_f(1.0 * mul + abs, 100.0 * mul + abs);
        if (!this.strong) {
            this.leadership = Utility.cap(this.leadership, loCap, hiCap);
            this.might = Utility.cap(this.might, loCap, hiCap);
            this.intelligence = Utility.cap(this.intelligence, loCap, hiCap);
            this.politics = Utility.cap(this.politics, loCap, hiCap);
            this.glamour = Utility.cap(this.glamour, loCap, hiCap);
        }
    }

    public void abilityFromParent(int loCap, int hiCap, int base, int var) {
        if (this.father != null && this.mother != null) {
            this.leadership = Utility.randBetween(Math.min(this.father.leadership, this.mother.leadership) - var, Math.max(this.father.leadership, this.mother.leadership) + var) + base;
            this.might = Utility.randBetween(Math.min(this.father.might, this.mother.might) - var, Math.max(this.father.might, this.mother.might) + var) + base;
            this.intelligence = Utility.randBetween(Math.min(this.father.intelligence, this.mother.intelligence) - var, Math.max(this.father.intelligence, this.mother.intelligence) + var) + base;
            this.politics = Utility.randBetween(Math.min(this.father.politics, this.mother.politics) - var, Math.max(this.father.politics, this.mother.politics) + var) + base;
            this.glamour = Utility.randBetween(Math.min(this.father.glamour, this.mother.glamour) - var, Math.max(this.father.glamour, this.mother.glamour) + var) + base;
        } else {
            this.leadership = (int)Utility.randGaussian((this.father != null ? this.father : this.mother).leadership, var) + base;
            this.might = (int)Utility.randGaussian((this.father != null ? this.father : this.mother).might, var) + base;
            this.intelligence = (int)Utility.randGaussian((this.father != null ? this.father : this.mother).intelligence, var) + base;
            this.politics = (int)Utility.randGaussian((this.father != null ? this.father : this.mother).politics, var) + base;
            this.glamour = (int)Utility.randGaussian((this.father != null ? this.father : this.mother).glamour, var) + base;
        }
        if (!this.strong) {
            this.leadership = Utility.cap(this.leadership, loCap, hiCap);
            this.might = Utility.cap(this.might, loCap, hiCap);
            this.intelligence = Utility.cap(this.intelligence, loCap, hiCap);
            this.politics = Utility.cap(this.politics, loCap, hiCap);
            this.glamour = Utility.cap(this.glamour, loCap, hiCap);
        }
    }

    public int getAbilitySum() {
        return this.leadership + this.might + this.intelligence + this.politics + this.glamour;
    }

    public int getAbilityMin() {
        return Collections.min(Arrays.asList(this.leadership, this.might, this.intelligence, this.politics, this.glamour));
    }

    public int getAbilityMax() {
        return Collections.max(Arrays.asList(this.leadership, this.might, this.intelligence, this.politics, this.glamour));
    }

    public void setAvailability(int scenYear, List<Building> allBuildings) {
        this.debutted = this.debut <= scenYear;
        boolean bl = this.living = scenYear <= this.dead;
        if (!this.debutted) {
            this.debutLocation = Utility.randomPick(allBuildings).id;
        }
    }

    public void completeRandomYears(int scenYear, int lo, int hi, int bornLo, int bornHi, int livingLo, int livingHi, boolean isDebutted, List<Building> allBuildings) {
        this.debut = Utility.randBetween(lo, this.debutted ? scenYear : hi);
        this.born = this.debut - Utility.randBetween(bornLo, bornHi);
        this.dead = Math.max(this.debut, scenYear) + Utility.randBetween(livingLo, livingHi);
        this.setAvailability(scenYear, allBuildings);
    }

    public void yearFromParent(int scenYear, int bornLo, int bornHi, int livingLo, int livingHi, List<Building> allBuildings, int parentLo, int parentHi) {
        this.born = this.mother != null ? this.mother.born + Utility.randBetween(parentLo, parentHi) : this.father.born + Utility.randBetween(parentLo, parentHi);
        this.debut = this.born + Utility.randBetween(bornLo, bornHi);
        this.dead = Math.max(this.debut, scenYear) + Utility.randBetween(livingLo, livingHi);
        this.setAvailability(scenYear, allBuildings);
    }

    public boolean isAvailable() {
        return this.debutted && this.living;
    }

    public int getBornYear() {
        return this.born;
    }

    public int getPersonAttachmentDifference(Officer anotherOfficer, int cap) {
        int result = Math.abs(anotherOfficer.personAttachment - this.personAttachment);
        if (result > cap / 2) {
            result = cap - result;
        }
        return result;
    }

    public void randomDeathReason(double naturalDeathProb) {
        this.deadReason = (double)this.rng.nextFloat() <= naturalDeathProb ? 0 : 1;
    }

    public void randomPersonAttachment(int lo, int hi) {
        this.personAttachment = Utility.randBetween(lo, hi);
    }

    public void attachmentFromParent(int lo, int hi, int var) {
        this.personAttachment = this.father == null ? (int)Utility.randGaussian(this.mother.personAttachment, var) : (this.mother == null ? (int)Utility.randGaussian(this.father.personAttachment, var) : (int)Utility.randGaussian((Utility.probTestPercentage((double)50.0) ? this.father : this.mother).personAttachment, var));
        if (this.personAttachment < lo) {
            this.personAttachment += hi - lo;
        } else if (this.personAttachment > hi) {
            this.personAttachment -= hi - lo;
        }
    }

    public void randomPersonAttachmentWithinDiff(Officer reference, int value, int hi) {
        this.personAttachment = Utility.randBetween(reference.personAttachment - value, reference.personAttachment + value);
        if (this.personAttachment >= hi) {
            this.personAttachment -= hi;
        }
        if (this.personAttachment < 0) {
            this.personAttachment += hi;
        }
    }

    public void randomHiddenValues() {
        this.righteous = Utility.randBetween(0, 4);
        this.ambition = Utility.randBetween(0, 4);
        this.officerTendency = Utility.randBetween(0, 4);
        this.gut = Utility.randBetween(1, 9);
        this.calm = Utility.randBetween(1, 9);
        this.hanAttitude = Utility.randBetween(0, 2);
        this.stretagicalAttitude = Utility.randBetween(0, 3);
        this.personalityConsideration = Utility.randBetween(0, 6);
        this.bornLocation = Utility.randBetween(0, 17);
        this.personality = Utility.randBetween(1, 6);
    }

    public void randomLeaderPossibility(int factor) {
        this.leaderPossibility = Utility.probTestPercentage(factor * this.ambition);
    }

    public void hiddenValuesFromParent() {
        if (this.father != null && this.mother != null) {
            this.righteous = (Utility.probTestPercentage((double)50.0) ? this.father : this.mother).righteous + Utility.randomCategorize(0.1, 0.2, 0.4, 0.2, 0.1) - 2;
            this.ambition = (Utility.probTestPercentage((double)50.0) ? this.father : this.mother).ambition + Utility.randomCategorize(0.1, 0.2, 0.4, 0.2, 0.1) - 2;
            this.officerTendency = Utility.probTestPercentage(84.0) ? (Utility.probTestPercentage((double)50.0) ? this.father : this.mother).officerTendency : Utility.randBetween(0, 4);
            this.gut = (Utility.probTestPercentage((double)50.0) ? this.father : this.mother).gut + Utility.randomCategorize(0.05, 0.05, 0.1, 0.2, 0.3, 0.2, 0.1, 0.05, 0.05) - 4;
            this.calm = (Utility.probTestPercentage((double)50.0) ? this.father : this.mother).calm + Utility.randomCategorize(0.05, 0.05, 0.1, 0.2, 0.3, 0.2, 0.1, 0.05, 0.05) - 4;
            this.hanAttitude = (Utility.probTestPercentage((double)50.0) ? this.father : this.mother).hanAttitude + Utility.randomCategorize(0.2, 0.6, 0.2) - 1;
            this.stretagicalAttitude = (Utility.probTestPercentage((double)50.0) ? this.father : this.mother).stretagicalAttitude + Utility.randomCategorize(0.2, 0.6, 0.2) - 1;
            this.personalityConsideration = (Utility.probTestPercentage((double)50.0) ? this.father : this.mother).personalityConsideration + Utility.randomCategorize(0.1, 0.2, 0.4, 0.2, 0.1) - 2;
            int n = Utility.probTestPercentage(80.0) ? (Utility.probTestPercentage((double)25.0) ? this.father : this.mother).bornLocation : (this.bornLocation = Utility.randBetween(0, 17));
            this.personality = Utility.probTestPercentage(50.0) ? (Utility.probTestPercentage((double)50.0) ? this.father : this.mother).personality : Utility.randBetween(1, 6);
            this.leaderPossibility = Utility.probTestPercentage(50.0) ? this.father.leaderPossibility : this.mother.leaderPossibility;
        } else {
            this.righteous = (this.father != null ? this.father : this.mother).righteous + Utility.randomCategorize(0.1, 0.2, 0.4, 0.2, 0.1) - 2;
            this.ambition = (this.father != null ? this.father : this.mother).righteous + Utility.randomCategorize(0.1, 0.2, 0.4, 0.2, 0.1) - 2;
            this.officerTendency = Utility.probTestPercentage(60.0) ? (this.father != null ? this.father : this.mother).officerTendency : Utility.randBetween(0, 4);
            this.gut = (this.father != null ? this.father : this.mother).gut + Utility.randomCategorize(0.05, 0.05, 0.1, 0.2, 0.3, 0.2, 0.1, 0.05, 0.05) - 4;
            this.calm = (this.father != null ? this.father : this.mother).calm + Utility.randomCategorize(0.05, 0.05, 0.1, 0.2, 0.3, 0.2, 0.1, 0.05, 0.05) - 4;
            this.hanAttitude = (this.father != null ? this.father : this.mother).hanAttitude + Utility.randomCategorize(0.2, 0.6, 0.2) - 1;
            this.stretagicalAttitude = (this.father != null ? this.father : this.mother).stretagicalAttitude + Utility.randomCategorize(0.2, 0.6, 0.2) - 1;
            this.personalityConsideration = (this.father != null ? this.father : this.mother).personalityConsideration + Utility.randomCategorize(0.1, 0.2, 0.4, 0.2, 0.1) - 2;
            int n = Utility.probTestPercentage(80.0) ? (this.father != null ? this.father : this.mother).bornLocation : (this.bornLocation = Utility.randBetween(0, 17));
            this.personality = Utility.probTestPercentage(50.0) ? (this.father != null ? this.father : this.mother).personality : Utility.randBetween(1, 6);
            this.leaderPossibility = (this.father != null ? this.father : this.mother).leaderPossibility;
        }
        this.righteous = Utility.cap(this.righteous, 0, 4);
        this.gut = Utility.cap(this.gut, 1, 9);
        this.calm = Utility.cap(this.calm, 1, 9);
        this.hanAttitude = Utility.cap(this.hanAttitude, 0, 2);
        this.stretagicalAttitude = Utility.cap(this.stretagicalAttitude, 0, 3);
        this.personalityConsideration = Utility.cap(this.personalityConsideration, 0, 6);
    }

    private static int findMaxIdealTendencyId() {
        int min = Integer.MAX_VALUE;
        int r = -1;
        for (Map.Entry<Integer, Integer> i : personalConsiderationAttachment.entrySet()) {
            if (i.getValue() >= min) continue;
            min = i.getValue();
            r = i.getKey();
        }
        return r;
    }

    public void setMaxIdealTendency() {
        if (maxIdealTendencyId == -1) {
            maxIdealTendencyId = Officer.findMaxIdealTendencyId();
        }
        this.personalityConsideration = maxIdealTendencyId;
    }

    public void setMaxAmbition() {
        this.ambition = 4;
        this.stretagicalAttitude = 0;
    }

    public void randomPopularity(int lo, int hi) {
        this.popularity = Utility.randBetween(lo, hi) * 10;
    }

    public void popularityFromParent(double lo, double hi) {
        this.popularity = this.father == null ? (int)((double)this.mother.popularity * Utility.randBetween(lo, hi)) : (this.mother == null ? (int)((double)this.father.popularity * Utility.randBetween(lo, hi)) : (int)((double)Math.max(this.father.popularity, this.mother.popularity) * Utility.randBetween(lo, hi)));
    }

    public void specialFromParent(int base, int var) throws SQLException {
        this.skill.clear();
        Set<Integer> skillIds = Skill.getSkills(this.commonData).keySet();
        for (Integer i : skillIds) {
            double prob = this.father != null && this.mother != null ? (this.father.skill.contains(i) && this.mother.skill.contains(i) ? (double)(base * 2 - var) : (this.father.skill.contains(i) || this.mother.skill.contains(i) ? (double)base : (double)var)) : ((this.father != null ? this.father : this.mother).skill.contains(i) ? (double)(base * 2 - var) : (double)var);
            if (!Utility.probTestPercentage(prob)) continue;
            this.skill.add(i);
        }
    }

    public void randomSpecials(double rate, int abyThreshold, double abyRate) throws SQLException {
        this.skill.clear();
        Set<Integer> skillIds = Skill.getSkills(this.commonData).keySet();
        for (Integer i : skillIds) {
            if (!Utility.probTestPercentage(rate * (this.maxAbility() <= abyThreshold ? 1.0 : (double)(this.maxAbility() - abyThreshold) / (100.0 - (double)abyThreshold) * (abyRate - 1.0) + 1.0))) continue;
            this.skill.add(i);
        }
    }

    public void stuntFromParent(int base, int var) throws SQLException {
        this.stunt.clear();
        Set<Integer> stuntIds = Stunt.getStunts(this.commonData).keySet();
        for (Integer i : stuntIds) {
            double prob = this.father != null && this.mother != null ? (this.father.skill.contains(i) && this.mother.skill.contains(i) ? (double)(base * 2 - var) : (this.father.skill.contains(i) || this.mother.skill.contains(i) ? (double)base : (double)var)) : ((this.father != null ? this.father : this.mother).skill.contains(i) ? (double)(base * 2 - var) : (double)var);
            if (!Utility.probTestPercentage(prob)) continue;
            this.stunt.add(i);
        }
    }

    public void randomStunts(double rate, int abyThreshold, double abyRate) throws SQLException {
        this.stunt.clear();
        Set<Integer> stuntIds = Stunt.getStunts(this.commonData).keySet();
        for (Integer i : stuntIds) {
            if (!Utility.probTestPercentage(rate * (this.maxAbility() <= abyThreshold ? 1.0 : (double)(this.maxAbility() - abyThreshold) / (100.0 - (double)abyThreshold) * (abyRate - 1.0) + 1.0))) continue;
            this.stunt.add(i);
        }
    }

    public void personalTitleFromParent(double noSpecProb, int inherit) throws SQLException {
        this.randomPersonalTitles(noSpecProb);
        if (this.father != null && this.mother != null) {
            if (Utility.probTestPercentage(inherit * 2)) {
                this.personalTitle = (Utility.probTestPercentage((double)50.0) ? this.father : this.mother).personalTitle;
                return;
            }
        } else if (Utility.probTestPercentage(inherit)) {
            this.personalTitle = (this.father != null ? this.father : this.mother).personalTitle;
            return;
        }
    }

    public void randomPersonalTitles(double noSpecProb) throws SQLException {
        if ((double)this.rng.nextFloat() < noSpecProb) {
            this.personalTitle = -1;
        } else {
            Set<Integer> personalTitles = Title.getPersonalTitles(this.commonData).keySet();
            ArrayList<Integer> ids = new ArrayList<Integer>();
            for (Integer i : personalTitles) {
                ids.add(i);
            }
            this.personalTitle = (Integer)Utility.randomPick(ids);
        }
    }

    public void createUniquePersonalTitle(int lo, int hi) throws IOException, SQLException {
        double mean = (double)(lo + hi) / 2.0;
        double var = (double)hi - mean;
        this.personalTitle = Title.getCreatedTitle(this.commonData, 7, (int)Utility.randGaussian(mean, var), false);
    }

    public void battleTitleFromParent(double noSpecProb, int inherit) throws SQLException {
        this.randomBattleTitles(noSpecProb);
        if (this.father != null && this.mother != null) {
            if (Utility.probTestPercentage(inherit * 2)) {
                this.battleTitle = (Utility.probTestPercentage((double)50.0) ? this.father : this.mother).battleTitle;
                return;
            }
        } else if (Utility.probTestPercentage(inherit)) {
            this.battleTitle = (this.father != null ? this.father : this.mother).battleTitle;
            return;
        }
    }

    public void randomBattleTitles(double noSpecProb) throws SQLException {
        if ((double)this.rng.nextFloat() < noSpecProb) {
            this.battleTitle = -1;
        } else {
            Set<Integer> battleTitles = Title.getBattleTitles(this.commonData).keySet();
            ArrayList<Integer> ids = new ArrayList<Integer>();
            for (Integer i : battleTitles) {
                ids.add(i);
            }
            this.battleTitle = (Integer)Utility.randomPick(ids);
        }
    }

    public void createUniqueBattleTitle(int lo, int hi) throws IOException, SQLException {
        double mean = (double)(lo + hi) / 2.0;
        double var = (double)hi - mean;
        this.battleTitle = Title.getCreatedTitle(this.commonData, 7, (int)Utility.randGaussian(mean, var), true);
    }

    public void clearSpecial() {
        this.skill.clear();
    }

    public void placeInBuildingUnemployed(List<Building> allBuildings) {
        this.building = Utility.randomPick(allBuildings);
        this.building.unemployedOfficers.add(this);
    }

    public void joinFaction(Building b, Officer king, int loyaltyLo, int loyaltyHi, boolean strongHiLoyalty) {
        this.joinFaction(b, king, loyaltyLo, loyaltyHi, strongHiLoyalty, true);
    }

    public void joinFaction(Building b, Officer king, int loyaltyLo, int loyaltyHi, boolean strongHiLoyalty, boolean employ) {
        this.loyalty = Utility.randBetween(loyaltyLo, loyaltyHi);
        this.king = king;
        if (this.building != null) {
            this.building.unemployedOfficers.remove(this);
        }
        this.building = b;
        if (employ) {
            this.building.officers.add(this);
            this.employed = true;
        } else {
            this.building.unemployedOfficers.add(this);
        }
        if (king != null) {
            this.ensureIdealTendency(king);
        }
        if (this.strong && strongHiLoyalty) {
            this.loyalty = 999;
        }
    }

    public void ensureIdealTendency(Officer king) {
        if (this.getPersonAttachmentDifference(king, 150) > personalConsiderationAttachment.get(this.personalityConsideration)) {
            int maxVar = personalConsiderationAttachment.get(this.personalityConsideration);
            this.personAttachment = (Utility.randBetween(king.personAttachment - maxVar, king.personAttachment + maxVar) + 150) % 150;
        }
    }

    public void setLocationFromParent(int lo, int hi) {
        if (this.isAvailable()) {
            if (this.father != null) {
                if (this.father.building != null) {
                    this.joinFaction(this.father.building, this.father.king, lo, hi, this.father.employed);
                }
            } else if (this.mother.building != null) {
                this.joinFaction(this.mother.building, this.mother.king, lo, hi, this.mother.employed);
            }
        }
    }

    public void setFace(Database db) {
        if (!this.getGender()) {
            List<Integer> list = db.getMaleface();
            this.setFace(list.get(maleFaceIndex % list.size()));
            ++maleFaceIndex;
        } else {
            List<Integer> list = db.getFemaleface();
            this.setFace(list.get(femaleFaceIndex % list.size()));
            ++femaleFaceIndex;
        }
    }

    public void setTypedFace(Database db) {
        if (!this.getGender()) {
            if (this.getLeadership() < 50 && this.getMight() < 50 && this.getIntelligence() < 50 && this.getPolitics() < 50 && this.getGlamour() < 50) {
                List<Integer> list = db.getMaleFaceU();
                this.setFace(list.get(maleFaceUIndex % list.size()));
                ++maleFaceUIndex;
            } else if (this.getLeadership() + this.getMight() > this.getIntelligence() + this.getPolitics()) {
                List<Integer> list = db.getMaleFaceM();
                this.setFace(list.get(maleFaceMIndex % list.size()));
                ++maleFaceMIndex;
            } else {
                List<Integer> list = db.getMaleFaceA();
                this.setFace(list.get(maleFaceAIndex % list.size()));
                ++maleFaceAIndex;
            }
        } else if (this.getLeadership() + this.getMight() > this.getIntelligence() + this.getPolitics()) {
            List<Integer> list = db.getFemaleFaceM();
            this.setFace(list.get(femaleFaceMIndex % list.size()));
            ++femaleFaceMIndex;
        } else {
            List<Integer> list = db.getFemaleFaceA();
            this.setFace(list.get(femaleFaceAIndex % list.size()));
            ++femaleFaceAIndex;
        }
    }

    public void randomImitateOfficers(List<Officer> allOfficers, double prob) {
        while (Utility.probTestPercentage(prob)) {
            this.imitateOfficer.add(Utility.randomPick(allOfficers));
        }
    }

    public void randomHateOfficers(List<Officer> allOfficers, double prob) {
        while (Utility.probTestPercentage(prob)) {
            this.hateOfficer.add(Utility.randomPick(allOfficers));
        }
    }

    public void imitateFamilyOfficers(List<Officer> allOfficers, double spouse, double close, double blood) {
        if (Utility.probTestPercentage(spouse)) {
            this.imitateOfficer.add(this.spouse);
        }
        for (Officer o : allOfficers) {
            if ((o.father != null && o.father.id == this.id || o.mother != null && o.mother.id == this.id || this.father != null && this.father.id == o.id || this.mother != null && this.mother.id == o.id || o.father != null && this.father != null && o.father.id == this.father.id || o.mother != null && this.mother != null && o.mother.id == this.mother.id) && Utility.probTestPercentage(close)) {
                this.imitateOfficer.add(o);
            }
            if (o.blood != this.blood || !Utility.probTestPercentage(blood)) continue;
            this.imitateOfficer.add(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOfficer(Connection conn) throws SQLException {
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("insert into Person (ID, Available, Alive, SurName, GivenName, CalledName, Sex, Pic, Ideal, IdealTendency, PCharacter, YearAvailable, YearBorn, YearDead, DeadReason, Strength, Command, Intelligence, Politics, Glamour, Reputation, Braveness, Calmness, Loyalty, BornRegion, AvailableLocation, PersonalLoyalty, Ambition,Qualification, ValuationOnGovernment, StrategyTendency, Skills, PersonalTitle, CombatTitle, Stunts, Strain, Father, Mother, Spouse, Brother, Generation, LeaderPossibility, ClosePersons, HatedPersons) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            pstmt.setInt(1, this.id);
            pstmt.setBoolean(2, this.debutted);
            pstmt.setBoolean(3, this.living);
            pstmt.setString(4, this.surname);
            pstmt.setString(5, this.givenname);
            pstmt.setString(6, this.calledname);
            pstmt.setBoolean(7, this.gender);
            pstmt.setInt(8, this.face);
            pstmt.setInt(9, this.personAttachment);
            pstmt.setInt(10, this.personalityConsideration);
            pstmt.setInt(11, this.personality);
            pstmt.setInt(12, this.debut);
            pstmt.setInt(13, this.born);
            pstmt.setInt(14, this.dead);
            pstmt.setInt(15, this.deadReason);
            pstmt.setInt(16, this.might);
            pstmt.setInt(17, this.leadership);
            pstmt.setInt(18, this.intelligence);
            pstmt.setInt(19, this.politics);
            pstmt.setInt(20, this.glamour);
            pstmt.setInt(21, this.popularity);
            pstmt.setInt(22, this.gut);
            pstmt.setInt(23, this.calm);
            pstmt.setInt(24, this.loyalty);
            pstmt.setInt(25, this.bornLocation);
            pstmt.setInt(26, this.debutLocation);
            pstmt.setInt(27, this.righteous);
            pstmt.setInt(28, this.ambition);
            pstmt.setInt(29, this.officerTendency);
            pstmt.setInt(30, this.hanAttitude);
            pstmt.setInt(31, this.stretagicalAttitude);
            pstmt.setString(32, Utility.join(this.skill.toArray(), " "));
            pstmt.setInt(33, this.personalTitle);
            pstmt.setInt(34, this.battleTitle);
            pstmt.setString(35, Utility.join(this.stunt.toArray(), " "));
            pstmt.setInt(36, this.blood);
            pstmt.setInt(37, this.father == null ? -1 : this.father.id);
            pstmt.setInt(38, this.mother == null ? -1 : this.mother.id);
            pstmt.setInt(39, this.spouse == null ? -1 : this.spouse.id);
            pstmt.setInt(40, this.brother == null ? -1 : this.brother.id);
            pstmt.setInt(41, this.generation);
            pstmt.setBoolean(42, this.leaderPossibility);
            pstmt.setString(43, Utility.join(Officer.officerIds(this.imitateOfficer).toArray(), " "));
            pstmt.setString(44, Utility.join(Officer.officerIds(this.hateOfficer).toArray(), " "));
            pstmt.executeUpdate();
        }
        finally {
            pstmt.close();
        }
    }

    public static List<Integer> officerIds(List<Officer> o) {
        ArrayList<Integer> r = new ArrayList<Integer>();
        for (Officer i : o) {
            if (i == null) continue;
            r.add(i.id);
        }
        return r;
    }

    public int getLeadership() {
        return this.leadership;
    }

    public int getMight() {
        return this.might;
    }

    public int getIntelligence() {
        return this.intelligence;
    }

    public int getPolitics() {
        return this.politics;
    }

    public int getGlamour() {
        return this.glamour;
    }

    public static String toListStr(Collection<Officer> t) {
        int[] r = new int[t.size()];
        Iterator<Officer> it = t.iterator();
        int i = 0;
        while (it.hasNext()) {
            r[i++] = it.next().id;
        }
        return Utility.join(r, " ");
    }

    public void setKing(boolean b) {
        this.isKing = b;
    }

    public boolean isKing() {
        return this.isKing;
    }

    static {
        maxIdealTendencyId = -1;
        maleFaceIndex = 0;
        femaleFaceIndex = 0;
        maleFaceAIndex = 0;
        maleFaceMIndex = 0;
        maleFaceUIndex = 0;
        femaleFaceAIndex = 0;
        femaleFaceMIndex = 0;
    }
}

