/*
 * Decompiled with CFR 0.152.
 */
package CSanScenGenerator;

import CSanScenGenerator.Building;
import CSanScenGenerator.Faction;
import CSanScenGenerator.Officer;
import CSanScenGenerator.Point;
import CSanScenGenerator.Utility;
import CSanScenGenerator.frontend.Frontend;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Team {
    protected int id;
    protected String name;
    protected List<Building> buildings;
    protected Faction faction;

    public Team(int id) {
        this.id = id;
        this.buildings = new ArrayList<Building>();
    }

    public List<Building> populateOfficers(Faction belongFaction, int cityCnt, boolean connectedCity, List<Building> allBuildings, List<Officer> officers, Officer king, int loyaltyLo, int loyaltyHi, boolean strongHiLoyalty) {
        List<Building> pick;
        ArrayList<Building> candidate = new ArrayList<Building>();
        for (Building i : allBuildings) {
            if (i.type != 1 || i.team != null) continue;
            candidate.add(i);
        }
        if (cityCnt > candidate.size()) {
            return new ArrayList<Building>();
        }
        if (!connectedCity) {
            pick = Utility.subset(candidate, cityCnt);
        } else {
            pick = new ArrayList();
            pick.add((Building)Utility.randomPick(candidate));
            for (int i = 1; i < cityCnt; ++i) {
                Building extendFrom = (Building)Utility.randomPick(pick);
                ArrayList<Building> connectedCandidate = new ArrayList<Building>();
                if (extendFrom.connectedLandCity != null && extendFrom.connectedWaterCity != null) {
                    Building b;
                    int j;
                    Iterator<Object> i$ = extendFrom.connectedLandCity.iterator();
                    while (i$.hasNext()) {
                        j = (Integer)i$.next();
                        b = Building.getBuildingFromId(allBuildings, j);
                        if (b.team != null || pick.contains(b)) continue;
                        connectedCandidate.add(b);
                    }
                    i$ = extendFrom.connectedWaterCity.iterator();
                    while (i$.hasNext()) {
                        j = (Integer)i$.next();
                        b = Building.getBuildingFromId(allBuildings, j);
                        if (b.team != null || pick.contains(b)) continue;
                        connectedCandidate.add(b);
                    }
                } else {
                    for (Building b : allBuildings) {
                        if (Point.distance((Point)b.location.toArray()[0], (Point)extendFrom.location.toArray()[0]) >= 50 || b.team != null || pick.contains(b)) continue;
                        connectedCandidate.add(b);
                    }
                }
                if (connectedCandidate.size() <= 0) continue;
                pick.add((Building)Utility.randomPick(connectedCandidate));
            }
        }
        this.buildings.addAll(pick);
        this.name = ((Building)Utility.randomPick(pick)).name + (Frontend.isTc() ? "\u8ecd\u5340" : "\u519b\u533a");
        for (int i = 0; i < officers.size(); ++i) {
            Utility.randomPick(this.buildings).populateOfficers(this, officers.get(i), king, loyaltyLo, loyaltyHi, strongHiLoyalty);
        }
        this.faction = belongFaction;
        return pick;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTeam(Connection conn) throws SQLException {
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("insert into Sections (ID, Name, Architectures, AIDetail) values (?, ?, ?, 1)");
            pstmt.setInt(1, this.id);
            pstmt.setString(2, this.name);
            pstmt.setString(3, Building.toListStr(this.buildings));
            pstmt.executeUpdate();
        }
        finally {
            pstmt.close();
        }
    }

    public static String toListStr(List<Team> t) {
        int[] r = new int[t.size()];
        for (int i = 0; i < t.size(); ++i) {
            r[i] = t.get((int)i).id;
        }
        return Utility.join(r, " ");
    }

    public static String toListBuildingStr(List<Team> t) {
        ArrayList<Building> b = new ArrayList<Building>();
        for (Team i : t) {
            b.addAll(i.buildings);
        }
        return Building.toListStr(b);
    }
}

