/*
 * Decompiled with CFR 0.152.
 */
package CSanScenGenerator;

import CSanScenGenerator.InfluenceRate;
import CSanScenGenerator.Utility;
import CSanScenGenerator.frontend.Frontend;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Title {
    private static Map<Integer, Title> personalTitle;
    private static Map<Integer, Title> battleTitle;
    private int id;
    private int level;
    private boolean battle;
    private String name;
    private String description;
    private String conditionString;
    private List<Integer> influences;
    private List<Integer> conditions;
    private static final int CREATED_TITLE_ID_ABOVE = 1000;
    private static int autoId;
    private static List<String> nameList;

    private Title(int inId, int inLevel, boolean inBattle, String inName, String inDescription, String inConditionString, String inInfluences, String inConditions) {
        this.id = inId;
        this.level = inLevel;
        this.battle = inBattle;
        this.name = inName;
        this.description = inDescription;
        this.conditionString = inConditionString;
        this.influences = Utility.fromIntListToList(inInfluences);
        this.conditions = Utility.fromIntListToList(inConditions);
    }

    private Title(int inId, int inLevel, boolean inBattle, String inName, String inDescription, String inConditionString, List<Integer> inInfluences, List<Integer> inConditions) {
        this.id = inId;
        this.level = inLevel;
        this.battle = inBattle;
        this.name = inName;
        this.description = inDescription;
        this.conditionString = inConditionString;
        this.influences = inInfluences;
        this.conditions = inConditions;
    }

    public static Map<Integer, Title> getPersonalTitles(Connection commonData) throws SQLException {
        if (personalTitle == null) {
            Statement stmt = commonData.createStatement();
            ResultSet rs = stmt.executeQuery("select * from Title where kind = 0 and ID < 1000");
            personalTitle = new HashMap<Integer, Title>();
            while (rs.next()) {
                int id = rs.getInt("ID");
                personalTitle.put(id, new Title(id, rs.getInt("Level"), rs.getBoolean("Combat"), rs.getString("Name"), rs.getString("Description"), rs.getString("Prerequisite"), rs.getString("Influences"), rs.getString("Conditions")));
            }
            rs.close();
            stmt.close();
        }
        return personalTitle;
    }

    public static Map<Integer, Title> getBattleTitles(Connection commonData) throws SQLException {
        if (battleTitle == null) {
            Statement stmt = commonData.createStatement();
            ResultSet rs = stmt.executeQuery("select * from Title where kind = 1 and ID < 1000");
            battleTitle = new HashMap<Integer, Title>();
            while (rs.next()) {
                int id = rs.getInt("ID");
                battleTitle.put(id, new Title(id, rs.getInt("Level"), rs.getBoolean("Combat"), rs.getString("Name"), rs.getString("Description"), rs.getString("Prerequisite"), rs.getString("Influences"), rs.getString("Conditions")));
            }
            rs.close();
            stmt.close();
        }
        return battleTitle;
    }

    public static int getCreatedTitle(Connection commonData, int type, int level, boolean battle) throws IOException, SQLException {
        Title.getPersonalTitles(commonData);
        Title.getBattleTitles(commonData);
        int id = autoId++;
        int lv = Math.max(1, level);
        if (nameList == null) {
            String s;
            nameList = new ArrayList<String>();
            BufferedReader f = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("DATA/" + (Frontend.isTc() ? "" : "GBK/") + "treasureName.txt"), "UTF8"));
            while ((s = f.readLine()) != null) {
                nameList.add(s);
            }
        }
        String name = "";
        int nameLen = Utility.randBetween(2, 5);
        for (int i = 0; i < nameLen; ++i) {
            name = name + Utility.randomPick(nameList);
        }
        switch (type) {
            case 0: 
            case 1: {
                name = name + "\u5c07";
                break;
            }
            case 2: {
                name = name + "\u8a08";
                break;
            }
            case 3: {
                name = name + "\u540f";
                break;
            }
            case 5: {
                name = name + "\u96c4";
            }
        }
        StringBuilder descriptionBuilder = new StringBuilder();
        String prereq = "\u5929\u751f";
        ArrayList<Integer> influences = new ArrayList<Integer>();
        ArrayList<Integer> leaderInfluences = new ArrayList<Integer>();
        boolean combat = false;
        int remainValue = level * level * 20 + 20;
        int trials = 0;
        while (trials < 1000) {
            boolean leaderOnly;
            ++trials;
            Map<Integer, Integer> influencesProb = InfluenceRate.getTitleRates(commonData, type, battle);
            int influence = Utility.randomCategorize(influencesProb);
            int actualValue = InfluenceRate.getActualValue(commonData, influence);
            boolean bl = leaderOnly = battle && Utility.probTestPercentage(InfluenceRate.getLeaderProb(commonData, influence));
            if (actualValue <= remainValue && (leaderOnly || (double)actualValue * 1.5 <= (double)remainValue) && !influences.contains(influence)) {
                remainValue -= actualValue;
                if (leaderOnly) {
                    leaderInfluences.add(influence);
                } else {
                    influences.add(influence);
                }
                if (InfluenceRate.isBattle(commonData, influence)) {
                    combat = true;
                }
                if (!leaderOnly) {
                    remainValue -= actualValue / 2;
                }
                descriptionBuilder.append("\u3002").append(InfluenceRate.getDescription(commonData, influence));
            }
            if (remainValue > 10) continue;
            break;
        }
        List<Integer> condition = Collections.singletonList(900);
        if (!leaderInfluences.isEmpty()) {
            influences.add(281);
            influences.addAll(leaderInfluences);
        }
        if (battle) {
            battleTitle.put(id, new Title(id, lv, combat, name, descriptionBuilder.toString(), prereq, influences, condition));
        } else {
            personalTitle.put(id, new Title(id, lv, combat, name, descriptionBuilder.toString(), prereq, influences, condition));
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTitles(Connection commonData) throws SQLException {
        commonData.createStatement().executeUpdate("delete from Title");
        Statement pstmt = null;
        try {
            if (personalTitle == null) {
                Title.getPersonalTitles(commonData);
            }
            if (battleTitle == null) {
                Title.getBattleTitles(commonData);
            }
            for (Title t : personalTitle.values()) {
                pstmt = commonData.prepareStatement("insert into Title (ID, Kind, \"Level\", Combat, Name, Description, Prerequisite, Influences, Conditions) values (?, ?, ?, ?, ?, ?, ?, ?, ?)");
                pstmt.setInt(1, t.id);
                pstmt.setInt(2, 0);
                pstmt.setInt(3, t.level);
                pstmt.setBoolean(4, t.battle);
                pstmt.setString(5, t.name);
                pstmt.setString(6, t.description);
                pstmt.setString(7, t.conditionString);
                pstmt.setString(8, Utility.join(t.influences.toArray(), " "));
                pstmt.setString(9, Utility.join(t.conditions.toArray(), " "));
                pstmt.executeUpdate();
            }
            for (Title t : battleTitle.values()) {
                pstmt = commonData.prepareStatement("insert into Title (ID, Kind, \"Level\", Combat, Name, Description, Prerequisite, Influences, Conditions) values (?, ?, ?, ?, ?, ?, ?, ?, ?)");
                pstmt.setInt(1, t.id);
                pstmt.setInt(2, 1);
                pstmt.setInt(3, t.level);
                pstmt.setBoolean(4, t.battle);
                pstmt.setString(5, t.name);
                pstmt.setString(6, t.description);
                pstmt.setString(7, t.conditionString);
                pstmt.setString(8, Utility.join(t.influences.toArray(), " "));
                pstmt.setString(9, Utility.join(t.conditions.toArray(), " "));
                pstmt.executeUpdate();
            }
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
            }
        }
    }

    static {
        autoId = 1000;
    }
}

