/*
 * Decompiled with CFR 0.152.
 */
package CSanScenGenerator;

import CSanScenGenerator.Building;
import CSanScenGenerator.InfluenceRate;
import CSanScenGenerator.Officer;
import CSanScenGenerator.Utility;
import CSanScenGenerator.frontend.Frontend;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Treasure {
    public static final int WEAPON = 0;
    public static final int BOOK = 1;
    public static final int HORSE = 2;
    private int id = autoId++;
    private String name;
    private int pic;
    private int value;
    private boolean appeared;
    private Building hiddenArch;
    private int appearYear;
    private Officer belongTo;
    private Set<Integer> influences;
    private String desc;
    private int type;
    private static List<String> nameList;
    private static int autoId;

    public Treasure(int type) throws IOException {
        this.type = type;
        if (nameList == null) {
            String s;
            nameList = new ArrayList<String>();
            BufferedReader f = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("DATA/" + (Frontend.isTc() ? "" : "GBK/") + "treasureName.txt"), "UTF8"));
            while ((s = f.readLine()) != null) {
                nameList.add(s);
            }
        }
        this.name = "";
        int nameLen = Utility.randBetween(2, 5);
        for (int i = 0; i < nameLen; ++i) {
            this.name = this.name + Utility.randomPick(nameList);
        }
        switch (type) {
            case 0: {
                this.name = this.name + Utility.randomPick(new String[]{"\u528d", "\u69cd", "\u5f13", "\u77db", "\u5200"});
                this.pic = Utility.randBetween(0, 16);
                break;
            }
            case 1: {
                this.name = this.name + Utility.randomPick(new String[]{"\u66f8", "\u5377"});
                this.pic = Utility.randBetween(100, 110);
                break;
            }
            case 2: {
                this.name = this.name + "\u99ac";
                this.pic = Utility.randBetween(300, 304);
            }
        }
        this.influences = new HashSet<Integer>();
        this.desc = "";
    }

    public void randomize(Connection commonData, int value, int year, double priceRate) throws IOException, SQLException {
        this.value = value;
        this.appearYear = year;
        Map<Integer, Integer> influencesProb = null;
        switch (this.type) {
            case 0: {
                influencesProb = InfluenceRate.getWeaponRates(commonData);
                break;
            }
            case 1: {
                influencesProb = InfluenceRate.getBookRates(commonData);
                break;
            }
            case 2: {
                influencesProb = InfluenceRate.getHorseRates(commonData);
            }
        }
        int remainValue = value * 5;
        int trials = 0;
        while (trials < 1000) {
            ++trials;
            int influence = Utility.randomCategorize(influencesProb);
            int actualValue = InfluenceRate.getActualValue(commonData, influence);
            if (actualValue <= remainValue) {
                remainValue -= actualValue;
                this.influences.add(influence);
            }
            if (remainValue >= 10) continue;
            break;
        }
        if (this.type == 2) {
            this.influences.add(5110);
        }
    }

    public void place(double someoneHoldProb, int scenYear, List<Officer> allOfficers, List<Building> allBuildings) {
        if (this.appearYear < scenYear) {
            if (Utility.probTestPercentage(someoneHoldProb)) {
                this.belongTo = Utility.randomPick(allOfficers);
                this.appeared = true;
            } else {
                this.hiddenArch = Utility.randomPick(allBuildings);
                this.appeared = false;
            }
        } else {
            this.hiddenArch = Utility.randomPick(allBuildings);
            this.appeared = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTreasure(Connection conn) throws SQLException {
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("insert into Treasure (ID, Name, Pic, Worth, Available, HidePlace, AppearYear, BelongedPerson, Influences) values (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            pstmt.setInt(1, this.id);
            pstmt.setString(2, this.name);
            pstmt.setInt(3, this.pic);
            pstmt.setInt(4, this.value);
            pstmt.setBoolean(5, this.appeared);
            pstmt.setInt(6, this.hiddenArch == null ? -1 : this.hiddenArch.id);
            pstmt.setInt(7, this.appearYear);
            pstmt.setInt(8, this.belongTo == null ? -1 : this.belongTo.id);
            pstmt.setString(9, Utility.join(this.influences.toArray(), " "));
            pstmt.executeUpdate();
        }
        finally {
            pstmt.close();
        }
    }

    static {
        autoId = 0;
    }
}

