/*
 * Decompiled with CFR 0.152.
 */
package CSanScenGenerator;

import CSanScenGenerator.Database;
import CSanScenGenerator.Officer;
import CSanScenGenerator.Title;
import CSanScenGenerator.Utility;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TypedOfficer
extends Officer {
    public static final int GENERAL = 0;
    public static final int MIGHTY = 1;
    public static final int ADVISOR = 2;
    public static final int POLITICIAN = 3;
    public static final int INTEL_GENERAL = 4;
    public static final int EMPEROR = 5;
    public static final int ALL_ROUNDER = 6;
    public static final int NORMAL = 7;
    public static final int CHEAP = 8;
    public static final int NUMBER_OF_TYPES = 9;
    private int type;
    private static Map<Integer, int[]> skillProb = null;
    private static Map<Integer, Map<String, String>> skillCond = null;
    private static Map<Integer, int[]> stuntProb = null;
    private static Map<Integer, Map<String, String>> stuntCond = null;
    private static Map<Integer, int[]> personalTitleProb = null;
    private static Map<Integer, Map<String, String>> personalTitleCond = null;
    private static Map<Integer, int[]> battleTitleProb = null;
    private static Map<Integer, Map<String, String>> battleTitleCond = null;

    public TypedOfficer(Database indb, int intype, int id, boolean strong, Connection commonData) throws SQLException {
        super(indb, id, strong, commonData);
        this.type = intype;
    }

    @Override
    public void randomAbility(double mul, double abs, int loCap, int hiCap) {
        switch (this.type) {
            case 0: {
                this.leadership = (int)Utility.randGaussian(85.0, 15.0);
                this.might = (int)Utility.randGaussian(85.0, 15.0);
                this.intelligence = (int)Utility.randGaussian(50.0, 20.0);
                this.politics = (int)Utility.randGaussian(40.0, 20.0);
                this.glamour = (int)Utility.randGaussian(60.0, 30.0);
                break;
            }
            case 1: {
                this.leadership = (int)Utility.randGaussian(55.0, 15.0);
                this.might = (int)Utility.randGaussian(90.0, 10.0);
                this.intelligence = (int)Utility.randGaussian(25.0, 15.0);
                this.politics = (int)Utility.randGaussian(15.0, 15.0);
                this.glamour = (int)Utility.randGaussian(30.0, 30.0);
                break;
            }
            case 2: {
                this.leadership = (int)Utility.randGaussian(80.0, 20.0);
                this.might = (int)Utility.randGaussian(35.0, 35.0);
                this.intelligence = (int)Utility.randGaussian(90.0, 10.0);
                this.politics = (int)Utility.randGaussian(85.0, 15.0);
                this.glamour = (int)Utility.randGaussian(80.0, 20.0);
                break;
            }
            case 3: {
                this.leadership = (int)Utility.randGaussian(25.0, 25.0);
                this.might = (int)Utility.randGaussian(20.0, 20.0);
                this.intelligence = (int)Utility.randGaussian(85.0, 15.0);
                this.politics = (int)Utility.randGaussian(90.0, 10.0);
                this.glamour = (int)Utility.randGaussian(50.0, 50.0);
                break;
            }
            case 4: {
                this.leadership = (int)Utility.randGaussian(85.0, 15.0);
                this.might = (int)Utility.randGaussian(85.0, 15.0);
                this.intelligence = (int)Utility.randGaussian(85.0, 15.0);
                this.politics = (int)Utility.randGaussian(25.0, 25.0);
                this.glamour = (int)Utility.randGaussian(60.0, 30.0);
                break;
            }
            case 5: {
                this.leadership = (int)Utility.randGaussian(80.0, 20.0);
                this.might = (int)Utility.randGaussian(50.0, 20.0);
                this.intelligence = (int)Utility.randGaussian(80.0, 20.0);
                this.politics = (int)Utility.randGaussian(80.0, 20.0);
                this.glamour = (int)Utility.randGaussian(90.0, 10.0);
                break;
            }
            case 6: {
                this.leadership = (int)Utility.randGaussian(85.0, 15.0);
                this.might = (int)Utility.randGaussian(85.0, 15.0);
                this.intelligence = (int)Utility.randGaussian(85.0, 15.0);
                this.politics = (int)Utility.randGaussian(85.0, 15.0);
                this.glamour = (int)Utility.randGaussian(85.0, 15.0);
                break;
            }
            case 7: {
                this.leadership = (int)Utility.randGaussian(60.0, 15.0);
                this.might = (int)Utility.randGaussian(60.0, 15.0);
                this.intelligence = (int)Utility.randGaussian(60.0, 15.0);
                this.politics = (int)Utility.randGaussian(60.0, 15.0);
                this.glamour = (int)Utility.randGaussian(60.0, 15.0);
                break;
            }
            case 8: {
                this.leadership = (int)Utility.randGaussian(25.0, 25.0);
                this.might = (int)Utility.randGaussian(25.0, 25.0);
                this.intelligence = (int)Utility.randGaussian(25.0, 25.0);
                this.politics = (int)Utility.randGaussian(25.0, 25.0);
                this.glamour = (int)Utility.randGaussian(25.0, 25.0);
            }
        }
        this.leadership = (int)((double)this.leadership * mul + abs);
        this.might = (int)((double)this.might * mul + abs);
        this.intelligence = (int)((double)this.intelligence * mul + abs);
        this.politics = (int)((double)this.politics * mul + abs);
        this.glamour = (int)((double)this.glamour * mul + abs);
        if (!this.strong) {
            this.leadership = Utility.cap(this.leadership, loCap, hiCap);
            this.might = Utility.cap(this.might, loCap, hiCap);
            this.intelligence = Utility.cap(this.intelligence, loCap, hiCap);
            this.politics = Utility.cap(this.politics, loCap, hiCap);
            this.glamour = Utility.cap(this.glamour, loCap, hiCap);
        }
    }

    private static void readSetting(String fileName, Map<Integer, int[]> probs, Map<Integer, Map<String, String>> conds) {
        BufferedReader file = null;
        try {
            file = new BufferedReader(new FileReader(fileName));
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            return;
        }
        try {
            String s;
            while ((s = file.readLine()) != null) {
                String[] temps = s.split("\\s");
                int id = Integer.parseInt(temps[0]);
                int[] p = new int[9];
                for (int j = 1; j <= 9; ++j) {
                    p[j - 1] = Integer.parseInt(temps[j]);
                }
                probs.put(id, p);
                HashMap<String, String> map = new HashMap<String, String>(6);
                for (int j = 10; j < temps.length; j += 2) {
                    map.put(temps[j], temps[j + 1]);
                }
                conds.put(id, map);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return;
        }
    }

    private boolean testConds(Map<String, String> conds) {
        boolean ok = true;
        if (conds != null) {
            for (Map.Entry<String, String> entry : conds.entrySet()) {
                if (entry.getKey().equals("leadership") && this.leadership < Integer.parseInt(entry.getValue())) {
                    ok = false;
                }
                if (entry.getKey().equals("might") && this.might < Integer.parseInt(entry.getValue())) {
                    ok = false;
                }
                if (entry.getKey().equals("intelligence") && this.intelligence < Integer.parseInt(entry.getValue())) {
                    ok = false;
                }
                if (entry.getKey().equals("politics") && this.politics < Integer.parseInt(entry.getValue())) {
                    ok = false;
                }
                if (entry.getKey().equals("glamour") && this.glamour < Integer.parseInt(entry.getValue())) {
                    ok = false;
                }
                if (entry.getKey().equals("total") && this.leadership + this.might + this.intelligence + this.politics + this.glamour < Integer.parseInt(entry.getValue())) {
                    ok = false;
                }
                if (entry.getKey().equals("popularity") && this.popularity < Integer.parseInt(entry.getValue())) {
                    ok = false;
                }
                if (!entry.getKey().equals("gender")) continue;
                if (entry.getValue().equals("male")) {
                    if (!this.gender) continue;
                    ok = false;
                    continue;
                }
                if (!entry.getValue().equals("female") || this.gender) continue;
                ok = false;
            }
        }
        return ok;
    }

    @Override
    public void randomSpecials(double rate, int abyThreshold, double abyRate) {
        this.randomSpecials(rate, abyThreshold, abyRate, this.type);
    }

    public void randomSpecials(double rate, int abyThreshold, double abyRate, int officerType) {
        block16: {
            int swapArmy;
            int[] nArray;
            boolean[][] armySkill;
            block18: {
                block17: {
                    block15: {
                        this.skill.clear();
                        if (skillProb == null) {
                            skillProb = new HashMap<Integer, int[]>();
                            skillCond = new HashMap<Integer, Map<String, String>>();
                            TypedOfficer.readSetting("DATA/special.txt", skillProb, skillCond);
                        }
                        HashMap<Integer, Integer> prob = new HashMap<Integer, Integer>();
                        for (Map.Entry<Integer, int[]> entry : skillProb.entrySet()) {
                            prob.put(entry.getKey(), entry.getValue()[officerType]);
                        }
                        for (Map.Entry<Integer, Object> entry : prob.entrySet()) {
                            if (!Utility.probTestPercentage((double)((Integer)entry.getValue()).intValue() * rate / 5.0 * (this.maxAbility() <= abyThreshold ? 1.0 : (double)(this.maxAbility() - abyThreshold) / (100.0 - (double)abyThreshold) * (abyRate - 1.0) + 1.0)) || !this.testConds(skillCond.get(entry.getKey()))) continue;
                            this.skill.add(entry.getKey());
                        }
                        armySkill = new boolean[4][7];
                        nArray = new int[4];
                        for (int i = 3; i <= 6; ++i) {
                            for (int j = 0; j < 7; ++j) {
                                if (!this.skill.contains(i * 10 + j)) continue;
                                armySkill[i - 3][j] = true;
                                int n = i - 3;
                                nArray[n] = nArray[n] + 1;
                            }
                        }
                        if (nArray[0] <= nArray[1] || nArray[0] <= nArray[2] || nArray[0] <= nArray[3]) break block15;
                        while (Utility.probTestPercentage(60.0)) {
                            swapArmy = Utility.randBetween(4, 6);
                            ArrayList<Integer> candidate = new ArrayList<Integer>();
                            for (int i = 0; i < 7; ++i) {
                                if (!armySkill[swapArmy - 3][i] || armySkill[0][i]) continue;
                                candidate.add(i);
                            }
                            if (candidate.isEmpty()) continue;
                            this.skill.remove(swapArmy * 10 + (Integer)Utility.randomPick(candidate));
                            this.skill.add(30 + (Integer)Utility.randomPick(candidate));
                        }
                        break block16;
                    }
                    if (nArray[1] <= nArray[0] || nArray[1] <= nArray[2] || nArray[1] <= nArray[3]) break block17;
                    while (Utility.probTestPercentage(75.0)) {
                        swapArmy = Utility.randBetween(4, 6);
                        if (swapArmy == 4) {
                            swapArmy = 3;
                        }
                        ArrayList<Integer> candidate = new ArrayList<Integer>();
                        for (int i = 0; i < 7; ++i) {
                            if (!armySkill[swapArmy - 3][i] || armySkill[0][i]) continue;
                            candidate.add(i);
                        }
                        if (candidate.isEmpty()) continue;
                        this.skill.remove(swapArmy * 10 + (Integer)Utility.randomPick(candidate));
                        this.skill.add(40 + (Integer)Utility.randomPick(candidate));
                    }
                    break block16;
                }
                if (nArray[2] <= nArray[0] || nArray[2] <= nArray[1] || nArray[2] <= nArray[3]) break block18;
                while (Utility.probTestPercentage(75.0)) {
                    swapArmy = Utility.randBetween(4, 6);
                    if (swapArmy == 5) {
                        swapArmy = 3;
                    }
                    ArrayList<Integer> candidate = new ArrayList<Integer>();
                    for (int i = 0; i < 7; ++i) {
                        if (!armySkill[swapArmy - 3][i] || armySkill[0][i]) continue;
                        candidate.add(i);
                    }
                    if (candidate.isEmpty()) continue;
                    this.skill.remove(swapArmy * 10 + (Integer)Utility.randomPick(candidate));
                    this.skill.add(50 + (Integer)Utility.randomPick(candidate));
                }
                break block16;
            }
            if (nArray[3] <= nArray[0] || nArray[3] <= nArray[1] || nArray[3] <= nArray[2]) break block16;
            while (Utility.probTestPercentage(75.0)) {
                swapArmy = Utility.randBetween(3, 5);
                ArrayList<Integer> candidate = new ArrayList<Integer>();
                for (int i = 0; i < 7; ++i) {
                    if (!armySkill[swapArmy - 3][i] || armySkill[0][i]) continue;
                    candidate.add(i);
                }
                if (candidate.isEmpty()) continue;
                this.skill.remove(swapArmy * 10 + (Integer)Utility.randomPick(candidate));
                this.skill.add(60 + (Integer)Utility.randomPick(candidate));
            }
        }
    }

    @Override
    public void randomStunts(double rate, int abyThreshold, double abyRate) {
        this.randomStunts(rate, abyThreshold, abyRate, this.type);
    }

    public void randomStunts(double rate, int abyThreshold, double abyRate, int officerType) {
        this.stunt.clear();
        if (stuntProb == null) {
            stuntProb = new HashMap<Integer, int[]>();
            stuntCond = new HashMap<Integer, Map<String, String>>();
            TypedOfficer.readSetting("DATA/stunt.txt", stuntProb, stuntCond);
        }
        HashMap<Integer, Integer> prob = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, int[]> entry : stuntProb.entrySet()) {
            prob.put(entry.getKey(), entry.getValue()[officerType]);
        }
        for (Map.Entry<Integer, Object> entry : prob.entrySet()) {
            if (!Utility.probTestPercentage((double)((Integer)entry.getValue()).intValue() * rate / 5.0 * (this.maxAbility() <= abyThreshold ? 1.0 : (double)(this.maxAbility() - abyThreshold) / (100.0 - (double)abyThreshold) * (abyRate - 1.0) + 1.0)) || !this.testConds(stuntCond.get(entry.getKey()))) continue;
            this.stunt.add(entry.getKey());
        }
    }

    @Override
    public void randomPersonalTitles(double noSpecProb) {
        this.randomPersonalTitles(noSpecProb, this.type);
    }

    public void randomPersonalTitles(double noSpecProb, int officerType) {
        if (personalTitleProb == null) {
            personalTitleProb = new HashMap<Integer, int[]>();
            personalTitleCond = new HashMap<Integer, Map<String, String>>();
            TypedOfficer.readSetting("DATA/personalTitle.txt", personalTitleProb, personalTitleCond);
        }
        HashMap<Integer, Integer> prob = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, int[]> i : personalTitleProb.entrySet()) {
            prob.put(i.getKey(), i.getValue()[officerType]);
        }
        if ((double)this.rng.nextFloat() < noSpecProb) {
            this.personalTitle = -1;
        } else {
            boolean ok;
            int trials = 0;
            do {
                this.personalTitle = Utility.randomCategorize(prob);
            } while (!(ok = this.testConds(personalTitleCond.get(this.personalTitle))) && ++trials < 1000);
            if (!ok) {
                this.personalTitle = -1;
            }
        }
    }

    @Override
    public void createUniquePersonalTitle(int mean, int var) throws IOException, SQLException {
        this.createPersonalTitle((int)Utility.randGaussian(mean, var), this.type);
    }

    public void createPersonalTitle(int level, int officerType) throws IOException, SQLException {
        this.personalTitle = Title.getCreatedTitle(this.commonData, officerType, level, false);
    }

    @Override
    public void randomBattleTitles(double noSpecProb) {
        this.randomBattleTitles(noSpecProb, this.type);
    }

    public void randomBattleTitles(double noSpecProb, int officerType) {
        if (battleTitleProb == null) {
            battleTitleProb = new HashMap<Integer, int[]>();
            battleTitleCond = new HashMap<Integer, Map<String, String>>();
            TypedOfficer.readSetting("DATA/battleTitle.txt", battleTitleProb, battleTitleCond);
        }
        HashMap<Integer, Integer> prob = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, int[]> i : battleTitleProb.entrySet()) {
            prob.put(i.getKey(), i.getValue()[officerType]);
        }
        if ((double)this.rng.nextFloat() < noSpecProb) {
            this.battleTitle = -1;
        } else {
            boolean ok;
            int trials = 0;
            do {
                this.battleTitle = Utility.randomCategorize(prob);
            } while (!(ok = this.testConds(battleTitleCond.get(this.battleTitle))) && ++trials < 1000);
            if (!ok) {
                this.battleTitle = -1;
            }
        }
        boolean[][] armySkill = new boolean[5][7];
        int[] cnt = new int[5];
        for (int i = 3; i <= 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                if (!this.skill.contains(i * 10 + j)) continue;
                armySkill[i - 3][j] = true;
                int n = i - 3;
                cnt[n] = cnt[n] + 1;
            }
        }
        int max = cnt[0];
        int maxType = 0;
        for (int i = 1; i < 5; ++i) {
            if (cnt[i] <= max) continue;
            max = cnt[i];
            maxType = i;
        }
        if (this.battleTitle / 10 == 30 || this.battleTitle / 10 == 32) {
            this.battleTitle = this.battleTitle / 10 + maxType;
        }
    }

    @Override
    public void createUniqueBattleTitle(int mean, int var) throws IOException, SQLException {
        this.createBattleTitle((int)Utility.randGaussian(mean, var), this.type);
    }

    public void createBattleTitle(int level, int officerType) throws IOException, SQLException {
        this.battleTitle = Title.getCreatedTitle(this.commonData, officerType, level, true);
    }

    @Override
    public void randomHiddenValues() {
        this.hanAttitude = Utility.randBetween(0, 2);
        this.officerTendency = Utility.randBetween(0, 4);
        switch (this.type) {
            case 0: {
                this.righteous = Utility.randomCategorize(0.1, 0.2, 0.4, 0.2, 0.1);
                this.ambition = Utility.randomCategorize(0.1, 0.25, 0.3, 0.25, 0.1);
                this.gut = Utility.randomCategorize_i(1, 2, 3, 4, 6, 9, 12, 9, 6) + 1;
                this.calm = Utility.randomCategorize_i(4, 6, 9, 12, 9, 6, 4, 3, 2) + 1;
                this.personality = Utility.randomCategorize(0.15, 0.05, 0.15, 0.2, 0.3, 0.15) + 1;
                break;
            }
            case 1: {
                this.righteous = Utility.randomCategorize(0.05, 0.1, 0.25, 0.3, 0.3);
                this.ambition = Utility.randomCategorize(0.15, 0.25, 0.3, 0.2, 0.1);
                this.gut = Utility.randomCategorize_i(1, 1, 1, 1, 3, 6, 9, 12, 9, 1) + 1;
                this.calm = Utility.randomCategorize_i(12, 9, 6, 4, 2, 1, 1, 1, 1) + 1;
                this.personality = Utility.randomCategorize(0.5, 0.05, 0.1, 0.3, 0.05, 0.1) + 1;
                break;
            }
            case 2: {
                this.righteous = Utility.randomCategorize(0.1, 0.2, 0.4, 0.2, 0.1);
                this.ambition = Utility.randomCategorize(0.1, 0.25, 0.3, 0.25, 0.1);
                this.gut = Utility.randomCategorize_i(2, 4, 9, 6, 4, 2, 1, 1, 1) + 1;
                this.calm = Utility.randomCategorize_i(1, 1, 1, 1, 3, 6, 9, 12, 9, 1) + 1;
                this.personality = Utility.randomCategorize(0.05, 0.15, 0.1, 0.1, 0.15, 0.45) + 1;
                break;
            }
            case 3: {
                this.righteous = Utility.randomCategorize(0.1, 0.2, 0.4, 0.2, 0.1);
                this.ambition = Utility.randomCategorize(0.15, 0.25, 0.3, 0.2, 0.1);
                this.gut = Utility.randomCategorize_i(6, 9, 6, 4, 2, 1, 1, 1, 1) + 1;
                this.calm = Utility.randomCategorize_i(1, 1, 1, 1, 3, 6, 9, 12, 9) + 1;
                this.personality = Utility.randomCategorize(0.05, 0.4, 0.1, 0.05, 0.1, 0.4) + 1;
                break;
            }
            case 4: {
                this.righteous = Utility.randomCategorize(0.1, 0.2, 0.4, 0.2, 0.1);
                this.ambition = Utility.randomCategorize(0.1, 0.2, 0.3, 0.25, 0.15);
                this.gut = Utility.randomCategorize_i(1, 1, 1, 2, 4, 6, 9, 6, 4) + 1;
                this.calm = Utility.randomCategorize_i(1, 1, 1, 2, 4, 6, 9, 6, 4) + 1;
                this.personality = Utility.randomCategorize(0.05, 0.05, 0.15, 0.25, 0.25, 0.25) + 1;
                break;
            }
            case 5: {
                this.righteous = Utility.randomCategorize(0.1, 0.2, 0.4, 0.2, 0.1);
                this.ambition = Utility.randomCategorize(0.05, 0.1, 0.2, 0.3, 0.35);
                this.gut = Utility.randomCategorize_i(1, 2, 4, 6, 9, 6, 4, 2, 1) + 1;
                this.calm = Utility.randomCategorize_i(1, 1, 1, 2, 4, 6, 9, 6, 4) + 1;
                this.personality = Utility.randomCategorize(0.05, 0.05, 0.3, 0.15, 0.15, 0.3) + 1;
                break;
            }
            case 6: {
                this.righteous = Utility.randomCategorize(0.1, 0.2, 0.4, 0.2, 0.1);
                this.ambition = Utility.randomCategorize(0.1, 0.2, 0.3, 0.25, 0.15);
                this.gut = Utility.randomCategorize_i(1, 1, 2, 3, 4, 6, 9, 12, 6, 1) + 1;
                this.calm = Utility.randomCategorize_i(1, 1, 2, 3, 4, 6, 9, 12, 6, 1) + 1;
                this.personality = Utility.randomCategorize(0.025, 0.025, 0.05, 0.3, 0.3, 0.3) + 1;
                break;
            }
            case 7: {
                this.righteous = Utility.randomCategorize(0.1, 0.2, 0.4, 0.2, 0.1);
                this.ambition = Utility.randomCategorize(0.2, 0.3, 0.3, 0.1, 0.1);
                this.gut = Utility.randomCategorize_i(1, 2, 4, 6, 9, 6, 4, 2, 1) + 1;
                this.calm = Utility.randomCategorize_i(1, 2, 4, 6, 9, 6, 4, 2, 1) + 1;
                this.personality = Utility.randomCategorize(0.2, 0.2, 0.1, 0.15, 0.15, 0.2) + 1;
                break;
            }
            case 8: {
                this.righteous = Utility.randomCategorize(0.35, 0.3, 0.2, 0.1, 0.05);
                this.ambition = Utility.randomCategorize(0.35, 0.3, 0.2, 0.1, 0.05);
                this.gut = Utility.randomCategorize_i(12, 9, 6, 4, 1, 1, 1, 1, 1) + 1;
                this.calm = Utility.randomCategorize_i(12, 9, 6, 4, 1, 1, 1, 1, 1) + 1;
                this.personality = Utility.randomCategorize(0.05, 0.6, 0.2, 0.05, 0.05, 0.05) + 1;
            }
        }
        this.personalityConsideration = Utility.randBetween(0, 6);
        this.bornLocation = Utility.randBetween(0, 17);
        int adjust = Utility.randomCategorize(0.05, 0.15, 0.6, 0.15, 0.05) - 2;
        this.stretagicalAttitude = Utility.cap(3 - (this.ambition + adjust), 0, 3);
    }

    public int getType() {
        return this.type;
    }
}

