/*
 * Decompiled with CFR 0.152.
 */
package CSanScenGenerator;

import CSanScenGenerator.Point;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public final class Utility {
    private static Random rng = new Random();

    private Utility() {
    }

    public static int randBetween(int lo, int hi) {
        if (lo > hi) {
            int t = hi;
            hi = lo;
            lo = t;
        }
        return rng.nextInt(hi - lo + 1) + lo;
    }

    public static double randBetween(double lo, double hi) {
        if (lo > hi) {
            double t = hi;
            hi = lo;
            lo = t;
        }
        return rng.nextDouble() * (hi - lo) + lo;
    }

    public static int randBetween_f(double lo, double hi) {
        return Utility.randBetween((int)Math.floor(lo), (int)Math.floor(hi));
    }

    public static long randGaussian(double mean, double var) {
        return Math.round(rng.nextGaussian() * (var / 3.0) + mean);
    }

    public static boolean probTestPercentage(double prob) {
        return prob / 100.0 >= rng.nextDouble();
    }

    public static int cap(int v, int lo, int hi) {
        if (v <= lo) {
            return lo;
        }
        if (v >= hi) {
            return hi;
        }
        return v;
    }

    public static int randomCategorize(double ... v) {
        float p = rng.nextFloat();
        double t = v[0];
        for (int i = 0; i < v.length; ++i) {
            if ((double)p < t) {
                return i;
            }
            if (i + 1 >= v.length) continue;
            t += v[i + 1];
        }
        return v.length;
    }

    public static int randomCategorize_i(int ... v) {
        int sum = 0;
        for (int i = 0; i < v.length; ++i) {
            sum += v[i];
        }
        double[] d = new double[v.length];
        for (int i = 0; i < v.length; ++i) {
            d[i] = (double)v[i] / (double)sum;
        }
        return Utility.randomCategorize(d);
    }

    public static int randomCategorize(Map<Integer, Integer> map) {
        Map.Entry<Integer, Integer> i;
        block0: while (true) {
            int randMax = 0x40000000;
            int sum = 0;
            for (Integer i2 : map.values()) {
                sum += i2.intValue();
            }
            int p = rng.nextInt(randMax);
            int t = 0;
            Iterator<Map.Entry<Integer, Integer>> i$ = map.entrySet().iterator();
            do {
                if (!i$.hasNext()) continue block0;
            } while (p >= (t = (int)((double)t + (double)(i = i$.next()).getValue().intValue() / (double)sum * (double)randMax)));
            break;
        }
        return i.getKey();
    }

    public static boolean inArray(int needle, int[] hayshack) {
        for (int i = 0; i < hayshack.length; ++i) {
            if (needle != hayshack[i]) continue;
            return true;
        }
        return false;
    }

    public static int[] shuffle(int[] a) {
        return Utility.shuffle(a, a.length);
    }

    public static int[] shuffle(int[] a, int n) {
        for (int i = n - 1; i >= 0; --i) {
            int j = Utility.randBetween(0, i);
            int tp = a[j];
            a[j] = a[i];
            a[i] = tp;
        }
        return a;
    }

    public static int[] randomOrder(int n) {
        int[] r = new int[n];
        for (int i = 0; i < n; ++i) {
            r[i] = i;
        }
        return Utility.shuffle(r);
    }

    public static <T> T randomPick(List<T> c) {
        return c.get(Utility.randBetween(0, c.size() - 1));
    }

    public static int randomPick(int[] c) {
        return c[Utility.randBetween(0, c.length - 1)];
    }

    public static <T> T randomPick(T[] c) {
        return c[Utility.randBetween(0, c.length - 1)];
    }

    public static <T> T randomPick(Collection<T> c) {
        int index = Utility.randBetween(0, c.size() - 1);
        int j = 0;
        for (T i : c) {
            if (j == index) {
                return i;
            }
            ++j;
        }
        assert (false);
        return null;
    }

    public static int[] intSubset(int n, int k) {
        if (n < k || n < 0 || k < 0) {
            throw new IllegalArgumentException();
        }
        int chosen = 0;
        int[] result = new int[k];
        if (Utility.probTestPercentage((double)k / (double)n * 100.0)) {
            result[chosen] = 0;
            ++chosen;
        }
        for (int j = 1; j < n; ++j) {
            if (!Utility.probTestPercentage(((double)k - (double)chosen) / (double)(n - j) * 100.0)) continue;
            result[chosen] = j;
            if (++chosen == k) break;
        }
        return result;
    }

    public static <T> List<T> subset(List<T> o, int k) {
        int[] choose = Utility.intSubset(o.size(), k);
        ArrayList<T> t = new ArrayList<T>(k);
        for (int i = 0; i < k; ++i) {
            t.add(o.get(choose[i]));
        }
        return t;
    }

    public static <T> Set<T> subset(Set<T> o, int k) {
        int[] choose = Utility.intSubset(o.size(), k);
        HashSet<T> t = new HashSet<T>(k);
        Iterator<T> it = o.iterator();
        int i = 0;
        int choosei = 0;
        while (it.hasNext()) {
            T elem = it.next();
            if (choose[choosei] == i) {
                t.add(elem);
                if (++choosei >= choose.length) break;
            }
            ++i;
        }
        return t;
    }

    public static String join(Object[] str, String delimiter) {
        StringBuilder res = new StringBuilder(128);
        for (int i = 0; i < str.length; ++i) {
            res.append(i == 0 ? "" : delimiter);
            res.append(str[i]);
        }
        return res.toString();
    }

    public static String join(int[] str, String delimiter) {
        StringBuilder res = new StringBuilder(128);
        for (int i = 0; i < str.length; ++i) {
            res.append(i == 0 ? "" : delimiter).append(str[i]);
        }
        return res.toString();
    }

    public static String joinPoints(Collection<Point> p, String delimiter) {
        StringBuilder res = new StringBuilder(256);
        boolean start = true;
        for (Point i : p) {
            res.append(start ? "" : delimiter).append(i.x).append(delimiter).append(i.y);
            start = false;
        }
        return res.toString();
    }

    public static void copyFile(String src, String dest) throws IOException {
        FileInputStream fis = new FileInputStream(src);
        FileOutputStream fos = new FileOutputStream(dest);
        byte[] b = new byte[4096];
        while (fis.read(b) > 0) {
            fos.write(b);
        }
        fis.close();
        fos.close();
    }

    public static List<Integer> resultSetToId(ResultSet rs) throws SQLException {
        ArrayList<Integer> r = new ArrayList<Integer>();
        while (rs.next()) {
            r.add(rs.getInt("ID"));
        }
        return r;
    }

    public static int[] intListToArray(List<Integer> list) {
        int[] r = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            r[i] = list.get(i);
        }
        return r;
    }

    public static Set<Integer> fromIntListToSet(String s) {
        String[] t = s.split("\\s");
        HashSet<Integer> r = new HashSet<Integer>();
        if (s.isEmpty()) {
            return r;
        }
        for (String i : t) {
            r.add(Integer.parseInt(i));
        }
        return r;
    }

    public static List<Integer> fromIntListToList(String s) {
        String[] t = s.split("\\s");
        ArrayList<Integer> r = new ArrayList<Integer>();
        if (s.isEmpty()) {
            return r;
        }
        for (String i : t) {
            if (i.isEmpty()) continue;
            r.add(Integer.parseInt(i));
        }
        return r;
    }

    public static double roundToSignificantFigures(double num, int n) {
        if (num == 0.0) {
            return 0.0;
        }
        double d = Math.ceil(Math.log10(num < 0.0 ? -num : num));
        int power = n - (int)d;
        double magnitude = Math.pow(10.0, power);
        long shifted = Math.round(num * magnitude);
        return (double)shifted / magnitude;
    }
}

